/*
 * Decompiled with CFR 0.152.
 */
package io.rainfall.utils;

import io.rainfall.TestException;
import io.rainfall.configuration.DistributedConfig;
import io.rainfall.utils.MergeableBitSet;
import io.rainfall.utils.RainfallServerConnection;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RainfallServer
extends Thread {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final DistributedConfig distributedConfig;
    private final ServerSocket serverSocket;
    private Socket socket;
    private AtomicReference<TestException> testException = new AtomicReference();
    private boolean running = true;

    public RainfallServer(DistributedConfig distributedConfig, ServerSocket serverSocket) {
        this.distributedConfig = distributedConfig;
        this.serverSocket = serverSocket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        try {
            this.logger.debug("We started the Rainfall server. We will create a placehodler for clients reports.");
            while (this.running) {
                this.logger.info("[Rainfall Server] Ready - Listening for incoming clients");
                String sessionId = UUID.randomUUID().toString();
                ArrayList<RainfallServerConnection> serverConnectionThreads = new ArrayList<RainfallServerConnection>();
                MergeableBitSet testRunning = new MergeableBitSet(this.distributedConfig.getNbClients());
                int clientId = 0;
                while (!testRunning.isTrue()) {
                    try {
                        this.socket = this.serverSocket.accept();
                        this.logger.info("[Rainfall server] Connection with Rainfall client {} established", (Object)clientId);
                        RainfallServerConnection serverConnectionThread = new RainfallServerConnection(this.distributedConfig.getMasterAddress(), this.socket, testRunning, sessionId, clientId);
                        serverConnectionThread.start();
                        serverConnectionThreads.add(serverConnectionThread);
                        ++clientId;
                        Thread.sleep(500L);
                    }
                    catch (Exception e) {
                        throw new TestException("Connection Error with Rainfall client", e);
                    }
                }
                for (RainfallServerConnection serverConnectionThread : serverConnectionThreads) {
                    serverConnectionThread.startClient();
                }
                for (RainfallServerConnection serverThread : serverConnectionThreads) {
                    try {
                        serverThread.join();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
                try {
                    this.socket.close();
                }
                catch (IOException e) {
                    throw new TestException("Cannot close socket", e);
                    return;
                }
            }
        }
        catch (TestException e) {
            this.testException.set(e);
            return;
        }
        finally {
            try {
                this.closeConnections();
            }
            catch (IOException e) {
                this.logger.debug("[Rainfall server] Issue when shutting down connections", (Throwable)e);
            }
        }
    }

    public void shutdown() {
        this.running = false;
    }

    private void closeConnections() throws IOException {
        if (this.socket != null) {
            this.socket.close();
        }
        if (this.serverSocket != null) {
            this.serverSocket.close();
        }
    }

    public AtomicReference<TestException> getTestException() {
        return this.testException;
    }
}

