/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.auth.ram.injector;

import com.alibaba.nacos.api.exception.runtime.NacosRuntimeException;
import com.alibaba.nacos.client.auth.ram.RamContext;
import com.alibaba.nacos.client.auth.ram.identify.StsConfig;
import com.alibaba.nacos.client.auth.ram.identify.StsCredential;
import com.alibaba.nacos.client.auth.ram.injector.AbstractResourceInjector;
import com.alibaba.nacos.client.auth.ram.utils.SpasAdapter;
import com.alibaba.nacos.client.config.impl.ConfigHttpClientManager;
import com.alibaba.nacos.client.utils.LogUtils;
import com.alibaba.nacos.common.http.HttpRestResult;
import com.alibaba.nacos.common.http.param.Header;
import com.alibaba.nacos.common.http.param.Query;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.plugin.auth.api.LoginIdentityContext;
import com.alibaba.nacos.plugin.auth.api.RequestResource;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Map;
import org.slf4j.Logger;

public class ConfigResourceInjector
extends AbstractResourceInjector {
    private static final Logger LOGGER = LogUtils.logger(ConfigResourceInjector.class);
    private static final String SECURITY_TOKEN_HEADER = "Spas-SecurityToken";
    private static final String ACCESS_KEY_HEADER = "Spas-AccessKey";
    private static final String DEFAULT_RESOURCE = "";
    private StsCredential stsCredential;

    @Override
    public void doInject(RequestResource resource, RamContext context, LoginIdentityContext result) {
        Map<String, String> signHeaders;
        String accessKey = context.getAccessKey();
        String secretKey = context.getSecretKey();
        if (StsConfig.getInstance().isStsOn()) {
            StsCredential stsCredential = this.getStsCredential();
            accessKey = stsCredential.getAccessKeyId();
            secretKey = stsCredential.getAccessKeySecret();
            result.setParameter(SECURITY_TOKEN_HEADER, stsCredential.getSecurityToken());
        }
        if (StringUtils.isNotEmpty((String)accessKey) && StringUtils.isNotBlank((String)secretKey)) {
            result.setParameter(ACCESS_KEY_HEADER, accessKey);
        }
        if ((signHeaders = SpasAdapter.getSignHeaders(this.getResource(resource.getNamespace(), resource.getGroup()), secretKey)) != null && !signHeaders.isEmpty()) {
            result.setParameters(signHeaders);
        }
    }

    private StsCredential getStsCredential() {
        boolean cacheSecurityCredentials = StsConfig.getInstance().isCacheSecurityCredentials();
        if (cacheSecurityCredentials && this.stsCredential != null) {
            int timeToRefreshInMillisecond;
            long currentTime = System.currentTimeMillis();
            long expirationTime = this.stsCredential.getExpiration().getTime();
            if (expirationTime - currentTime > (long)(timeToRefreshInMillisecond = StsConfig.getInstance().getTimeToRefreshInMillisecond())) {
                return this.stsCredential;
            }
        }
        String stsResponse = ConfigResourceInjector.getStsResponse();
        this.stsCredential = (StsCredential)JacksonUtils.toObj((String)stsResponse, (TypeReference)new TypeReference<StsCredential>(){});
        LOGGER.info("[getSTSCredential] code:{}, accessKeyId:{}, lastUpdated:{}, expiration:{}", new Object[]{this.stsCredential.getCode(), this.stsCredential.getAccessKeyId(), this.stsCredential.getLastUpdated(), this.stsCredential.getExpiration()});
        return this.stsCredential;
    }

    private static String getStsResponse() {
        String securityCredentials = StsConfig.getInstance().getSecurityCredentials();
        if (securityCredentials != null) {
            return securityCredentials;
        }
        String securityCredentialsUrl = StsConfig.getInstance().getSecurityCredentialsUrl();
        try {
            HttpRestResult result = ConfigHttpClientManager.getInstance().getNacosRestTemplate().get(securityCredentialsUrl, Header.EMPTY, Query.EMPTY, String.class);
            if (!result.ok()) {
                LOGGER.error("can not get security credentials, securityCredentialsUrl: {}, responseCode: {}, response: {}", new Object[]{securityCredentialsUrl, result.getCode(), result.getMessage()});
                throw new NacosRuntimeException(500, "can not get security credentials, responseCode: " + result.getCode() + ", response: " + result.getMessage());
            }
            return (String)result.getData();
        }
        catch (Exception e) {
            LOGGER.error("can not get security credentials", (Throwable)e);
            throw new NacosRuntimeException(500, (Throwable)e);
        }
    }

    private String getResource(String tenant, String group) {
        if (StringUtils.isNotBlank((String)tenant) && StringUtils.isNotBlank((String)group)) {
            return tenant + "+" + group;
        }
        if (StringUtils.isNotBlank((String)group)) {
            return group;
        }
        if (StringUtils.isNotBlank((String)tenant)) {
            return tenant;
        }
        return DEFAULT_RESOURCE;
    }
}

