/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.filter;

import com.alibaba.nacos.common.notify.Event;
import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.common.notify.listener.SmartSubscriber;
import com.alibaba.nacos.common.notify.listener.Subscriber;
import com.alibaba.nacos.common.utils.CollectionUtils;
import com.alibaba.nacos.common.utils.ExceptionUtil;
import com.alibaba.nacos.config.server.model.event.RaftDbErrorEvent;
import com.alibaba.nacos.config.server.model.event.RaftDbErrorRecoverEvent;
import com.alibaba.nacos.config.server.utils.LogUtil;
import com.alibaba.nacos.consistency.ProtocolMetaData;
import com.alibaba.nacos.consistency.cp.CPProtocol;
import com.alibaba.nacos.core.cluster.Member;
import com.alibaba.nacos.core.cluster.ServerMemberManager;
import com.alibaba.nacos.core.code.ControllerMethodsCache;
import java.io.IOException;
import java.security.AccessControlException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;

public class CurcuitFilter
implements Filter {
    private volatile boolean isDowngrading = false;
    private volatile boolean isOpenService = false;
    @Autowired
    private ServerMemberManager memberManager;
    @Autowired
    private CPProtocol protocol;
    @Autowired
    private ControllerMethodsCache controllerMethodsCache;

    @PostConstruct
    protected void init() {
        this.listenerSelfInCluster();
        this.registerSubscribe();
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        if (!this.isOpenService) {
            resp.sendError(503, "In the node initialization, unable to process any requests at this time");
            return;
        }
        try {
            if (this.isDowngrading) {
                resp.sendError(503, "Unable to process the request at this time: System triggered degradation");
                return;
            }
            chain.doFilter((ServletRequest)req, response);
        }
        catch (AccessControlException e) {
            resp.sendError(403, "access denied: " + ExceptionUtil.getAllExceptionMsg((Throwable)e));
        }
        catch (Throwable e) {
            LogUtil.DEFAULT_LOG.warn("[CURCUIT-FILTER] Server failed: ", e);
            resp.sendError(500, "Server failed, " + e);
        }
    }

    public void destroy() {
    }

    private void listenerSelfInCluster() {
        this.protocol.protocolMetaData().subscribe("nacos_config", "raftGroupMember", o -> {
            if (!(o instanceof ProtocolMetaData.ValueItem)) {
                return;
            }
            List peers = (List)((ProtocolMetaData.ValueItem)o).getData();
            if (CollectionUtils.isEmpty((Collection)peers)) {
                this.isOpenService = false;
                return;
            }
            Member self = this.memberManager.getSelf();
            String raftAddress = self.getIp() + ":" + self.getExtendVal("raftPort");
            this.isOpenService = peers.contains(raftAddress);
        });
    }

    private void registerSubscribe() {
        NotifyCenter.registerSubscriber((Subscriber)new SmartSubscriber(){

            public void onEvent(Event event) {
                if (event instanceof RaftDbErrorRecoverEvent) {
                    CurcuitFilter.this.isDowngrading = false;
                    return;
                }
                if (event instanceof RaftDbErrorEvent) {
                    CurcuitFilter.this.isDowngrading = true;
                }
            }

            public List<Class<? extends Event>> subscribeTypes() {
                return Arrays.asList(RaftDbErrorRecoverEvent.class, RaftDbErrorEvent.class);
            }
        });
    }
}

