/*
 * Decompiled with CFR 0.152.
 */
package net.devh.boot.grpc.server.config;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.List;
import net.devh.boot.grpc.server.config.ClientAuth;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.convert.DataSizeUnit;
import org.springframework.boot.convert.DurationUnit;
import org.springframework.core.io.Resource;
import org.springframework.util.SocketUtils;
import org.springframework.util.unit.DataSize;
import org.springframework.util.unit.DataUnit;

@ConfigurationProperties(value="grpc.server")
public class GrpcServerProperties {
    public static final String ANY_IP_ADDRESS = "*";
    public static final String ANY_IPv4_ADDRESS = "0.0.0.0";
    public static final String ANY_IPv6_ADDRESS = "::";
    private String address = "*";
    private int port = 9090;
    private String inProcessName;
    private boolean enableKeepAlive = false;
    @DurationUnit(value=ChronoUnit.SECONDS)
    private Duration keepAliveTime = Duration.of(60L, ChronoUnit.SECONDS);
    @DurationUnit(value=ChronoUnit.SECONDS)
    private Duration keepAliveTimeout = Duration.of(20L, ChronoUnit.SECONDS);
    @DurationUnit(value=ChronoUnit.SECONDS)
    private Duration permitKeepAliveTime = Duration.of(5L, ChronoUnit.MINUTES);
    @DurationUnit(value=ChronoUnit.SECONDS)
    private boolean permitKeepAliveWithoutCalls = false;
    @DataSizeUnit(value=DataUnit.BYTES)
    private DataSize maxInboundMessageSize = null;
    @DataSizeUnit(value=DataUnit.BYTES)
    private DataSize maxInboundMetadataSize = null;
    private boolean healthServiceEnabled = true;
    private boolean reflectionServiceEnabled = true;
    private final Security security = new Security();

    public int getPort() {
        if (this.port == 0) {
            this.port = SocketUtils.findAvailableTcpPort();
        }
        return this.port;
    }

    public void setMaxInboundMessageSize(DataSize maxInboundMessageSize) {
        if (maxInboundMessageSize == null || maxInboundMessageSize.toBytes() >= 0L) {
            this.maxInboundMessageSize = maxInboundMessageSize;
        } else if (maxInboundMessageSize.toBytes() == -1L) {
            this.maxInboundMessageSize = DataSize.ofBytes((long)Integer.MAX_VALUE);
        } else {
            throw new IllegalArgumentException("Unsupported maxInboundMessageSize: " + maxInboundMessageSize);
        }
    }

    public void setMaxInboundMetadataSize(DataSize maxInboundMetadataSize) {
        if (maxInboundMetadataSize == null || maxInboundMetadataSize.toBytes() >= 0L) {
            this.maxInboundMetadataSize = maxInboundMetadataSize;
        } else if (maxInboundMetadataSize.toBytes() == -1L) {
            this.maxInboundMetadataSize = DataSize.ofBytes((long)Integer.MAX_VALUE);
        } else {
            throw new IllegalArgumentException("Unsupported maxInboundMetadataSize: " + maxInboundMetadataSize);
        }
    }

    public String getAddress() {
        return this.address;
    }

    public String getInProcessName() {
        return this.inProcessName;
    }

    public boolean isEnableKeepAlive() {
        return this.enableKeepAlive;
    }

    public Duration getKeepAliveTime() {
        return this.keepAliveTime;
    }

    public Duration getKeepAliveTimeout() {
        return this.keepAliveTimeout;
    }

    public Duration getPermitKeepAliveTime() {
        return this.permitKeepAliveTime;
    }

    public boolean isPermitKeepAliveWithoutCalls() {
        return this.permitKeepAliveWithoutCalls;
    }

    public DataSize getMaxInboundMessageSize() {
        return this.maxInboundMessageSize;
    }

    public DataSize getMaxInboundMetadataSize() {
        return this.maxInboundMetadataSize;
    }

    public boolean isHealthServiceEnabled() {
        return this.healthServiceEnabled;
    }

    public boolean isReflectionServiceEnabled() {
        return this.reflectionServiceEnabled;
    }

    public Security getSecurity() {
        return this.security;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setInProcessName(String inProcessName) {
        this.inProcessName = inProcessName;
    }

    public void setEnableKeepAlive(boolean enableKeepAlive) {
        this.enableKeepAlive = enableKeepAlive;
    }

    public void setKeepAliveTime(Duration keepAliveTime) {
        this.keepAliveTime = keepAliveTime;
    }

    public void setKeepAliveTimeout(Duration keepAliveTimeout) {
        this.keepAliveTimeout = keepAliveTimeout;
    }

    public void setPermitKeepAliveTime(Duration permitKeepAliveTime) {
        this.permitKeepAliveTime = permitKeepAliveTime;
    }

    public void setPermitKeepAliveWithoutCalls(boolean permitKeepAliveWithoutCalls) {
        this.permitKeepAliveWithoutCalls = permitKeepAliveWithoutCalls;
    }

    public void setHealthServiceEnabled(boolean healthServiceEnabled) {
        this.healthServiceEnabled = healthServiceEnabled;
    }

    public void setReflectionServiceEnabled(boolean reflectionServiceEnabled) {
        this.reflectionServiceEnabled = reflectionServiceEnabled;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GrpcServerProperties)) {
            return false;
        }
        GrpcServerProperties other = (GrpcServerProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$address = this.getAddress();
        String other$address = other.getAddress();
        if (this$address == null ? other$address != null : !this$address.equals(other$address)) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        String this$inProcessName = this.getInProcessName();
        String other$inProcessName = other.getInProcessName();
        if (this$inProcessName == null ? other$inProcessName != null : !this$inProcessName.equals(other$inProcessName)) {
            return false;
        }
        if (this.isEnableKeepAlive() != other.isEnableKeepAlive()) {
            return false;
        }
        Duration this$keepAliveTime = this.getKeepAliveTime();
        Duration other$keepAliveTime = other.getKeepAliveTime();
        if (this$keepAliveTime == null ? other$keepAliveTime != null : !((Object)this$keepAliveTime).equals(other$keepAliveTime)) {
            return false;
        }
        Duration this$keepAliveTimeout = this.getKeepAliveTimeout();
        Duration other$keepAliveTimeout = other.getKeepAliveTimeout();
        if (this$keepAliveTimeout == null ? other$keepAliveTimeout != null : !((Object)this$keepAliveTimeout).equals(other$keepAliveTimeout)) {
            return false;
        }
        Duration this$permitKeepAliveTime = this.getPermitKeepAliveTime();
        Duration other$permitKeepAliveTime = other.getPermitKeepAliveTime();
        if (this$permitKeepAliveTime == null ? other$permitKeepAliveTime != null : !((Object)this$permitKeepAliveTime).equals(other$permitKeepAliveTime)) {
            return false;
        }
        if (this.isPermitKeepAliveWithoutCalls() != other.isPermitKeepAliveWithoutCalls()) {
            return false;
        }
        DataSize this$maxInboundMessageSize = this.getMaxInboundMessageSize();
        DataSize other$maxInboundMessageSize = other.getMaxInboundMessageSize();
        if (this$maxInboundMessageSize == null ? other$maxInboundMessageSize != null : !this$maxInboundMessageSize.equals(other$maxInboundMessageSize)) {
            return false;
        }
        DataSize this$maxInboundMetadataSize = this.getMaxInboundMetadataSize();
        DataSize other$maxInboundMetadataSize = other.getMaxInboundMetadataSize();
        if (this$maxInboundMetadataSize == null ? other$maxInboundMetadataSize != null : !this$maxInboundMetadataSize.equals(other$maxInboundMetadataSize)) {
            return false;
        }
        if (this.isHealthServiceEnabled() != other.isHealthServiceEnabled()) {
            return false;
        }
        if (this.isReflectionServiceEnabled() != other.isReflectionServiceEnabled()) {
            return false;
        }
        Security this$security = this.getSecurity();
        Security other$security = other.getSecurity();
        return !(this$security == null ? other$security != null : !((Object)this$security).equals(other$security));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GrpcServerProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : $address.hashCode());
        result = result * 59 + this.getPort();
        String $inProcessName = this.getInProcessName();
        result = result * 59 + ($inProcessName == null ? 43 : $inProcessName.hashCode());
        result = result * 59 + (this.isEnableKeepAlive() ? 79 : 97);
        Duration $keepAliveTime = this.getKeepAliveTime();
        result = result * 59 + ($keepAliveTime == null ? 43 : ((Object)$keepAliveTime).hashCode());
        Duration $keepAliveTimeout = this.getKeepAliveTimeout();
        result = result * 59 + ($keepAliveTimeout == null ? 43 : ((Object)$keepAliveTimeout).hashCode());
        Duration $permitKeepAliveTime = this.getPermitKeepAliveTime();
        result = result * 59 + ($permitKeepAliveTime == null ? 43 : ((Object)$permitKeepAliveTime).hashCode());
        result = result * 59 + (this.isPermitKeepAliveWithoutCalls() ? 79 : 97);
        DataSize $maxInboundMessageSize = this.getMaxInboundMessageSize();
        result = result * 59 + ($maxInboundMessageSize == null ? 43 : $maxInboundMessageSize.hashCode());
        DataSize $maxInboundMetadataSize = this.getMaxInboundMetadataSize();
        result = result * 59 + ($maxInboundMetadataSize == null ? 43 : $maxInboundMetadataSize.hashCode());
        result = result * 59 + (this.isHealthServiceEnabled() ? 79 : 97);
        result = result * 59 + (this.isReflectionServiceEnabled() ? 79 : 97);
        Security $security = this.getSecurity();
        result = result * 59 + ($security == null ? 43 : ((Object)$security).hashCode());
        return result;
    }

    public String toString() {
        return "GrpcServerProperties(address=" + this.getAddress() + ", port=" + this.getPort() + ", inProcessName=" + this.getInProcessName() + ", enableKeepAlive=" + this.isEnableKeepAlive() + ", keepAliveTime=" + this.getKeepAliveTime() + ", keepAliveTimeout=" + this.getKeepAliveTimeout() + ", permitKeepAliveTime=" + this.getPermitKeepAliveTime() + ", permitKeepAliveWithoutCalls=" + this.isPermitKeepAliveWithoutCalls() + ", maxInboundMessageSize=" + this.getMaxInboundMessageSize() + ", maxInboundMetadataSize=" + this.getMaxInboundMetadataSize() + ", healthServiceEnabled=" + this.isHealthServiceEnabled() + ", reflectionServiceEnabled=" + this.isReflectionServiceEnabled() + ", security=" + this.getSecurity() + ")";
    }

    public static class Security {
        private boolean enabled = false;
        private Resource certificateChain = null;
        private Resource privateKey = null;
        private String privateKeyPassword = null;
        private ClientAuth clientAuth = ClientAuth.NONE;
        private Resource trustCertCollection = null;
        private List<String> ciphers = null;
        private String[] protocols = null;

        public void setCiphers(String ciphers) {
            this.ciphers = Arrays.asList(ciphers.split("[ :,]"));
        }

        public void setProtocols(String protocols) {
            this.protocols = protocols.split("[ :,]");
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public Resource getCertificateChain() {
            return this.certificateChain;
        }

        public Resource getPrivateKey() {
            return this.privateKey;
        }

        public String getPrivateKeyPassword() {
            return this.privateKeyPassword;
        }

        public ClientAuth getClientAuth() {
            return this.clientAuth;
        }

        public Resource getTrustCertCollection() {
            return this.trustCertCollection;
        }

        public List<String> getCiphers() {
            return this.ciphers;
        }

        public String[] getProtocols() {
            return this.protocols;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public void setCertificateChain(Resource certificateChain) {
            this.certificateChain = certificateChain;
        }

        public void setPrivateKey(Resource privateKey) {
            this.privateKey = privateKey;
        }

        public void setPrivateKeyPassword(String privateKeyPassword) {
            this.privateKeyPassword = privateKeyPassword;
        }

        public void setClientAuth(ClientAuth clientAuth) {
            this.clientAuth = clientAuth;
        }

        public void setTrustCertCollection(Resource trustCertCollection) {
            this.trustCertCollection = trustCertCollection;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Security)) {
                return false;
            }
            Security other = (Security)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isEnabled() != other.isEnabled()) {
                return false;
            }
            Resource this$certificateChain = this.getCertificateChain();
            Resource other$certificateChain = other.getCertificateChain();
            if (this$certificateChain == null ? other$certificateChain != null : !this$certificateChain.equals(other$certificateChain)) {
                return false;
            }
            Resource this$privateKey = this.getPrivateKey();
            Resource other$privateKey = other.getPrivateKey();
            if (this$privateKey == null ? other$privateKey != null : !this$privateKey.equals(other$privateKey)) {
                return false;
            }
            String this$privateKeyPassword = this.getPrivateKeyPassword();
            String other$privateKeyPassword = other.getPrivateKeyPassword();
            if (this$privateKeyPassword == null ? other$privateKeyPassword != null : !this$privateKeyPassword.equals(other$privateKeyPassword)) {
                return false;
            }
            ClientAuth this$clientAuth = this.getClientAuth();
            ClientAuth other$clientAuth = other.getClientAuth();
            if (this$clientAuth == null ? other$clientAuth != null : !((Object)((Object)this$clientAuth)).equals((Object)other$clientAuth)) {
                return false;
            }
            Resource this$trustCertCollection = this.getTrustCertCollection();
            Resource other$trustCertCollection = other.getTrustCertCollection();
            if (this$trustCertCollection == null ? other$trustCertCollection != null : !this$trustCertCollection.equals(other$trustCertCollection)) {
                return false;
            }
            List<String> this$ciphers = this.getCiphers();
            List<String> other$ciphers = other.getCiphers();
            if (this$ciphers == null ? other$ciphers != null : !((Object)this$ciphers).equals(other$ciphers)) {
                return false;
            }
            return Arrays.deepEquals(this.getProtocols(), other.getProtocols());
        }

        protected boolean canEqual(Object other) {
            return other instanceof Security;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isEnabled() ? 79 : 97);
            Resource $certificateChain = this.getCertificateChain();
            result = result * 59 + ($certificateChain == null ? 43 : $certificateChain.hashCode());
            Resource $privateKey = this.getPrivateKey();
            result = result * 59 + ($privateKey == null ? 43 : $privateKey.hashCode());
            String $privateKeyPassword = this.getPrivateKeyPassword();
            result = result * 59 + ($privateKeyPassword == null ? 43 : $privateKeyPassword.hashCode());
            ClientAuth $clientAuth = this.getClientAuth();
            result = result * 59 + ($clientAuth == null ? 43 : ((Object)((Object)$clientAuth)).hashCode());
            Resource $trustCertCollection = this.getTrustCertCollection();
            result = result * 59 + ($trustCertCollection == null ? 43 : $trustCertCollection.hashCode());
            List<String> $ciphers = this.getCiphers();
            result = result * 59 + ($ciphers == null ? 43 : ((Object)$ciphers).hashCode());
            result = result * 59 + Arrays.deepHashCode(this.getProtocols());
            return result;
        }

        public String toString() {
            return "GrpcServerProperties.Security(enabled=" + this.isEnabled() + ", certificateChain=" + this.getCertificateChain() + ", privateKey=" + this.getPrivateKey() + ", privateKeyPassword=" + this.getPrivateKeyPassword() + ", clientAuth=" + (Object)((Object)this.getClientAuth()) + ", trustCertCollection=" + this.getTrustCertCollection() + ", ciphers=" + this.getCiphers() + ", protocols=" + Arrays.deepToString(this.getProtocols()) + ")";
        }
    }
}

