/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.core.utils;

import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.Base64;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.dreamlu.mica.core.utils.Base64Util;
import org.springframework.lang.Nullable;

public class RsaHelper {
    private static final Pattern XML_EXP = Pattern.compile("\\s*<RSAKeyValue>([<>\\/\\+=\\w\\s]+)</RSAKeyValue>\\s*");
    private static final Pattern XML_TAG_EXP = Pattern.compile("<(.+?)>\\s*([^<]+?)\\s*</");
    private static final Pattern PEM_CODE = Pattern.compile("--+.+?--+|[\\s\\r\\n]+");
    private static final byte[] SEQ_OID = new byte[]{48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0};
    private static final byte[] VERSION = new byte[]{2, 1, 0};
    private byte[] keyModulus;
    private byte[] keyExponent;
    @Nullable
    private byte[] keyD;
    private byte[] valP;
    private byte[] valQ;
    private byte[] valDP;
    private byte[] valDQ;
    private byte[] valInverseQ;

    private RsaHelper() {
    }

    public RsaHelper(RSAPublicKey publicKey, @Nullable RSAPrivateKey privateKeyOrNull) {
        this(RsaHelper.bigB(publicKey.getModulus()), RsaHelper.bigB(publicKey.getPublicExponent()), privateKeyOrNull == null ? null : RsaHelper.bigB(privateKeyOrNull.getPrivateExponent()));
    }

    public RsaHelper(byte[] modulus, byte[] exponent, byte[] d, byte[] p, byte[] q, byte[] dp, byte[] dq, byte[] inverseQ) {
        this.keyModulus = modulus;
        this.keyExponent = exponent;
        this.keyD = d;
        this.valP = p;
        this.valQ = q;
        this.valDP = dp;
        this.valDQ = dq;
        this.valInverseQ = inverseQ;
    }

    public RsaHelper(byte[] modulus, byte[] exponent, @Nullable byte[] dOrNull) {
        this.keyModulus = modulus;
        this.keyExponent = exponent;
        if (dOrNull != null) {
            BigInteger q;
            BigInteger d;
            this.keyD = dOrNull;
            BigInteger n = RsaHelper.bigX(modulus);
            BigInteger e = RsaHelper.bigX(exponent);
            BigInteger p = RsaHelper.findFactor(e, d = RsaHelper.bigX(dOrNull), n);
            if (p.compareTo(q = n.divide(p)) > 0) {
                BigInteger t = p;
                p = q;
                q = t;
            }
            BigInteger exp1 = d.mod(p.subtract(BigInteger.ONE));
            BigInteger exp2 = d.mod(q.subtract(BigInteger.ONE));
            BigInteger coeff = q.modInverse(p);
            this.valP = RsaHelper.bigB(p);
            this.valQ = RsaHelper.bigB(q);
            this.valDP = RsaHelper.bigB(exp1);
            this.valDQ = RsaHelper.bigB(exp2);
            this.valInverseQ = RsaHelper.bigB(coeff);
        }
    }

    public int keySize() {
        return this.keyModulus.length * 8;
    }

    public boolean hasPrivate() {
        return this.keyD != null;
    }

    public RSAPublicKey getRSAPublicKey() throws Exception {
        RSAPublicKeySpec spec = new RSAPublicKeySpec(RsaHelper.bigX(this.keyModulus), RsaHelper.bigX(this.keyExponent));
        KeyFactory factory = KeyFactory.getInstance("RSA");
        return (RSAPublicKey)factory.generatePublic(spec);
    }

    public RSAPrivateKey getRSAPrivateKey() throws Exception {
        if (this.keyD == null) {
            throw new Exception("\u5f53\u524d\u4e3a\u516c\u94a5\uff0c\u65e0\u6cd5\u83b7\u5f97\u79c1\u94a5");
        }
        RSAPrivateKeySpec spec = new RSAPrivateKeySpec(RsaHelper.bigX(this.keyModulus), RsaHelper.bigX(this.keyD));
        KeyFactory factory = KeyFactory.getInstance("RSA");
        return (RSAPrivateKey)factory.generatePrivate(spec);
    }

    public static BigInteger bigX(byte[] bigb) {
        if (bigb[0] < 0) {
            byte[] c = new byte[bigb.length + 1];
            System.arraycopy(bigb, 0, c, 1, bigb.length);
            bigb = c;
        }
        return new BigInteger(bigb);
    }

    public static byte[] bigB(BigInteger bigx) {
        byte[] val = bigx.toByteArray();
        if (val[0] == 0) {
            byte[] c = new byte[val.length - 1];
            System.arraycopy(val, 1, c, 0, c.length);
            val = c;
        }
        return val;
    }

    private static BigInteger findFactor(BigInteger e, BigInteger d, BigInteger n) {
        BigInteger edMinus1 = e.multiply(d).subtract(BigInteger.ONE);
        int s = edMinus1.getLowestSetBit();
        BigInteger t = edMinus1.shiftRight(s);
        long now = System.currentTimeMillis();
        int aInt = 2;
        while (true) {
            if (aInt % 10 == 0 && System.currentTimeMillis() - now > 3000L) {
                throw new RuntimeException("\u63a8\u7b97RSA.P\u8d85\u65f6");
            }
            BigInteger aPow = BigInteger.valueOf(aInt).modPow(t, n);
            for (int i = 1; i <= s && !aPow.equals(BigInteger.ONE) && !aPow.equals(n.subtract(BigInteger.ONE)); ++i) {
                BigInteger aPowSquared = aPow.multiply(aPow).mod(n);
                if (aPowSquared.equals(BigInteger.ONE)) {
                    return aPow.subtract(BigInteger.ONE).gcd(n);
                }
                aPow = aPowSquared;
            }
            ++aInt;
        }
    }

    public static RsaHelper fromPem(String pem) throws Exception {
        RsaHelper param = new RsaHelper();
        String base64 = PEM_CODE.matcher(pem).replaceAll("");
        byte[] dataX = Base64.getDecoder().decode(base64);
        if (dataX == null) {
            throw new IllegalArgumentException("PEM\u5185\u5bb9\u65e0\u6548");
        }
        short[] data = new short[dataX.length];
        for (int i = 0; i < dataX.length; ++i) {
            data[i] = (short)(dataX[i] & 0xFF);
        }
        int[] idx = new int[]{0};
        if (pem.contains("PUBLIC KEY")) {
            RsaHelper.readLen(48, data, idx);
            int[] idx2 = new int[]{idx[0]};
            if (RsaHelper.eq(SEQ_OID, data, idx)) {
                RsaHelper.readLen(3, data, idx);
                idx[0] = idx[0] + 1;
                RsaHelper.readLen(48, data, idx);
            } else {
                idx = idx2;
            }
            param.keyModulus = RsaHelper.readBlock(data, idx);
            param.keyExponent = RsaHelper.readBlock(data, idx);
        } else if (pem.contains("PRIVATE KEY")) {
            RsaHelper.readLen(48, data, idx);
            if (!RsaHelper.eq(VERSION, data, idx)) {
                throw new IllegalArgumentException("PEM\u672a\u77e5\u7248\u672c");
            }
            int[] idx2 = new int[]{idx[0]};
            if (RsaHelper.eq(SEQ_OID, data, idx)) {
                RsaHelper.readLen(4, data, idx);
                RsaHelper.readLen(48, data, idx);
                if (!RsaHelper.eq(VERSION, data, idx)) {
                    throw new IllegalArgumentException("PEM\u7248\u672c\u65e0\u6548");
                }
            } else {
                idx = idx2;
            }
            param.keyModulus = RsaHelper.readBlock(data, idx);
            param.keyExponent = RsaHelper.readBlock(data, idx);
            param.keyD = RsaHelper.readBlock(data, idx);
            param.valP = RsaHelper.readBlock(data, idx);
            param.valQ = RsaHelper.readBlock(data, idx);
            param.valDP = RsaHelper.readBlock(data, idx);
            param.valDQ = RsaHelper.readBlock(data, idx);
            param.valInverseQ = RsaHelper.readBlock(data, idx);
        } else {
            throw new IllegalArgumentException("pem\u9700\u8981BEGIN END\u6807\u5934");
        }
        return param;
    }

    private static byte[] sub(short[] arr, int start, int count) {
        byte[] val = new byte[count];
        for (int i = 0; i < count; ++i) {
            val[i] = (byte)arr[start + i];
        }
        return val;
    }

    private static int readLen(int first, short[] data, int[] idxO) throws Exception {
        int idx = idxO[0];
        try {
            if (data[idx] == first) {
                if (data[++idx] == 129) {
                    int n = ++idx;
                    ++idx;
                    short s = data[n];
                    return s;
                }
                if (data[idx] == 130) {
                    int n = ++idx;
                    int n2 = ++idx;
                    ++idx;
                    int n3 = (data[n] << 8) + data[n2];
                    return n3;
                }
                if (data[idx] < 128) {
                    short s = data[idx++];
                    return s;
                }
            }
            throw new Exception("PEM\u672a\u80fd\u63d0\u53d6\u5230\u6570\u636e");
        }
        finally {
            idxO[0] = idx;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] readBlock(short[] data, int[] idxO) throws Exception {
        int idx = idxO[0];
        try {
            int len = RsaHelper.readLen(2, data, idxO);
            idx = idxO[0];
            if (data[idx] == 0) {
                ++idx;
                --len;
            }
            byte[] val = RsaHelper.sub(data, idx, len);
            idx += len;
            byte[] byArray = val;
            return byArray;
        }
        finally {
            idxO[0] = idx;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean eq(byte[] bytes, short[] data, int[] idxO) {
        int idx = idxO[0];
        try {
            int i = 0;
            while (i < bytes.length) {
                if (idx >= data.length) {
                    boolean bl = false;
                    return bl;
                }
                if ((bytes[i] & 0xFF) != data[idx]) {
                    boolean bl = false;
                    return bl;
                }
                ++i;
                ++idx;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            idxO[0] = idx;
        }
    }

    public String toPemPKCS1(boolean convertToPublic) throws Exception {
        return this.toPem(convertToPublic, false, false);
    }

    public String toPemPKCS8(boolean convertToPublic) throws Exception {
        return this.toPem(convertToPublic, true, true);
    }

    public String toPem(boolean convertToPublic, boolean privateUsePKCS8, boolean publicUsePKCS8) throws Exception {
        ByteArrayOutputStream ms = new ByteArrayOutputStream();
        if (this.keyD == null || convertToPublic) {
            ms.write(48);
            int index1 = ms.size();
            int index2 = -1;
            int index3 = -1;
            if (publicUsePKCS8) {
                ms.write(SEQ_OID);
                ms.write(3);
                index2 = ms.size();
                ms.write(0);
                ms.write(48);
                index3 = ms.size();
            }
            RsaHelper.writeBlock(this.keyModulus, ms);
            RsaHelper.writeBlock(this.keyExponent, ms);
            byte[] bytes = ms.toByteArray();
            if (index2 != -1) {
                bytes = RsaHelper.writeLen(index3, bytes, ms);
                bytes = RsaHelper.writeLen(index2, bytes, ms);
            }
            bytes = RsaHelper.writeLen(index1, bytes, ms);
            String flag = " PUBLIC KEY";
            if (!publicUsePKCS8) {
                flag = " RSA" + flag;
            }
            return "-----BEGIN" + flag + "-----\n" + RsaHelper.textBreak(Base64.getEncoder().encodeToString(bytes), 64) + "\n-----END" + flag + "-----";
        }
        ms.write(48);
        int index1 = ms.size();
        ms.write(VERSION);
        int index2 = -1;
        int index3 = -1;
        if (privateUsePKCS8) {
            ms.write(SEQ_OID);
            ms.write(4);
            index2 = ms.size();
            ms.write(48);
            index3 = ms.size();
            ms.write(VERSION);
        }
        RsaHelper.writeBlock(this.keyModulus, ms);
        RsaHelper.writeBlock(this.keyExponent, ms);
        RsaHelper.writeBlock(this.keyD, ms);
        RsaHelper.writeBlock(this.valP, ms);
        RsaHelper.writeBlock(this.valQ, ms);
        RsaHelper.writeBlock(this.valDP, ms);
        RsaHelper.writeBlock(this.valDQ, ms);
        RsaHelper.writeBlock(this.valInverseQ, ms);
        byte[] bytes = ms.toByteArray();
        if (index2 != -1) {
            bytes = RsaHelper.writeLen(index3, bytes, ms);
            bytes = RsaHelper.writeLen(index2, bytes, ms);
        }
        bytes = RsaHelper.writeLen(index1, bytes, ms);
        String flag = " PRIVATE KEY";
        if (!privateUsePKCS8) {
            flag = " RSA" + flag;
        }
        return "-----BEGIN" + flag + "-----\n" + RsaHelper.textBreak(Base64.getEncoder().encodeToString(bytes), 64) + "\n-----END" + flag + "-----";
    }

    private static void writeLenByte(int len, ByteArrayOutputStream ms) {
        if (len < 128) {
            ms.write((byte)len);
        } else if (len <= 255) {
            ms.write(129);
            ms.write((byte)len);
        } else {
            ms.write(130);
            ms.write((byte)(len >> 8 & 0xFF));
            ms.write((byte)(len & 0xFF));
        }
    }

    private static void writeBlock(byte[] bytes, ByteArrayOutputStream ms) throws Exception {
        boolean addZero = (bytes[0] & 0xFF) >> 4 >= 8;
        ms.write(2);
        int len = bytes.length + (addZero ? 1 : 0);
        RsaHelper.writeLenByte(len, ms);
        if (addZero) {
            ms.write(0);
        }
        ms.write(bytes);
    }

    private static byte[] writeLen(int index, byte[] bytes, ByteArrayOutputStream ms) {
        int len = bytes.length - index;
        ms.reset();
        ms.write(bytes, 0, index);
        RsaHelper.writeLenByte(len, ms);
        ms.write(bytes, index, len);
        return ms.toByteArray();
    }

    private static String textBreak(String text, int line) {
        int len = text.length();
        StringBuilder str = new StringBuilder();
        for (int idx = 0; idx < len; idx += line) {
            if (idx > 0) {
                str.append('\n');
            }
            if (idx + line >= len) {
                str.append(text.substring(idx));
                continue;
            }
            str.append(text, idx, idx + line);
        }
        return str.toString();
    }

    public static RsaHelper fromXml(String xml) {
        RsaHelper rtv = new RsaHelper();
        Matcher xmlM = XML_EXP.matcher(xml);
        if (!xmlM.find()) {
            throw new IllegalArgumentException("XML\u5185\u5bb9\u4e0d\u7b26\u5408\u8981\u6c42");
        }
        Matcher tagM = XML_TAG_EXP.matcher(xmlM.group(1));
        Base64.Decoder dec = Base64.getDecoder();
        while (tagM.find()) {
            String tag = tagM.group(1);
            String b64 = tagM.group(2);
            byte[] val = dec.decode(b64);
            switch (tag) {
                case "Modulus": {
                    rtv.keyModulus = val;
                    break;
                }
                case "Exponent": {
                    rtv.keyExponent = val;
                    break;
                }
                case "D": {
                    rtv.keyD = val;
                    break;
                }
                case "P": {
                    rtv.valP = val;
                    break;
                }
                case "Q": {
                    rtv.valQ = val;
                    break;
                }
                case "DP": {
                    rtv.valDP = val;
                    break;
                }
                case "DQ": {
                    rtv.valDQ = val;
                    break;
                }
                case "InverseQ": {
                    rtv.valInverseQ = val;
                    break;
                }
            }
        }
        if (rtv.keyModulus == null || rtv.keyExponent == null) {
            throw new IllegalArgumentException("XML\u516c\u94a5\u4e22\u5931");
        }
        if (rtv.keyD != null && (rtv.valP == null || rtv.valQ == null || rtv.valDP == null || rtv.valDQ == null || rtv.valInverseQ == null)) {
            return new RsaHelper(rtv.keyModulus, rtv.keyExponent, rtv.keyD);
        }
        return rtv;
    }

    public String toXml(boolean convertToPublic) {
        StringBuilder str = new StringBuilder();
        str.append("<RSAKeyValue>");
        str.append("<Modulus>").append(Base64Util.encodeToString((byte[])this.keyModulus)).append("</Modulus>");
        str.append("<Exponent>").append(Base64Util.encodeToString((byte[])this.keyExponent)).append("</Exponent>");
        if (this.keyD != null && !convertToPublic) {
            str.append("<P>").append(Base64Util.encodeToString((byte[])this.valP)).append("</P>");
            str.append("<Q>").append(Base64Util.encodeToString((byte[])this.valQ)).append("</Q>");
            str.append("<DP>").append(Base64Util.encodeToString((byte[])this.valDP)).append("</DP>");
            str.append("<DQ>").append(Base64Util.encodeToString((byte[])this.valDQ)).append("</DQ>");
            str.append("<InverseQ>").append(Base64Util.encodeToString((byte[])this.valInverseQ)).append("</InverseQ>");
            str.append("<D>").append(Base64Util.encodeToString((byte[])this.keyD)).append("</D>");
        }
        str.append("</RSAKeyValue>");
        return str.toString();
    }
}

