/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.xss.core;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import net.dreamlu.mica.xss.core.XssCleaner;
import net.dreamlu.mica.xss.core.XssHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.InitBinder;

@ControllerAdvice
public class FormXssClean {
    private final XssCleaner xssCleaner;

    @InitBinder
    public void initBinder(WebDataBinder binder) {
        binder.registerCustomEditor(String.class, (PropertyEditor)new StringPropertiesEditor(this.xssCleaner));
    }

    public FormXssClean(XssCleaner xssCleaner) {
        this.xssCleaner = xssCleaner;
    }

    public static class StringPropertiesEditor
    extends PropertyEditorSupport {
        private static final Logger log = LoggerFactory.getLogger(StringPropertiesEditor.class);
        private final XssCleaner xssCleaner;

        @Override
        public String getAsText() {
            Object value = this.getValue();
            return value != null ? value.toString() : "";
        }

        @Override
        public void setAsText(String text) throws IllegalArgumentException {
            if (text == null) {
                this.setValue(null);
            } else if (XssHolder.isEnabled()) {
                String value = this.xssCleaner.clean(text);
                this.setValue(value);
                log.debug("Request parameter value:{} cleaned up by mica-xss, current value is:{}.", (Object)text, (Object)value);
            } else {
                this.setValue(text);
            }
        }

        public StringPropertiesEditor(XssCleaner xssCleaner) {
            this.xssCleaner = xssCleaner;
        }
    }
}

