/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.xss.core;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.dreamlu.mica.core.utils.ClassUtil;
import net.dreamlu.mica.xss.config.MicaXssProperties;
import net.dreamlu.mica.xss.core.XssCleanIgnore;
import net.dreamlu.mica.xss.core.XssHolder;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class XssCleanInterceptor
extends HandlerInterceptorAdapter {
    private final MicaXssProperties xssProperties;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (!(handler instanceof HandlerMethod)) {
            return true;
        }
        if (!this.xssProperties.isEnabled()) {
            return true;
        }
        HandlerMethod handlerMethod = (HandlerMethod)handler;
        XssCleanIgnore xssCleanIgnore = (XssCleanIgnore)ClassUtil.getAnnotation((HandlerMethod)handlerMethod, XssCleanIgnore.class);
        if (xssCleanIgnore == null) {
            XssHolder.setEnable();
        }
        return true;
    }

    public void afterConcurrentHandlingStarted(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        XssHolder.remove();
    }

    public XssCleanInterceptor(MicaXssProperties xssProperties) {
        this.xssProperties = xssProperties;
    }
}

