/*
 * Decompiled with CFR 0.152.
 */
package net.mamoe.mirai.console.internal.data;

import java.io.File;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.json.JsonBuilder;
import kotlinx.serialization.json.JsonKt;
import kotlinx.serialization.modules.SerializersModule;
import kotlinx.serialization.modules.SerializersModuleKt;
import net.mamoe.mirai.console.data.MultiFilePluginDataStorage;
import net.mamoe.mirai.console.data.PluginData;
import net.mamoe.mirai.console.data.PluginDataHolder;
import net.mamoe.mirai.console.data.PluginDataStorage;
import net.mamoe.mirai.console.internal.data.MultiFilePluginDataStorageImplKt;
import net.mamoe.mirai.console.internal.data.ReflectionUtilsKt;
import net.mamoe.mirai.console.util.ConsoleExperimentalApi;
import net.mamoe.mirai.message.MessageSerializers;
import net.mamoe.mirai.utils.MiraiLogger;
import net.mamoe.mirai.utils.MiraiUtils;
import net.mamoe.yamlkt.Yaml;
import net.mamoe.yamlkt.YamlBuilder;
import net.mamoe.yamlkt.YamlKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0010\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\rH\u0014J\u001d\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u0013J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\rH\u0017R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lnet/mamoe/mirai/console/internal/data/MultiFilePluginDataStorageImpl;", "Lnet/mamoe/mirai/console/data/PluginDataStorage;", "Lnet/mamoe/mirai/console/data/MultiFilePluginDataStorage;", "directoryPath", "Ljava/nio/file/Path;", "logger", "Lnet/mamoe/mirai/utils/MiraiLogger;", "(Ljava/nio/file/Path;Lnet/mamoe/mirai/utils/MiraiLogger;)V", "getDirectoryPath", "()Ljava/nio/file/Path;", "createYaml", "Lnet/mamoe/yamlkt/Yaml;", "instance", "Lnet/mamoe/mirai/console/data/PluginData;", "getPluginDataFile", "Ljava/io/File;", "holder", "Lnet/mamoe/mirai/console/data/PluginDataHolder;", "getPluginDataFileInternal", "getPluginDataFileInternal$mirai_console", "load", "", "store", "mirai-console"})
public class MultiFilePluginDataStorageImpl
implements PluginDataStorage,
MultiFilePluginDataStorage {
    @NotNull
    private final Path directoryPath;
    @NotNull
    private final MiraiLogger logger;

    public MultiFilePluginDataStorageImpl(@NotNull Path directoryPath, @NotNull MiraiLogger logger2) {
        Intrinsics.checkNotNullParameter((Object)directoryPath, (String)"directoryPath");
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        this.directoryPath = directoryPath;
        this.logger = logger2;
        MultiFilePluginDataStorageImplKt.mkdir(this.directoryPath);
    }

    public /* synthetic */ MultiFilePluginDataStorageImpl(Path path, MiraiLogger miraiLogger, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            miraiLogger = MiraiLogger.Factory.INSTANCE.create(Reflection.getOrCreateKotlinClass(MultiFilePluginDataStorageImpl.class));
        }
        this(path, miraiLogger);
    }

    @Override
    @NotNull
    public final Path getDirectoryPath() {
        return this.directoryPath;
    }

    @Override
    public void load(@NotNull PluginDataHolder holder, @NotNull PluginData instance2) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)instance2, (String)"instance");
        instance2.onInit(holder, this);
        File file = this.getPluginDataFile(holder, instance2);
        String text = StringsKt.removePrefix((String)FilesKt.readText$default((File)file, null, (int)1, null), (CharSequence)"\ufeff");
        if (!StringsKt.isBlank((CharSequence)text)) {
            Yaml yaml = this.createYaml(instance2);
            try {
                yaml.decodeFromString((DeserializationStrategy)instance2.getUpdaterSerializer(), text);
            }
            catch (Throwable cause) {
                FilesKt.copyTo$default((File)file, (File)FilesKt.resolveSibling((File)file, (String)(file.getName() + '.' + MiraiUtils.currentTimeMillis() + ".bak")), (boolean)false, (int)0, (int)6, null);
                throw cause;
            }
        } else {
            this.store(holder, instance2);
        }
    }

    @NotNull
    public final File getPluginDataFileInternal$mirai_console(@NotNull PluginDataHolder holder, @NotNull PluginData instance2) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)instance2, (String)"instance");
        return this.getPluginDataFile(holder, instance2);
    }

    @NotNull
    protected File getPluginDataFile(@NotNull PluginDataHolder holder, @NotNull PluginData instance2) {
        File file;
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)instance2, (String)"instance");
        String name = instance2.getSaveName();
        Path dir = this.directoryPath.resolve(holder.getDataHolderName());
        Intrinsics.checkNotNullExpressionValue((Object)dir, (String)"dir");
        if (MultiFilePluginDataStorageImplKt.isFile(dir)) {
            throw new IllegalStateException(("Target directory " + dir + " for holder " + holder + " is occupied by a file therefore data " + ReflectionUtilsKt.getQualifiedNameOrTip(Reflection.getOrCreateKotlinClass(instance2.getClass())) + " can't be saved.").toString());
        }
        MultiFilePluginDataStorageImplKt.mkdir(dir);
        Path file2 = dir.resolve(name + ".yml");
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"file");
        if (MultiFilePluginDataStorageImplKt.isDirectory(file2)) {
            throw new IllegalStateException(("Target File " + file2 + " is occupied by a directory therefore data " + ReflectionUtilsKt.getQualifiedNameOrTip(Reflection.getOrCreateKotlinClass(instance2.getClass())) + " can't be saved.").toString());
        }
        File it = file = file2.toFile();
        boolean bl = false;
        File file3 = it.getParentFile();
        if (file3 != null) {
            file3.mkdirs();
        }
        it.createNewFile();
        File file4 = file;
        Intrinsics.checkNotNullExpressionValue((Object)file4, (String)"file.toFile().also {\n   \u2026createNewFile()\n        }");
        return file4;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @ConsoleExperimentalApi
    public void store(@NotNull PluginDataHolder holder, @NotNull PluginData instance2) {
        Object object;
        Object object2;
        Object it;
        Object object3;
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)instance2, (String)"instance");
        File file = this.getPluginDataFile(holder, instance2);
        try {
            boolean bl = false;
            it = object3 = this.createYaml(instance2).encodeToString((SerializationStrategy)instance2.getUpdaterSerializer(), (Object)Unit.INSTANCE);
            boolean bl2 = false;
            Yaml.Default.decodeAnyFromString((String)it);
            object2 = Result.constructor-impl((Object)object3);
        }
        catch (Throwable throwable) {
            object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object3 = Result.exceptionOrNull-impl((Object)object2);
        if (object3 == null) {
            object = object2;
        } else {
            Object object4;
            it = object2;
            try {
                Object it2 = object3;
                boolean bl = false;
                this.logger.warning("Could not save " + instance2.getSaveName() + " in YAML format due to exception in YAML encoder. Please report this exception and relevant configurations to https://github.com/mamoe/mirai/issues/new/choose", (Throwable)it2);
                object4 = Result.constructor-impl((Object)JsonKt.Json$default(null, (Function1)((Function1)new Function1<JsonBuilder, Unit>(instance2){
                    final /* synthetic */ PluginData $instance;
                    {
                        this.$instance = $instance;
                        super(1);
                    }

                    public final void invoke(@NotNull JsonBuilder $this$Json) {
                        Intrinsics.checkNotNullParameter((Object)$this$Json, (String)"$this$Json");
                        $this$Json.setSerializersModule(SerializersModuleKt.plus((SerializersModule)MessageSerializers.INSTANCE.getSerializersModule(), (SerializersModule)this.$instance.getSerializersModule()));
                        $this$Json.setPrettyPrint(true);
                        $this$Json.setIgnoreUnknownKeys(true);
                        $this$Json.setLenient(true);
                        $this$Json.setAllowStructuredMapKeys(true);
                        $this$Json.setEncodeDefaults(true);
                    }
                }), (int)1, null).encodeToString((SerializationStrategy)instance2.getUpdaterSerializer(), (Object)Unit.INSTANCE));
            }
            catch (Throwable throwable) {
                object4 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            object = object4;
        }
        object2 = object;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable != null) {
            void it3;
            object3 = throwable;
            boolean bl = false;
            throw new IllegalStateException("Exception while saving " + instance2 + ", saveName=" + instance2.getSaveName(), (Throwable)it3);
        }
        FilesKt.writeText$default((File)file, (String)((String)object2), null, (int)2, null);
    }

    private final Yaml createYaml(PluginData instance2) {
        return YamlKt.Yaml$default(null, (Function1)((Function1)new Function1<YamlBuilder, Unit>(instance2){
            final /* synthetic */ PluginData $instance;
            {
                this.$instance = $instance;
                super(1);
            }

            public final void invoke(@NotNull YamlBuilder $this$Yaml) {
                Intrinsics.checkNotNullParameter((Object)$this$Yaml, (String)"$this$Yaml");
                $this$Yaml.serializersModule = SerializersModuleKt.plus((SerializersModule)MessageSerializers.INSTANCE.getSerializersModule(), (SerializersModule)this.$instance.getSerializersModule());
            }
        }), (int)1, null);
    }
}

