/*
 * Decompiled with CFR 0.152.
 */
package net.mamoe.mirai.console.internal.shutdown;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.FilesKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.ExecutorsKt;
import kotlinx.coroutines.GlobalScope;
import kotlinx.coroutines.JobKt;
import net.mamoe.mirai.console.MiraiConsole;
import net.mamoe.mirai.console.internal.MiraiConsoleImplementationBridge;
import net.mamoe.mirai.console.internal.MiraiConsoleImplementationBridgeKt;
import net.mamoe.mirai.console.internal.shutdown.ShutdownDaemon;
import net.mamoe.mirai.console.plugin.Plugin;
import net.mamoe.mirai.console.plugin.PluginManager;
import net.mamoe.mirai.console.plugin.description.PluginDescription;
import net.mamoe.mirai.utils.MiraiLogger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0002\u0017\u0018B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\tJ\u0018\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0005H\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0018\u0010\b\u001a\u00020\t*\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u000b\u00a8\u0006\u0019\u00b2\u00060\u0010\u001a\u001a(\u0012\f\u0012\n \u001d*\u0004\u0018\u00010\u001c0\u001c \u001d*\u0014\u0012\u000e\b\u0001\u0012\n \u001d*\u0004\u0018\u00010\u001c0\u001c\u0018\u00010\u001b0\u001bX\u008a\u0084\u0002"}, d2={"Lnet/mamoe/mirai/console/internal/shutdown/ShutdownDaemon;", "", "()V", "pluginDisablingThreads", "Ljava/util/concurrent/ConcurrentLinkedDeque;", "Ljava/lang/Thread;", "getPluginDisablingThreads", "()Ljava/util/concurrent/ConcurrentLinkedDeque;", "isWaiting", "", "Ljava/lang/Thread$State;", "(Ljava/lang/Thread$State;)Z", "dumpCrashReport", "", "saveError", "listen", "thread", "consoleRunning", "Ljava/util/concurrent/atomic/AtomicBoolean;", "start", "bridge", "Lnet/mamoe/mirai/console/internal/MiraiConsoleImplementationBridge;", "threadKill", "DaemonStarter", "ThreadInfoJava9Access", "mirai-console", "stackTraces", "", "Ljava/lang/StackTraceElement;", "kotlin.jvm.PlatformType"})
public final class ShutdownDaemon {
    @NotNull
    public static final ShutdownDaemon INSTANCE = new ShutdownDaemon();
    @NotNull
    private static final ConcurrentLinkedDeque<Thread> pluginDisablingThreads = new ConcurrentLinkedDeque();

    private ShutdownDaemon() {
    }

    @NotNull
    public final ConcurrentLinkedDeque<Thread> getPluginDisablingThreads() {
        return pluginDisablingThreads;
    }

    private final boolean isWaiting(Thread.State $this$isWaiting) {
        return $this$isWaiting == Thread.State.WAITING || $this$isWaiting == Thread.State.TIMED_WAITING;
    }

    private final void start(MiraiConsoleImplementationBridge bridge) {
        Thread crtThread = Thread.currentThread();
        AtomicBoolean isConsoleRunning = new AtomicBoolean(true);
        ExecutorService executor2 = Executors.newFixedThreadPool(3, new ThreadFactory(){
            @NotNull
            private final AtomicInteger counter;
            {
                this.counter = new AtomicInteger(0);
            }

            @NotNull
            public Thread newThread(@NotNull Runnable r) {
                Thread thread;
                Intrinsics.checkNotNullParameter((Object)r, (String)"r");
                Thread it = thread = new Thread(r, "Mirai Console Shutdown Daemon #" + this.counter.getAndIncrement());
                boolean bl = false;
                it.setDaemon(true);
                return thread;
            }
        });
        executor2.execute(() -> ShutdownDaemon.start$lambda-0(crtThread, isConsoleRunning, executor2));
        CoroutineScope coroutineScope = (CoroutineScope)GlobalScope.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)executor2, (String)"executor");
        BuildersKt.launch$default((CoroutineScope)coroutineScope, (CoroutineContext)((CoroutineContext)ExecutorsKt.from((ExecutorService)executor2)), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(bridge, isConsoleRunning, null){
            int label;
            final /* synthetic */ MiraiConsoleImplementationBridge $bridge;
            final /* synthetic */ AtomicBoolean $isConsoleRunning;
            {
                this.$bridge = $bridge;
                this.$isConsoleRunning = $isConsoleRunning;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = JobKt.getJob((CoroutineContext)this.$bridge.getCoroutineContext()).join((Continuation)this);
                        if (v0 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        this.$isConsoleRunning.set(false);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
        MiraiLogger $this$debug$iv = bridge.getMainLogger();
        boolean $i$f$debug = false;
        if ($this$debug$iv.isDebugEnabled()) {
            MiraiLogger miraiLogger = $this$debug$iv;
            boolean bl = false;
            miraiLogger.debug("SHUTDOWN DAEMON STARTED.........");
        }
    }

    public final void dumpCrashReport(boolean saveError) {
        Object object;
        Object $i$a$-runCatching-ShutdownDaemon$dumpCrashReport$isAndroidSystem$22;
        try {
            boolean $i$a$-runCatching-ShutdownDaemon$dumpCrashReport$isAndroidSystem$22 = false;
            $i$a$-runCatching-ShutdownDaemon$dumpCrashReport$isAndroidSystem$22 = Result.constructor-impl(Class.forName("android.util.Log"));
        }
        catch (Throwable throwable) {
            $i$a$-runCatching-ShutdownDaemon$dumpCrashReport$isAndroidSystem$22 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        boolean isAndroidSystem = Result.isSuccess-impl((Object)$i$a$-runCatching-ShutdownDaemon$dumpCrashReport$isAndroidSystem$22);
        StringBuilder sb = new StringBuilder(1024).append("\n\n");
        long now = System.currentTimeMillis();
        sb.append("=============================================================\n");
        sb.append("MIRAI CONSOLE CRASH REPORT.\n");
        sb.append("Console has take too long to shutdown.\n\n");
        sb.append("TIME: ").append(now).append(" <");
        if (isAndroidSystem) {
            sb.append(new Date(now));
            ShutdownDaemon.dumpCrashReport$msgAfterTimeDump(sb);
            sb.append("\n\nTHREADS:\n\n");
            Map<Thread, StackTraceElement[]> threads = Thread.getAllStackTraces();
            Intrinsics.checkNotNullExpressionValue(threads, (String)"threads");
            Map<Thread, StackTraceElement[]> $this$forEach$iv = threads;
            boolean $i$f$forEach = false;
            for (Map.Entry<Thread, StackTraceElement[]> element$iv : $this$forEach$iv.entrySet()) {
                object = element$iv;
                boolean bl = false;
                Thread thread = object.getKey();
                StackTraceElement[] stackTrace = object.getValue();
                sb.append("\n\n\n").append(thread).append('\n');
                Intrinsics.checkNotNullExpressionValue((Object)stackTrace, (String)"stackTrace");
                StackTraceElement[] $this$forEach$iv2 = stackTrace;
                boolean $i$f$forEach2 = false;
                int n = $this$forEach$iv2.length;
                for (int i = 0; i < n; ++i) {
                    StackTraceElement element$iv2;
                    StackTraceElement stack = element$iv2 = $this$forEach$iv2[i];
                    boolean bl2 = false;
                    sb.append('\t').append(stack).append('\n');
                }
            }
        } else {
            new Object(sb, now){
                final /* synthetic */ StringBuilder $sb;
                final /* synthetic */ long $now;
                {
                    this.$sb = $sb;
                    this.$now = $now;
                }

                /*
                 * WARNING - void declaration
                 */
                public final void a() {
                    void $this$forEach$iv;
                    void $this$forEach$iv2;
                    this.$sb.append(Instant.ofEpochMilli(this.$now).atOffset(ZoneOffset.UTC));
                    ShutdownDaemon.access$dumpCrashReport$msgAfterTimeDump(this.$sb);
                    RuntimeMXBean rtMxBean = ManagementFactory.getRuntimeMXBean();
                    this.$sb.append("PROCESS: ").append(rtMxBean.getName());
                    this.$sb.append("\nVM OPTIONS:\n");
                    List<String> list = rtMxBean.getInputArguments();
                    Intrinsics.checkNotNullExpressionValue(list, (String)"rtMxBean.inputArguments");
                    Iterable iterable = list;
                    StringBuilder stringBuilder = this.$sb;
                    boolean $i$f$forEach22 = false;
                    for (T element$iv : $this$forEach$iv2) {
                        String cmd = (String)element$iv;
                        boolean bl = false;
                        stringBuilder.append("  ").append(cmd).append("\n");
                    }
                    this.$sb.append("\n\nTHREADS:\n\n");
                    ThreadMXBean threadMxBean = ManagementFactory.getThreadMXBean();
                    ThreadInfo[] infs = threadMxBean.dumpAllThreads(true, true);
                    Intrinsics.checkNotNullExpressionValue((Object)infs, (String)"infs");
                    ThreadInfo[] $i$f$forEach22 = infs;
                    StringBuilder stringBuilder2 = this.$sb;
                    boolean $i$f$forEach = false;
                    int n = ((void)$this$forEach$iv).length;
                    for (int i = 0; i < n; ++i) {
                        String string;
                        void element$iv;
                        void inf = element$iv = $this$forEach$iv[i];
                        boolean bl = false;
                        stringBuilder2.append("\n\n").append('\"');
                        stringBuilder2.append(inf.getThreadName());
                        stringBuilder2.append('\"');
                        Intrinsics.checkNotNullExpressionValue((Object)inf, (String)"inf");
                        if (ThreadInfoJava9Access.INSTANCE.isDaemon(inf)) {
                            stringBuilder2.append(" daemon");
                        }
                        if (ThreadInfoJava9Access.INSTANCE.getCanGetPri()) {
                            stringBuilder2.append(" prio=").append(ThreadInfoJava9Access.INSTANCE.getPriority(inf));
                        }
                        stringBuilder2.append(" Id=").append(inf.getThreadId());
                        String string2 = string = inf.getLockName();
                        if (string2 != null) {
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"lockName");
                            String it = string;
                            boolean bl2 = false;
                            stringBuilder2.append(" on ").append(it);
                        }
                        String string3 = string = inf.getLockOwnerName();
                        if (string3 != null) {
                            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"lockOwnerName");
                            String lon = string;
                            boolean bl3 = false;
                            stringBuilder2.append(" owned by \"").append(lon);
                            stringBuilder2.append("\" Id=").append(inf.getLockOwnerId());
                        }
                        if (inf.isSuspended()) {
                            stringBuilder2.append(" (suspended)");
                        }
                        if (inf.isInNative()) {
                            stringBuilder2.append(" (in native)");
                        }
                        stringBuilder2.append('\n');
                        LockInfo lockInf = inf.getLockInfo();
                        MonitorInfo[] lockedMonitors = inf.getLockedMonitors();
                        StackTraceElement[] stackTraceElementArray = inf.getStackTrace();
                        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"inf.stackTrace");
                        Object[] $this$forEachIndexed$iv = stackTraceElementArray;
                        boolean $i$f$forEachIndexed = false;
                        int index$iv = 0;
                        for (Object item$iv : $this$forEachIndexed$iv) {
                            void stackTraceElement;
                            int n2 = index$iv++;
                            StackTraceElement stackTraceElement2 = (StackTraceElement)item$iv;
                            int index = n2;
                            boolean bl4 = false;
                            stringBuilder2.append("\tat ").append(stackTraceElement).append('\n');
                            if (index == 0 && lockInf != null) {
                                Thread.State state = inf.getThreadState();
                                Intrinsics.checkNotNull((Object)((Object)state));
                                switch (dumpCrashReport.WhenMappings.$EnumSwitchMapping$0[state.ordinal()]) {
                                    case 1: {
                                        stringBuilder2.append("\t-  blocked on ").append(lockInf).append('\n');
                                        break;
                                    }
                                    case 2: 
                                    case 3: {
                                        stringBuilder2.append("\t-  waiting on ").append(lockInf).append('\n');
                                    }
                                }
                            }
                            Intrinsics.checkNotNullExpressionValue((Object)lockedMonitors, (String)"lockedMonitors");
                            MonitorInfo[] $this$forEach$iv3 = lockedMonitors;
                            boolean $i$f$forEach3 = false;
                            int n3 = $this$forEach$iv3.length;
                            for (int j = 0; j < n3; ++j) {
                                MonitorInfo element$iv2;
                                MonitorInfo mi = element$iv2 = $this$forEach$iv3[j];
                                boolean bl5 = false;
                                if (mi.getLockedStackDepth() != index) continue;
                                stringBuilder2.append("\t-  locked ").append(mi).append('\n');
                            }
                        }
                        stringBuilder2.append("\n\n");
                    }
                }
            }.a();
        }
        sb.append("\n\n");
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        String report = string;
        if (!isAndroidSystem && saveError) {
            Object $i$a$-runCatching-ShutdownDaemon$dumpCrashReport$52;
            try {
                boolean $i$a$-runCatching-ShutdownDaemon$dumpCrashReport$52 = false;
                new PrintStream(new FileOutputStream(FileDescriptor.err)).println(report);
                $i$a$-runCatching-ShutdownDaemon$dumpCrashReport$52 = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable $i$f$forEach) {
                $i$a$-runCatching-ShutdownDaemon$dumpCrashReport$52 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$i$f$forEach));
            }
        }
        if (saveError) {
            Object object2;
            String fileName = "CONSOLE_CRASH_REPORT_" + now + ".log";
            try {
                boolean bl = false;
                Path path = MiraiConsole.INSTANCE.getRootPath().resolve(fileName);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"MiraiConsole.rootPath.resolve(fileName)");
                PathsKt.writeText$default((Path)path, (CharSequence)report, null, (OpenOption[])new OpenOption[0], (int)2, null);
                object2 = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable throwable) {
                object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable != null) {
                Object object3 = object2;
                try {
                    Throwable it = throwable;
                    boolean bl = false;
                    if (!isAndroidSystem) {
                        FilesKt.writeText$default((File)new File("CONSOLE_CRASH_REPORT_" + now + ".log"), (String)report, null, (int)2, null);
                    }
                    object = Result.constructor-impl((Object)Unit.INSTANCE);
                }
                catch (Throwable throwable2) {
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable2));
                }
            }
        }
        try {
            boolean bl = false;
            MiraiConsole.INSTANCE.getMainLogger().error(report);
            Object object4 = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable throwable) {
            Object object5 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
    }

    private final void listen(Thread thread, AtomicBoolean consoleRunning) {
        long startTime = System.currentTimeMillis();
        long timeout = 60000L;
        while (consoleRunning.get()) {
            Iterable $this$forEach$iv;
            long crtTime = System.currentTimeMillis();
            if (crtTime - startTime >= timeout) {
                Object $i$a$-runCatching-ShutdownDaemon$listen$22;
                try {
                    boolean $i$a$-runCatching-ShutdownDaemon$listen$22 = false;
                    INSTANCE.dumpCrashReport(true);
                    $i$a$-runCatching-ShutdownDaemon$listen$22 = Result.constructor-impl((Object)Unit.INSTANCE);
                }
                catch (Throwable throwable) {
                    $i$a$-runCatching-ShutdownDaemon$listen$22 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                $this$forEach$iv = pluginDisablingThreads;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Thread it = (Thread)element$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    INSTANCE.threadKill(it);
                }
                this.threadKill(thread);
                pluginDisablingThreads.clear();
                return;
            }
            Thread.sleep(1000L);
            $this$forEach$iv = pluginDisablingThreads;
            boolean $i$f$forEach = false;
            block4: for (Object element$iv : $this$forEach$iv) {
                Thread pluginCrtThread = (Thread)element$iv;
                boolean bl = false;
                Lazy stackTraces$delegate = LazyKt.lazy((Function0)((Function0)new Function0<StackTraceElement[]>(pluginCrtThread){
                    final /* synthetic */ Thread $pluginCrtThread;
                    {
                        this.$pluginCrtThread = $pluginCrtThread;
                        super(0);
                    }

                    public final StackTraceElement[] invoke() {
                        return this.$pluginCrtThread.getStackTrace();
                    }
                }));
                Thread.State state = pluginCrtThread.getState();
                Intrinsics.checkNotNullExpressionValue((Object)((Object)state), (String)"pluginCrtThread.state");
                if (!INSTANCE.isWaiting(state)) continue;
                int n = RangesKt.coerceAtMost((int)ShutdownDaemon.listen$lambda-18$lambda-17((Lazy<StackTraceElement[]>)stackTraces$delegate).length, (int)10);
                for (int i = 0; i < n; ++i) {
                    StackTraceElement stack = ShutdownDaemon.listen$lambda-18$lambda-17((Lazy<StackTraceElement[]>)stackTraces$delegate)[i];
                    String string = stack.getClassName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"stack.className");
                    if (!StringsKt.startsWith$default((String)string, (String)"java.awt.", (boolean)false, (int)2, null)) continue;
                    String string2 = stack.getMethodName();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"stack.methodName");
                    if (!StringsKt.contains((CharSequence)string2, (CharSequence)"dispose", (boolean)true)) continue;
                    pluginCrtThread.interrupt();
                    continue block4;
                }
            }
        }
    }

    private final void threadKill(Thread thread) {
        thread.interrupt();
        Thread.sleep(10L);
        if (!thread.isAlive()) {
            return;
        }
        Thread.sleep(100L);
        if (!thread.isAlive()) {
            return;
        }
        Thread.sleep(500L);
        if (thread.isAlive()) {
            thread.stop();
        }
    }

    private static final void start$lambda-0(Thread $crtThread, AtomicBoolean $isConsoleRunning, ExecutorService $executor) {
        Intrinsics.checkNotNullParameter((Object)$isConsoleRunning, (String)"$isConsoleRunning");
        Intrinsics.checkNotNullExpressionValue((Object)$crtThread, (String)"crtThread");
        INSTANCE.listen($crtThread, $isConsoleRunning);
        $executor.shutdown();
    }

    /*
     * WARNING - void declaration
     */
    private static final void dumpCrashReport$msgAfterTimeDump(StringBuilder sb) {
        Object $i$a$-runCatching-ShutdownDaemon$dumpCrashReport$msgAfterTimeDump$32;
        sb.append(">\nSYSTEM: ").append(System.getProperty("os.name")).append(" ").append(System.getProperty("os.arch")).append(" ").append(System.getProperty("os.version"));
        sb.append("\nJRT:\n  ");
        sb.append(System.getProperty("java.runtime.name"));
        sb.append("  ").append(System.getProperty("java.version"));
        sb.append("\n    by ").append(System.getProperty("java.vendor"));
        sb.append("\nSPEC:\n  ").append(System.getProperty("java.specification.name")).append(" ").append(System.getProperty("java.specification.version"));
        sb.append("\n    by ").append(System.getProperty("java.specification.vendor"));
        sb.append("\nVM:\n  ").append(System.getProperty("java.vm.name")).append(" ").append(System.getProperty("java.vm.version"));
        sb.append("\n    by ").append(System.getProperty("java.vm.vendor"));
        sb.append("\n\n");
        try {
            boolean $i$a$-runCatching-ShutdownDaemon$dumpCrashReport$msgAfterTimeDump$32 = false;
            StringBuilder stringBuilder = sb.append("\nPROCESS Working dir: ");
            Object object = new File("a").getAbsoluteFile().getParent();
            if (object == null) {
                object = new File(".").getAbsoluteFile();
            }
            stringBuilder.append(object);
            $i$a$-runCatching-ShutdownDaemon$dumpCrashReport$msgAfterTimeDump$32 = Result.constructor-impl((Object)sb.append("\nConsole Working Dir: ").append(MiraiConsole.INSTANCE.getRootPath().toAbsolutePath()));
        }
        catch (Throwable throwable) {
            $i$a$-runCatching-ShutdownDaemon$dumpCrashReport$msgAfterTimeDump$32 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        sb.append("\nLoaded plugins:\n");
        try {
            boolean bl = false;
            Iterable $this$forEach$iv = MiraiConsoleImplementationBridgeKt.getPluginManagerImpl((MiraiConsole)((MiraiConsole)MiraiConsole.INSTANCE)).resolvedPlugins;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                URL f;
                URL uRL;
                String string;
                void this_$iv;
                Plugin plugin = (Plugin)element$iv;
                boolean bl2 = false;
                PluginManager.INSTANCE iNSTANCE = PluginManager.INSTANCE;
                Plugin $this$description$iv = plugin;
                boolean $i$f$getDescription = false;
                PluginDescription desc = this_$iv.getPluginDescription($this$description$iv);
                sb.append("|- ").append(desc.getName()).append(" v").append(desc.getVersion()).append('\n');
                sb.append("|   `- ID: ").append(desc.getId()).append('\n');
                String it = string = desc.getAuthor();
                boolean bl3 = false;
                String string2 = !StringsKt.isBlank((CharSequence)it) ? string : null;
                if (string2 != null) {
                    it = string2;
                    boolean bl4 = false;
                    sb.append("|   `- AUTHOR: ").append(it).append('\n');
                }
                sb.append("|   `- MAIN: ").append(plugin.getClass()).append('\n');
                Object object = plugin.getClass().getProtectionDomain();
                if (object == null || (object = ((ProtectionDomain)object).getCodeSource()) == null || (object = (uRL = ((CodeSource)object).getLocation())) == null) continue;
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"location");
                URL from = uRL;
                boolean bl5 = false;
                Intrinsics.checkNotNullExpressionValue((Object)(Intrinsics.areEqual((Object)from.getProtocol(), (Object)"file") ? Paths.get(from.toURI()) : from), (String)"when {\n                 \u2026                        }");
                f = f;
                sb.append("|   `- FROM: ").append(f).append('\n');
            }
            Object object = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable throwable) {
            Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        sb.append("\n\n\n");
    }

    private static final StackTraceElement[] listen$lambda-18$lambda-17(Lazy<StackTraceElement[]> $stackTraces$delegate) {
        Lazy<StackTraceElement[]> lazy = $stackTraces$delegate;
        return (StackTraceElement[])lazy.getValue();
    }

    public static final /* synthetic */ void access$dumpCrashReport$msgAfterTimeDump(StringBuilder sb) {
        ShutdownDaemon.dumpCrashReport$msgAfterTimeDump(sb);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lnet/mamoe/mirai/console/internal/shutdown/ShutdownDaemon$DaemonStarter;", "", "consoleImplementationBridge", "Lnet/mamoe/mirai/console/internal/MiraiConsoleImplementationBridge;", "(Lnet/mamoe/mirai/console/internal/MiraiConsoleImplementationBridge;)V", "started", "Ljava/util/concurrent/atomic/AtomicBoolean;", "tryStart", "", "mirai-console"})
    public static final class DaemonStarter {
        @NotNull
        private final MiraiConsoleImplementationBridge consoleImplementationBridge;
        @NotNull
        private final AtomicBoolean started;

        public DaemonStarter(@NotNull MiraiConsoleImplementationBridge consoleImplementationBridge) {
            Intrinsics.checkNotNullParameter((Object)consoleImplementationBridge, (String)"consoleImplementationBridge");
            this.consoleImplementationBridge = consoleImplementationBridge;
            this.started = new AtomicBoolean(false);
        }

        public final void tryStart() {
            if (this.started.compareAndSet(false, true)) {
                INSTANCE.start(this.consoleImplementationBridge);
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0001J\u000e\u0010\r\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0001R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lnet/mamoe/mirai/console/internal/shutdown/ShutdownDaemon$ThreadInfoJava9Access;", "", "()V", "canGetPri", "", "getCanGetPri", "()Z", "getPriorityM", "Ljava/lang/reflect/Method;", "isDaemonM", "getPriority", "", "inf", "isDaemon", "mirai-console"})
    private static final class ThreadInfoJava9Access {
        @NotNull
        public static final ThreadInfoJava9Access INSTANCE = new ThreadInfoJava9Access();
        @Nullable
        private static final Method isDaemonM;
        @Nullable
        private static final Method getPriorityM;

        private ThreadInfoJava9Access() {
        }

        public final boolean isDaemon(@NotNull Object inf) {
            Intrinsics.checkNotNullParameter((Object)inf, (String)"inf");
            Object object = isDaemonM;
            if (object != null && (object = ((Method)object).invoke(inf, new Object[0])) != null) {
                Object it = object;
                boolean bl = false;
                return (Boolean)it;
            }
            return false;
        }

        public final int getPriority(@NotNull Object inf) {
            Intrinsics.checkNotNullParameter((Object)inf, (String)"inf");
            Object object = getPriorityM;
            if (object != null && (object = ((Method)object).invoke(inf, new Object[0])) != null) {
                Object it = object;
                boolean bl = false;
                return (Integer)it;
            }
            return -1;
        }

        public final boolean getCanGetPri() {
            return getPriorityM != null;
        }

        static {
            Ref.ObjectRef idm = new Ref.ObjectRef();
            Ref.ObjectRef gpm = new Ref.ObjectRef();
            try {
                Object v2;
                block5: {
                    Object v1;
                    Method it;
                    Sequence $this$firstOrNull$iv;
                    boolean $i$f$firstOrNull;
                    Ref.ObjectRef objectRef;
                    Sequence mts;
                    block4: {
                        boolean bl = false;
                        Class<?> klass = Class.forName("java.lang.management.ThreadInfo");
                        Method[] methodArray = klass.getMethods();
                        Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"klass.methods");
                        Sequence sequence = mts = ArraysKt.asSequence((Object[])methodArray);
                        objectRef = idm;
                        $i$f$firstOrNull = false;
                        for (Object element$iv : $this$firstOrNull$iv) {
                            it = (Method)element$iv;
                            boolean bl2 = false;
                            if (!Intrinsics.areEqual((Object)it.getName(), (Object)"isDaemon")) continue;
                            v1 = element$iv;
                            break block4;
                        }
                        v1 = null;
                    }
                    objectRef.element = v1;
                    $this$firstOrNull$iv = mts;
                    objectRef = gpm;
                    $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        it = (Method)element$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getName(), (Object)"getPriority")) continue;
                        v2 = element$iv;
                        break block5;
                    }
                    v2 = null;
                }
                objectRef.element = v2;
                Object object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable throwable) {
                Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            isDaemonM = (Method)idm.element;
            getPriorityM = (Method)gpm.element;
        }
    }
}

