/*
 * Decompiled with CFR 0.152.
 */
package com.mingsoft.basic.action;

import com.alibaba.fastjson.serializer.SerializeFilter;
import com.mingsoft.base.constant.e.BaseSessionEnum;
import com.mingsoft.base.entity.BaseEntity;
import com.mingsoft.base.filter.DateValueFilter;
import com.mingsoft.base.filter.DoubleValueFilter;
import com.mingsoft.basic.action.BaseAction;
import com.mingsoft.basic.biz.ICategoryBiz;
import com.mingsoft.basic.constant.e.SessionConstEnum;
import com.mingsoft.basic.entity.AppEntity;
import com.mingsoft.basic.entity.CategoryEntity;
import com.mingsoft.basic.entity.ManagerSessionEntity;
import com.mingsoft.util.StringUtil;
import java.sql.Timestamp;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.mingsoft.base.util.JSONArray;
import net.mingsoft.base.util.JSONObject;
import net.mingsoft.basic.bean.EUListBean;
import net.mingsoft.basic.util.BasicUtil;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/${managerPath}/category"})
public class CategoryAction
extends BaseAction {
    @Autowired
    private ICategoryBiz categoryBiz;

    @RequestMapping(value={"/index"})
    @RequiresPermissions(value={"category:view"})
    public String index(HttpServletResponse response, HttpServletRequest request, ModelMap model) {
        String modelTitle = BasicUtil.getString((String)"modelTitle");
        int modelId = BasicUtil.getInt((String)"modelId");
        model.addAttribute("modelTitle", (Object)modelTitle);
        model.addAttribute("modelId", (Object)modelId);
        return this.view("/category/index");
    }

    @RequestMapping(value={"/list"})
    @ResponseBody
    public void list(@ModelAttribute CategoryEntity category, HttpServletResponse response, HttpServletRequest request, ModelMap model) {
        String modelId = request.getParameter("modelId");
        this.setSession(request, (BaseSessionEnum)SessionConstEnum.MANAGER_MODEL_CODE, (Object)modelId);
        ManagerSessionEntity managerSession = this.getManagerBySession(request);
        category.setCategoryModelId(Integer.parseInt(modelId));
        AppEntity app = this.getApp(request);
        category.setCategoryAppId(app.getAppId());
        if (managerSession.getManagerId() != app.getAppManagerId()) {
            category.setCategoryManagerId(managerSession.getManagerId());
        }
        BasicUtil.startPage();
        List categoryList = this.categoryBiz.query((BaseEntity)category);
        this.outJson(response, (Object)JSONArray.toJSONString((Object)new EUListBean(categoryList, (int)BasicUtil.endPage((List)categoryList).getTotal()), (SerializeFilter[])new SerializeFilter[]{new DoubleValueFilter(), new DateValueFilter()}));
    }

    @RequestMapping(value={"/form"})
    public String form(@ModelAttribute CategoryEntity category, HttpServletResponse response, HttpServletRequest request, ModelMap model) {
        if (category.getCategoryId() > 0) {
            BaseEntity categoryEntity = this.categoryBiz.getEntity(category.getCategoryId());
            model.addAttribute("categoryEntity", (Object)categoryEntity);
        }
        request.setAttribute("modelTitle", (Object)BasicUtil.getString((String)"modelTitle"));
        request.setAttribute("modelId", (Object)BasicUtil.getInt((String)"modelId"));
        return this.view("/category/form");
    }

    @RequestMapping(value={"/get"})
    @ResponseBody
    public void get(@ModelAttribute CategoryEntity category, HttpServletResponse response, HttpServletRequest request, ModelMap model) {
        if (category.getCategoryId() <= 0) {
            this.outJson(response, null, false, this.getResString("err.error", new String[]{this.getResString("category.id")}));
            return;
        }
        CategoryEntity _category = (CategoryEntity)this.categoryBiz.getEntity(category.getCategoryId());
        this.outJson(response, (BaseEntity)_category);
    }

    @PostMapping(value={"/save"})
    @RequiresPermissions(value={"category:save"})
    @ResponseBody
    public void save(@ModelAttribute CategoryEntity category, HttpServletResponse response, HttpServletRequest request) {
        if (StringUtil.isBlank((String)category.getCategoryTitle())) {
            this.outJson(response, null, false, this.getResString("err.empty", new String[]{this.getResString("category.title")}));
            return;
        }
        if (!StringUtil.checkLength((String)(category.getCategoryTitle() + ""), (int)1, (int)50)) {
            this.outJson(response, null, false, this.getResString("err.length", new String[]{this.getResString("category.title"), "1", "50"}));
            return;
        }
        if (!StringUtil.checkLength((String)(category.getCategoryDescription() + ""), (int)0, (int)45)) {
            this.outJson(response, null, false, this.getResString("err.length", new String[]{this.getResString("category.description"), "1", "45"}));
            return;
        }
        category.setCategoryManagerId(this.getManagerBySession(request).getManagerId());
        category.setCategoryDateTime(new Timestamp(System.currentTimeMillis()));
        category.setCategoryAppId(BasicUtil.getAppId());
        this.categoryBiz.saveEntity((BaseEntity)category);
        this.outJson(response, (Object)JSONObject.toJSONString((Object)category));
    }

    @RequestMapping(value={"/delete"})
    @RequiresPermissions(value={"category:delete"})
    @ResponseBody
    public void delete(@RequestBody List<CategoryEntity> categorys, HttpServletResponse response, HttpServletRequest request) {
        int[] ids = new int[categorys.size()];
        for (int i = 0; i < categorys.size(); ++i) {
            ids[i] = categorys.get(i).getCategoryId();
        }
        this.categoryBiz.delete(ids);
        this.outJson(response, true);
    }

    @PostMapping(value={"/update"})
    @RequiresPermissions(value={"category:update"})
    @ResponseBody
    public void update(@ModelAttribute CategoryEntity category, HttpServletResponse response, HttpServletRequest request) {
        if (StringUtil.isBlank((String)category.getCategoryTitle())) {
            this.outJson(response, null, false, this.getResString("err.empty", new String[]{this.getResString("category.title")}));
            return;
        }
        if (!StringUtil.checkLength((String)(category.getCategoryTitle() + ""), (int)1, (int)50)) {
            this.outJson(response, null, false, this.getResString("err.length", new String[]{this.getResString("category.title"), "1", "50"}));
            return;
        }
        if (!StringUtil.checkLength((String)(category.getCategoryDescription() + ""), (int)0, (int)45)) {
            this.outJson(response, null, false, this.getResString("err.length", new String[]{this.getResString("category.description"), "1", "45"}));
            return;
        }
        category.setCategoryManagerId(this.getManagerBySession(request).getManagerId());
        this.categoryBiz.updateEntity((BaseEntity)category);
        this.outJson(response, (Object)JSONObject.toJSONString((Object)category));
    }

    @RequestMapping(value={"/{categoryId}/queryChildren"})
    public void queryChildren(@PathVariable int categoryId, HttpServletRequest request, ModelMap mode, HttpServletResponse response) {
        CategoryEntity category = (CategoryEntity)this.categoryBiz.getEntity(categoryId);
        if (category != null) {
            List list = this.categoryBiz.queryChilds(category);
            this.outJson(response, (Object)JSONObject.toJSONString((Object)list));
        }
    }
}

