/*
 * Decompiled with CFR 0.152.
 */
package com.mingsoft.basic.action;

import com.alibaba.fastjson.JSONObject;
import com.mingsoft.base.constant.e.BaseEnum;
import com.mingsoft.base.entity.BaseEntity;
import com.mingsoft.basic.action.BaseAction;
import com.mingsoft.basic.biz.IManagerBiz;
import com.mingsoft.basic.biz.IModelBiz;
import com.mingsoft.basic.constant.ModelCode;
import com.mingsoft.basic.entity.ManagerEntity;
import com.mingsoft.basic.entity.ManagerSessionEntity;
import com.mingsoft.basic.entity.ModelEntity;
import com.mingsoft.util.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/${managerPath}"})
public class MainAction
extends BaseAction {
    @Autowired
    private IModelBiz modelBiz;
    @Autowired
    private IManagerBiz managerBiz;

    @RequestMapping(value={"/index"})
    public String index(HttpServletRequest request) {
        ManagerSessionEntity managerSession = this.getManagerBySession(request);
        List modelList = new ArrayList();
        ModelEntity model = new ModelEntity();
        modelList = this.modelBiz.queryModelByRoleId(managerSession.getManagerRoleID());
        request.setAttribute("managerSession", (Object)managerSession);
        request.setAttribute("modelList", (Object)JSONObject.toJSONString(modelList));
        int managerId = managerSession.getManagerId();
        Object managerModelPage = null;
        if (managerModelPage != null) {
            request.setAttribute("managerModelPage", managerModelPage);
        }
        return this.view("/index");
    }

    @RequestMapping(value={"/main"})
    public String main(HttpServletRequest request) {
        return this.view("/main");
    }

    @RequestMapping(value={"/rf"})
    @ResponseBody
    public void rf(HttpServletRequest request) {
    }

    @RequestMapping(value={"/{modelId}/queryListByModelId"}, method={RequestMethod.POST})
    @ResponseBody
    public Map queryListByModelId(@PathVariable int modelId, HttpServletRequest request) {
        HashMap<String, List> modelMap = new HashMap<String, List>();
        List modelList = null;
        ManagerSessionEntity managerSession = this.getManagerBySession(request);
        ModelEntity model = new ModelEntity();
        if (this.isSystemManager(request) && modelId == 1) {
            model.setModelManagerId(1);
            model.setModelId(modelId);
            modelList = this.modelBiz.query((BaseEntity)model);
        } else if (this.isSystemManager(request)) {
            model.setModelModelId(modelId);
            modelList = this.modelBiz.query((BaseEntity)model);
        } else {
            modelList = this.modelBiz.queryModelByRoleId(managerSession.getManagerRoleID());
            for (int i = 0; i < modelList.size(); ++i) {
                ModelEntity _model = (ModelEntity)modelList.get(i);
                if (_model.getModelModelId() == modelId) continue;
                modelList.remove(i);
                --i;
            }
        }
        modelMap.put("modelList", modelList);
        return modelMap;
    }

    @RequestMapping(value={"/editPassword"})
    @ResponseBody
    public void editPassword(HttpServletResponse response, HttpServletRequest request) {
        ManagerSessionEntity manager = this.getManagerBySession(request);
        this.outJson(response, (BaseEnum)ModelCode.ROLE, false, JSONObject.toJSONString((Object)manager.getManagerName()));
    }

    @RequestMapping(value={"/updatePassword"})
    @ResponseBody
    public void updatePassword(HttpServletResponse response, HttpServletRequest request) {
        String oldManagerPassword = StringUtil.Md5((String)request.getParameter("oldManagerPassword"));
        String newManagerPassword = request.getParameter("newManagerPassword");
        ManagerSessionEntity manager = this.getManagerBySession(request);
        if (StringUtil.isBlank((String)newManagerPassword) || StringUtil.isBlank((String)oldManagerPassword)) {
            this.outJson(response, (BaseEnum)ModelCode.ROLE, false, this.getResString("err.empty", new String[]{this.getResString("managerPassword")}));
            return;
        }
        if (!oldManagerPassword.equals(manager.getManagerPassword())) {
            this.outJson(response, (BaseEnum)ModelCode.ROLE, false, this.getResString("err.password", new String[]{this.getResString("managerPassword")}));
            return;
        }
        if (!StringUtil.checkLength((String)newManagerPassword, (int)1, (int)16)) {
            this.outJson(response, (BaseEnum)ModelCode.ROLE, false, this.getResString("err.length", new String[]{this.getResString("managerPassword"), "1", "16"}));
            return;
        }
        manager.setManagerPassword(StringUtil.Md5((String)newManagerPassword));
        this.managerBiz.updateUserPasswordByUserName((ManagerEntity)manager);
        this.outJson(response, (BaseEnum)ModelCode.ROLE, true, null);
    }

    @RequestMapping(value={"/loginOut"})
    @ResponseBody
    public boolean loginOut(HttpServletRequest request) {
        Subject subject = SecurityUtils.getSubject();
        subject.logout();
        return true;
    }

    @RequestMapping(value={"/ui"})
    public String ui(HttpServletRequest request) {
        return this.view("/ui");
    }

    @RequestMapping(value={"/ui/list"})
    public String list(HttpServletRequest request) {
        return this.view("/ui/list");
    }

    @RequestMapping(value={"/ui/form"})
    public String form(HttpServletRequest request) {
        return this.view("/ui/from");
    }
}

