/*
 * Decompiled with CFR 0.152.
 */
package com.mingsoft.basic.action;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.mingsoft.base.constant.e.BaseEnum;
import com.mingsoft.base.entity.BaseEntity;
import com.mingsoft.basic.action.BaseAction;
import com.mingsoft.basic.biz.IManagerBiz;
import com.mingsoft.basic.biz.IModelBiz;
import com.mingsoft.basic.biz.IRoleModelBiz;
import com.mingsoft.basic.constant.ModelCode;
import com.mingsoft.basic.entity.ManagerEntity;
import com.mingsoft.basic.entity.ManagerSessionEntity;
import com.mingsoft.basic.entity.ModelEntity;
import com.mingsoft.basic.entity.RoleModelEntity;
import com.mingsoft.util.StringUtil;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.mingsoft.base.util.JSONArray;
import net.mingsoft.basic.bean.EUListBean;
import net.mingsoft.basic.util.BasicUtil;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/${managerPath}/model"})
public class ModelAction
extends BaseAction {
    @Autowired
    private IModelBiz modelBiz;
    @Autowired
    private IManagerBiz managerBiz;
    @Autowired
    private IRoleModelBiz roleModelBiz;

    @RequestMapping(value={"/index"})
    public String index(HttpServletResponse response, HttpServletRequest request, ModelMap mode) {
        ManagerSessionEntity managerSession = this.getManagerBySession(request);
        int currentRoleId = managerSession.getManagerRoleID();
        List parentModelList = this.modelBiz.queryModelByRoleId(currentRoleId);
        mode.addAttribute("parentModelList", (Object)com.alibaba.fastjson.JSONArray.toJSONString((Object)parentModelList));
        return this.view("/model/index");
    }

    @RequestMapping(value={"/list"})
    @ResponseBody
    public void list(@ModelAttribute ModelEntity modelEntity, HttpServletResponse response, HttpServletRequest request, ModelMap model) {
        ManagerSessionEntity managerSession = this.getManagerBySession(request);
        int currentRoleId = managerSession.getManagerRoleID();
        List modelList = this.modelBiz.queryModelByRoleId(currentRoleId);
        EUListBean _list = new EUListBean(modelList, modelList.size());
        this.outJson(response, (Object)JSONArray.toJSONString((Object)_list, (SerializeFilter[])new SerializeFilter[0]));
    }

    @RequestMapping(value={"/get"})
    @ResponseBody
    public void get(@ModelAttribute ModelEntity modelEntity, HttpServletResponse response, HttpServletRequest request, ModelMap model) {
        if (modelEntity.getModelId() <= 0) {
            this.outJson(response, null, false, this.getResString("err.error", new String[]{this.getResString("model.id")}));
            return;
        }
        ModelEntity _model = (ModelEntity)this.modelBiz.getEntity(modelEntity.getModelId());
        if (_model != null) {
            HashMap<String, ModelEntity> mode = new HashMap<String, ModelEntity>();
            ModelEntity parentModel = (ModelEntity)this.modelBiz.getEntity(_model.getModelModelId());
            mode.put("parentModel", parentModel);
            mode.put("model", _model);
            this.outJson(response, (Object)JSONObject.toJSONString(mode));
            return;
        }
        this.outJson(response, (BaseEntity)_model);
    }

    @PostMapping(value={"/save"})
    @ResponseBody
    @RequiresPermissions(value={"model:save"})
    public void save(@ModelAttribute ModelEntity model, HttpServletResponse response, HttpServletRequest request) {
        if (StringUtil.isBlank((String)model.getModelTitle())) {
            this.outJson(response, null, false, this.getResString("err.empty", new String[]{this.getResString("model.title")}));
            return;
        }
        if (!StringUtil.checkLength((String)(model.getModelTitle() + ""), (int)1, (int)10)) {
            this.outJson(response, null, false, this.getResString("err.length", new String[]{this.getResString("model.title"), "1", "10"}));
            return;
        }
        if (StringUtil.isBlank((String)model.getModelCode())) {
            this.outJson(response, null, false, this.getResString("err.empty", new String[]{this.getResString("model.code")}));
            return;
        }
        if (!StringUtil.checkLength((String)(model.getModelCode() + ""), (int)7, (int)9)) {
            this.outJson(response, null, false, this.getResString("err.length", new String[]{this.getResString("model.code"), "7", "9"}));
            return;
        }
        model.setModelId(this.getManagerId(request));
        model.setModelDatetime(new Timestamp(System.currentTimeMillis()));
        if (!StringUtil.isBlank((String)model.getModelIcon())) {
            model.setModelIcon(model.getModelIcon().replace("|", ""));
        }
        ModelEntity parent = (ModelEntity)this.modelBiz.getEntity(model.getModelModelId());
        String parentIds = "";
        if (parent != null) {
            parentIds = parent.getModelParentIds() != null ? parent.getModelParentIds() + "," + model.getModelModelId() : model.getModelModelId() + "";
        }
        model.setModelParentIds(parentIds);
        this.modelBiz.saveEntity((BaseEntity)model);
        if (model.getModelId() > 0) {
            ManagerSessionEntity managerSession = this.getManagerBySession(request);
            ArrayList<RoleModelEntity> roleModels = new ArrayList<RoleModelEntity>();
            RoleModelEntity rolemodel = new RoleModelEntity();
            rolemodel.setModelId(model.getModelId());
            rolemodel.setRoleId(managerSession.getManagerRoleID());
            roleModels.add(rolemodel);
            this.roleModelBiz.saveEntity(roleModels);
        }
        this.outJson(response, (BaseEnum)ModelCode.ROLE, true, String.valueOf(model.getModelId()));
    }

    @RequestMapping(value={"/delete"})
    @ResponseBody
    @RequiresPermissions(value={"model:del"})
    public void delete(HttpServletResponse response, HttpServletRequest request) {
        int[] ids = BasicUtil.getInts((String)"ids", (String)",");
        this.modelBiz.delete(ids);
        this.outJson(response, true);
    }

    @PostMapping(value={"/update"})
    @RequiresPermissions(value={"model:update"})
    @ResponseBody
    public void update(@ModelAttribute ModelEntity model, HttpServletResponse response, HttpServletRequest request) {
        if (StringUtil.isBlank((String)model.getModelTitle())) {
            this.outJson(response, null, false, this.getResString("err.empty", new String[]{this.getResString("model.title")}));
            return;
        }
        if (!StringUtil.checkLength((String)(model.getModelTitle() + ""), (int)1, (int)10)) {
            this.outJson(response, null, false, this.getResString("err.length", new String[]{this.getResString("model.title"), "1", "10"}));
            return;
        }
        if (StringUtil.isBlank((String)model.getModelCode())) {
            this.outJson(response, null, false, this.getResString("err.empty", new String[]{this.getResString("model.code")}));
            return;
        }
        if (!StringUtil.checkLength((String)(model.getModelCode() + ""), (int)7, (int)9)) {
            this.outJson(response, null, false, this.getResString("err.length", new String[]{this.getResString("model.code"), "7", "9"}));
            return;
        }
        if (!StringUtil.isBlank((String)model.getModelIcon())) {
            model.setModelIcon(model.getModelIcon().replace("|", ""));
        }
        ModelEntity parent = (ModelEntity)this.modelBiz.getEntity(model.getModelModelId());
        String parentIds = "";
        if (parent != null) {
            parentIds = parent.getModelParentIds() != null ? parent.getModelParentIds() + "," + model.getModelModelId() : model.getModelModelId() + "";
        }
        model.setModelParentIds(parentIds);
        this.modelBiz.updateEntity((BaseEntity)model);
        this.outJson(response, (BaseEnum)ModelCode.ROLE, true, String.valueOf(model.getModelId()));
    }

    @RequestMapping(value={"/{managerId}/queryModelByRoleId"})
    public void queryModelByRoleId(@PathVariable int managerId, HttpServletRequest request, HttpServletResponse response) {
        ManagerEntity manager = (ManagerEntity)this.managerBiz.getEntity(managerId);
        if (manager == null) {
            return;
        }
        List modelList = new ArrayList();
        modelList = this.modelBiz.queryModelByRoleId(manager.getManagerRoleID());
        this.outJson(response, null, true, JSONObject.toJSONString(modelList));
    }

    @RequestMapping(value={"/modelList"})
    @ResponseBody
    public void modelList(@ModelAttribute ModelEntity modelEntity, HttpServletResponse response, HttpServletRequest request, ModelMap model) {
        int roleId = BasicUtil.getInt((String)"roleId");
        ManagerSessionEntity managerSession = this.getManagerBySession(request);
        int currentRoleId = managerSession.getManagerRoleID();
        boolean updateFalg = true;
        if (roleId == 0) {
            updateFalg = false;
            roleId = currentRoleId;
        }
        List modelList = this.modelBiz.queryModelByRoleId(currentRoleId);
        ArrayList<ModelEntity> _modelList = new ArrayList<ModelEntity>();
        List roleModelList = new ArrayList();
        if (roleId > 0) {
            roleModelList = this.roleModelBiz.queryByRoleId(roleId);
        }
        ArrayList<ModelEntity> childModelList = new ArrayList<ModelEntity>();
        for (BaseEntity base : modelList) {
            ModelEntity _model = (ModelEntity)base;
            if (_model.getModelIsMenu() == 1) {
                _model.setModelChildList(new ArrayList());
                _modelList.add(_model);
                continue;
            }
            if (_model.getModelIsMenu() != 0) continue;
            childModelList.add(_model);
        }
        for (ModelEntity _modelEntity : _modelList) {
            for (ModelEntity childModel : childModelList) {
                if (childModel.getModelModelId() != _modelEntity.getModelId()) continue;
                _modelEntity.getModelChildList().add(childModel);
                for (RoleModelEntity roleModelEntity : roleModelList) {
                    if (roleModelEntity.getModelId() != childModel.getModelId() || !updateFalg) continue;
                    childModel.setChick(1);
                }
            }
        }
        EUListBean _list = new EUListBean(_modelList, _modelList.size());
        this.outJson(response, (Object)JSONArray.toJSONString((Object)_list, (SerializeFilter[])new SerializeFilter[0]));
    }
}

