/*
 * Decompiled with CFR 0.152.
 */
package com.mingsoft.basic.biz.impl;

import com.mingsoft.base.dao.IBaseDao;
import com.mingsoft.basic.biz.IColumnBiz;
import com.mingsoft.basic.biz.impl.CategoryBizImpl;
import com.mingsoft.basic.dao.IColumnDao;
import com.mingsoft.basic.entity.ColumnEntity;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="columnBiz")
public class ColumnBizImpl
extends CategoryBizImpl
implements IColumnBiz {
    private IColumnDao columnDao;

    public IColumnDao getColumnDao() {
        return this.columnDao;
    }

    @Autowired
    public void setColumnDao(IColumnDao columnDao) {
        this.columnDao = columnDao;
    }

    protected IBaseDao getDao() {
        return this.columnDao;
    }

    public List<ColumnEntity> queryColumnListByWebsiteId(int columnWebsiteId) {
        return this.columnDao.queryColumnListByWebsiteId(columnWebsiteId);
    }

    public List<ColumnEntity> queryChild(int categoryCategoryId, int columnWebsiteId, Integer modelId, Integer size) {
        return this.columnDao.queryColumnByCategoryIdAndWebsiteIdAndModelId(categoryCategoryId, columnWebsiteId, modelId, size);
    }

    public List<ColumnEntity> queryAll(int appId, int modelId) {
        return this.columnDao.queryByAppIdAndModelId(appId, modelId);
    }

    private void queryExpansionColumnListByWebsiteId(int categoryCategoryId, List<ColumnEntity> list, int columnWebsiteId) {
        List queryChildList = new ArrayList();
        queryChildList = this.columnDao.queryColumnByCategoryIdAndWebsiteIdAndModelId(categoryCategoryId, columnWebsiteId, null, null);
        for (int i = 0; i < queryChildList.size(); ++i) {
            list.add((ColumnEntity)queryChildList.get(i));
        }
        if (categoryCategoryId != 0) {
            ColumnEntity columnEntity = (ColumnEntity)this.columnDao.getEntity(Integer.valueOf(categoryCategoryId));
            this.queryExpansionColumnListByWebsiteId(columnEntity.getCategoryCategoryId(), list, columnWebsiteId);
        }
    }

    public List<ColumnEntity> querySibling(int columnId, Integer size) {
        ColumnEntity columnEntity = (ColumnEntity)this.columnDao.getEntity(Integer.valueOf(columnId));
        List<Object> list = new ArrayList<ColumnEntity>();
        if (columnEntity != null) {
            list = this.columnDao.queryColumnByCategoryIdAndWebsiteIdAndModelId(columnEntity.getCategoryCategoryId(), columnEntity.getAppId(), null, size);
        }
        return list;
    }

    public List<ColumnEntity> queryTopSiblingListByColumnId(int columnId, Integer size) {
        ColumnEntity columnEntity = (ColumnEntity)this.columnDao.getEntity(Integer.valueOf(columnId));
        List list = null;
        if (columnEntity != null) {
            list = this.querySibling(columnEntity.getCategoryCategoryId(), size);
        }
        return list;
    }

    public List<ColumnEntity> queryChildListByColumnId(int columnId, Integer size) {
        ColumnEntity columnEntity = (ColumnEntity)this.columnDao.getEntity(Integer.valueOf(columnId));
        List list = null;
        if (columnEntity != null) {
            list = this.columnDao.queryColumnByCategoryIdAndWebsiteIdAndModelId(columnEntity.getCategoryId(), columnEntity.getAppId(), null, size);
        }
        return list;
    }

    public int[] queryChildIdsByColumnId(int categoryId, int appId) {
        List ids = this.columnDao.queryColumnChildIdList(categoryId, appId);
        int[] ret = new int[ids.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (Integer)ids.get(i);
        }
        return ret;
    }

    private void queryColumnParent(ColumnEntity column, List<ColumnEntity> list) {
        if (column.getCategoryCategoryId() != 0) {
            ColumnEntity columnEntity = (ColumnEntity)this.columnDao.getEntity(Integer.valueOf(column.getCategoryCategoryId()));
            list.add(columnEntity);
            this.queryColumnParent(columnEntity, list);
        }
    }

    public List<ColumnEntity> queryParentColumnByColumnId(int columnId) {
        ArrayList list = null;
        ColumnEntity columnEntity = (ColumnEntity)this.columnDao.getEntity(Integer.valueOf(columnId));
        if (columnEntity != null) {
            list = new ArrayList();
            this.queryColumnParent(columnEntity, list);
        }
        return list;
    }

    public int queryColumnChildListCountByWebsiteId(int categoryCategoryId, int columnWebsiteId) {
        return this.columnDao.queryColumnChildListCountByWebsiteId(categoryCategoryId, columnWebsiteId);
    }
}

