/*
 * Decompiled with CFR 0.152.
 */
package com.mingsoft.basic.interceptor;

import com.mingsoft.base.constant.e.BaseCookieEnum;
import com.mingsoft.base.constant.e.BaseSessionEnum;
import com.mingsoft.basic.biz.IAppBiz;
import com.mingsoft.basic.entity.AppEntity;
import com.mingsoft.util.StringUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public abstract class BaseInterceptor
extends HandlerInterceptorAdapter {
    public static final String BASE = "base";
    public static final String BASE_PATH = "basePath";
    public static final String MODEL_ID = "modelId";
    public static final String BASE_URL = "baseUrl";
    public static final String BASE_MANAGER_PATH = "baseManager";
    public static final String MANAGER_PATH = "managerPath";
    public static final String MANAGER_VIEW_PATH = "managerViewPath";
    public static final String PARAMS = "params";
    protected Logger logger = Logger.getLogger(this.getClass());
    protected static boolean IS_WINDOWS = false;

    protected Object getBean(ServletContext sc, String beanName) {
        return WebApplicationContextUtils.getWebApplicationContext((ServletContext)sc).getBean(beanName);
    }

    protected void setSession(HttpServletRequest request, BaseSessionEnum key, Object obj) {
        if (StringUtil.isBlank((String)obj.toString())) {
            return;
        }
        request.getSession().setAttribute(key.toString(), obj);
    }

    protected Object getSession(HttpServletRequest request, BaseSessionEnum key) {
        return request.getSession().getAttribute(key.toString());
    }

    protected void setCookie(HttpServletRequest request, HttpServletResponse response, BaseCookieEnum key, Object value) {
        request.getSession().setAttribute(key.toString(), value);
        Cookie cookie = new Cookie(key.toString(), (String)value);
        cookie.setPath("/");
        cookie.setValue((String)value);
        response.addCookie(cookie);
    }

    protected void setCookie(HttpServletRequest request, HttpServletResponse response, BaseCookieEnum key, Object value, int maxAge) {
        request.getSession().setAttribute(key.toString(), value);
        Cookie cookie = new Cookie(key.toString(), value.toString());
        cookie.setPath("/");
        cookie.setValue(value.toString());
        cookie.setMaxAge(maxAge);
        response.addCookie(cookie);
    }

    protected String getCookie(HttpServletRequest request, BaseCookieEnum key) {
        if (request.getCookies() != null) {
            for (Cookie c : request.getCookies()) {
                if (!c.getName().equals(key.toString())) continue;
                return c.getValue();
            }
        }
        return null;
    }

    protected void outJson(HttpServletResponse response, Object jsonDataStr) {
        try {
            response.setContentType("application/json;charset=utf-8");
            PrintWriter out = response.getWriter();
            out.print(jsonDataStr);
            out.flush();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected int getAppId(HttpServletRequest request) {
        return this.getApp(request).getAppId();
    }

    protected AppEntity getApp(HttpServletRequest request) {
        AppEntity app = new AppEntity();
        IAppBiz appBiz = (IAppBiz)this.getBean(request.getServletContext(), "appBiz");
        AppEntity website = appBiz.getByUrl(this.getDomain(request));
        if (website == null) {
            return null;
        }
        BeanUtils.copyProperties((Object)website, (Object)app);
        return app;
    }

    private String getDomain(HttpServletRequest request) {
        String path = request.getContextPath();
        String domain = request.getServerName();
        domain = request.getServerPort() == 80 ? domain + path : domain + ":" + request.getServerPort() + path;
        return domain;
    }

    protected String assemblyRequestUrlParams(HttpServletRequest request) {
        this.logger.debug((Object)("url:" + request.getRequestURI()));
        Map map = request.getParameterMap();
        Iterator key = map.keySet().iterator();
        StringBuffer sb = new StringBuffer();
        while (key.hasNext()) {
            String k = (String)key.next();
            String[] value = (String[])map.get(k);
            this.logger.debug((Object)(k + ":" + value[0]));
            if (value.length == 1) {
                String temp = null;
                if (!StringUtil.isBlank((String)value[0])) {
                    temp = value[0];
                }
                sb.append(k).append("=").append(temp).append("&");
                request.setAttribute(k.replace(".", ""), (Object)temp);
                continue;
            }
            if (value.length == 0) {
                request.setAttribute(k.replace(".", ""), null);
                continue;
            }
            if (value.length <= 1) continue;
            sb.append(k).append("=").append(value).append("&");
            request.setAttribute(k.replace(".", ""), (Object)value);
        }
        if (sb.length() > 0) {
            return sb.substring(0, sb.length() - 1);
        }
        return sb.toString();
    }

    static {
        if (System.getProperty("os.name").toLowerCase().indexOf("windows") > 0) {
            IS_WINDOWS = true;
        }
    }
}

