/*
 * Decompiled with CFR 0.152.
 */
package com.mingsoft.mdiy.action;

import com.alibaba.fastjson.serializer.SerializeFilter;
import com.mingsoft.base.entity.BaseEntity;
import com.mingsoft.base.filter.DateValueFilter;
import com.mingsoft.base.filter.DoubleValueFilter;
import com.mingsoft.mdiy.action.BaseAction;
import com.mingsoft.mdiy.biz.IPageBiz;
import com.mingsoft.mdiy.entity.PageEntity;
import com.mingsoft.util.StringUtil;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.mingsoft.base.util.JSONArray;
import net.mingsoft.base.util.JSONObject;
import net.mingsoft.basic.bean.EUListBean;
import net.mingsoft.basic.util.BasicUtil;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/${managerPath}/mdiy/page"})
public class PageAction
extends BaseAction {
    @Autowired
    private IPageBiz pageBiz;

    @RequestMapping(value={"/index"})
    public String index(HttpServletResponse response, HttpServletRequest request) {
        return this.view("/mdiy/page/index");
    }

    @RequestMapping(value={"/list"})
    @ResponseBody
    public void list(@ModelAttribute PageEntity page, HttpServletResponse response, HttpServletRequest request, ModelMap model) {
        page.setPageAppId(Integer.valueOf(BasicUtil.getAppId()));
        BasicUtil.startPage();
        List pageList = this.pageBiz.query((BaseEntity)page);
        this.outJson(response, (Object)JSONArray.toJSONString((Object)new EUListBean(pageList, (int)BasicUtil.endPage((List)pageList).getTotal()), (SerializeFilter[])new SerializeFilter[]{new DoubleValueFilter(), new DateValueFilter()}));
    }

    @RequestMapping(value={"/form"})
    public String form(@ModelAttribute PageEntity page, HttpServletResponse response, HttpServletRequest request, ModelMap model) {
        if (page.getPageId() != null) {
            BaseEntity pageEntity = this.pageBiz.getEntity(page.getPageId().intValue());
            model.addAttribute("pageEntity", (Object)pageEntity);
        }
        return this.view("/mdiy/page/form");
    }

    @RequestMapping(value={"/get"})
    @ResponseBody
    public void get(@ModelAttribute PageEntity page, HttpServletResponse response, HttpServletRequest request, ModelMap model) {
        if (page.getPageId() <= 0) {
            this.outJson(response, null, false, this.getResString("err.error", new String[]{this.getResString("page.id")}));
            return;
        }
        PageEntity _page = (PageEntity)this.pageBiz.getEntity(page.getPageId().intValue());
        this.outJson(response, (BaseEntity)_page);
    }

    @RequestMapping(value={"/save"})
    @ResponseBody
    @RequiresPermissions(value={"mdiy:page:save"})
    public void save(@ModelAttribute PageEntity page, HttpServletResponse response, HttpServletRequest request) {
        page.setPageAppId(Integer.valueOf(BasicUtil.getAppId()));
        if (StringUtil.isBlank((Object)page.getPageAppId())) {
            this.outJson(response, null, false, this.getResString("err.empty", new String[]{this.getResString("page.app.id")}));
            return;
        }
        if (!StringUtil.checkLength((String)(page.getPageAppId() + ""), (int)1, (int)10)) {
            this.outJson(response, null, false, this.getResString("err.length", new String[]{this.getResString("page.app.id"), "1", "10"}));
            return;
        }
        if (StringUtil.isBlank((String)page.getPagePath())) {
            this.outJson(response, null, false, this.getResString("err.empty", new String[]{this.getResString("page.path")}));
            return;
        }
        if (!StringUtil.checkLength((String)(page.getPagePath() + ""), (int)1, (int)255)) {
            this.outJson(response, null, false, this.getResString("err.length", new String[]{this.getResString("page.path"), "1", "255"}));
            return;
        }
        if (StringUtil.isBlank((String)page.getPageTitle())) {
            this.outJson(response, null, false, this.getResString("err.empty", new String[]{this.getResString("page.title")}));
            return;
        }
        if (!StringUtil.checkLength((String)(page.getPageTitle() + ""), (int)1, (int)255)) {
            this.outJson(response, null, false, this.getResString("err.length", new String[]{this.getResString("page.title"), "1", "255"}));
            return;
        }
        if (StringUtil.isBlank((String)page.getPageKey())) {
            this.outJson(response, null, false, this.getResString("err.empty", new String[]{this.getResString("page.key")}));
            return;
        }
        if (!StringUtil.checkLength((String)(page.getPageKey() + ""), (int)1, (int)255)) {
            this.outJson(response, null, false, this.getResString("err.length", new String[]{this.getResString("page.key"), "1", "255"}));
            return;
        }
        this.pageBiz.saveEntity((BaseEntity)page);
        this.outJson(response, (Object)JSONObject.toJSONString((Object)page));
    }

    @RequestMapping(value={"/delete"})
    @ResponseBody
    @RequiresPermissions(value={"mdiy:page:del"})
    public void delete(@RequestBody List<PageEntity> pages, HttpServletResponse response, HttpServletRequest request) {
        int[] ids = new int[pages.size()];
        for (int i = 0; i < pages.size(); ++i) {
            ids[i] = pages.get(i).getPageId();
        }
        this.pageBiz.delete(ids);
        this.outJson(response, true);
    }

    @RequestMapping(value={"/update"})
    @ResponseBody
    @RequiresPermissions(value={"mdiy:page:update"})
    public void update(@ModelAttribute PageEntity page, HttpServletResponse response, HttpServletRequest request) {
        if (StringUtil.isBlank((String)page.getPagePath())) {
            this.outJson(response, null, false, this.getResString("err.empty", new String[]{this.getResString("page.path")}));
            return;
        }
        if (!StringUtil.checkLength((String)(page.getPagePath() + ""), (int)1, (int)255)) {
            this.outJson(response, null, false, this.getResString("err.length", new String[]{this.getResString("page.path"), "1", "255"}));
            return;
        }
        if (StringUtil.isBlank((String)page.getPageTitle())) {
            this.outJson(response, null, false, this.getResString("err.empty", new String[]{this.getResString("page.title")}));
            return;
        }
        if (!StringUtil.checkLength((String)(page.getPageTitle() + ""), (int)1, (int)255)) {
            this.outJson(response, null, false, this.getResString("err.length", new String[]{this.getResString("page.title"), "1", "255"}));
            return;
        }
        if (StringUtil.isBlank((String)page.getPageKey())) {
            this.outJson(response, null, false, this.getResString("err.empty", new String[]{this.getResString("page.key")}));
            return;
        }
        if (!StringUtil.checkLength((String)(page.getPageKey() + ""), (int)1, (int)255)) {
            this.outJson(response, null, false, this.getResString("err.length", new String[]{this.getResString("page.key"), "1", "255"}));
            return;
        }
        this.pageBiz.updateEntity((BaseEntity)page);
        this.outJson(response, (Object)JSONObject.toJSONString((Object)page));
    }
}

