/*
 * Decompiled with CFR 0.152.
 */
package com.mingsoft.people.action.people;

import com.mingsoft.base.constant.e.BaseCookieEnum;
import com.mingsoft.base.constant.e.BaseEnum;
import com.mingsoft.base.entity.BaseEntity;
import com.mingsoft.basic.parser.IGeneralParser;
import com.mingsoft.people.action.BaseAction;
import com.mingsoft.people.biz.IPeopleBiz;
import com.mingsoft.people.constant.ModelCode;
import com.mingsoft.people.constant.e.CookieConstEnum;
import com.mingsoft.people.constant.e.PeopleEnum;
import com.mingsoft.people.entity.PeopleEntity;
import com.mingsoft.people.parser.PeopleParser;
import com.mingsoft.util.StringUtil;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller(value="webPeopleMain")
@RequestMapping(value={"/people"})
public class PeopleAction
extends BaseAction {
    @Autowired
    private IPeopleBiz peopleBiz;
    @Autowired
    private PeopleParser peopleParser;

    @RequestMapping(value={"/resetPassword"}, method={RequestMethod.POST})
    @ResponseBody
    public void resetPassword(@ModelAttribute PeopleEntity people, HttpServletRequest request, HttpServletResponse response) {
        if (!StringUtil.checkLength((String)people.getPeoplePassword(), (int)6, (int)30)) {
            this.outJson(response, (BaseEnum)ModelCode.PEOPLE, false, this.getResString("err.length", new String[]{this.getResString("people.password"), "6", "20"}));
            return;
        }
        if (StringUtil.isBlank((String)people.getPeoplePassword())) {
            this.outJson(response, (BaseEnum)ModelCode.PEOPLE, false, this.getResString("err.empty", new String[]{this.getResString("people.password")}));
            return;
        }
        PeopleEntity _people = (PeopleEntity)this.peopleBiz.getEntity(this.getPeopleBySession().getPeopleId());
        String peoplePassWord = StringUtil.Md5((String)people.getPeoplePassword(), (String)"utf-8");
        _people.setPeoplePassword(peoplePassWord);
        this.peopleBiz.updateEntity((BaseEntity)_people);
        this.outJson(response, (BaseEnum)ModelCode.PEOPLE, true);
    }

    @RequestMapping(value={"/changePassword"}, method={RequestMethod.POST})
    @ResponseBody
    public void changePassword(@ModelAttribute PeopleEntity people, HttpServletRequest request, HttpServletResponse response) {
        if (StringUtil.isBlank((String)people.getPeoplePassword())) {
            this.outJson(response, (BaseEnum)ModelCode.PEOPLE, false, this.getResString("err.empty", new String[]{this.getResString("people.password")}));
            return;
        }
        if (StringUtil.isBlank((String)people.getPeopleOldPassword())) {
            this.outJson(response, (BaseEnum)ModelCode.PEOPLE, false, this.getResString("err.empty", new String[]{this.getResString("people.old.password")}));
            return;
        }
        if (!StringUtil.checkLength((String)people.getPeoplePassword(), (int)6, (int)30)) {
            this.outJson(response, (BaseEnum)ModelCode.PEOPLE, false, this.getResString("err.length", new String[]{this.getResString("people.password"), "6", "20"}));
            return;
        }
        if (people.getPeoplePassword().contains(" ")) {
            this.outJson(response, (BaseEnum)ModelCode.PEOPLE, false, this.getResString("people.password") + this.getResString("people.space"));
            return;
        }
        PeopleEntity _people = this.getPeopleBySession(request);
        PeopleEntity curPeople = this.peopleBiz.getByPeople(_people, this.getAppId(request));
        if (!curPeople.getPeoplePassword().equals(StringUtil.Md5((String)people.getPeopleOldPassword()))) {
            this.outJson(response, (BaseEnum)ModelCode.PEOPLE, false, this.getResString("err.error", new String[]{this.getResString("people.password")}));
            return;
        }
        String peoplePassWord = StringUtil.Md5((String)people.getPeoplePassword(), (String)"utf-8");
        _people.setPeoplePassword(peoplePassWord);
        this.peopleBiz.updateEntity((BaseEntity)_people);
        this.outJson(response, (BaseEnum)ModelCode.PEOPLE, true);
    }

    @RequestMapping(value={"/changePhone"}, method={RequestMethod.POST})
    @ResponseBody
    public void changePhone(@ModelAttribute PeopleEntity people, HttpServletRequest request, HttpServletResponse response) {
        int appId = this.getAppId(request);
        PeopleEntity _people = this.getPeopleBySession(request);
        if (StringUtil.isBlank((String)people.getPeoplePhone())) {
            this.outJson(response, (BaseEnum)ModelCode.PEOPLE, false, this.getResString("err.empty", new String[]{this.getResString("people.phone")}));
            return;
        }
        if (_people.getPeoplePhoneCheck() == PeopleEnum.PHONE_CHECK.toInt()) {
            PeopleEntity tempPeople = this.peopleBiz.getByPeople(people, appId);
            if (!people.getPeopleCode().equals(tempPeople.getPeopleCode())) {
                this.outJson(response, (BaseEnum)ModelCode.PEOPLE_REGISTER, false, this.getResString("err.error", new String[]{this.getResString("people.code")}));
                return;
            }
        }
        people.setPeoplePhone(people.getPeoplePhone());
        this.peopleBiz.updateEntity((BaseEntity)people);
        this.outJson(response, (BaseEnum)ModelCode.PEOPLE, true);
    }

    @RequestMapping(value={"/checkPeopleCode"}, method={RequestMethod.POST})
    @ResponseBody
    public void checkPeopleCode(@ModelAttribute PeopleEntity people, HttpServletRequest request, HttpServletResponse response) {
        PeopleEntity _people = this.getPeopleBySession(request);
        PeopleEntity _temp = this.peopleBiz.getByPeople(_people, this.getAppId(request));
        if (people.getPeopleCode().equals(_temp.getPeopleCode())) {
            this.outJson(response, (BaseEnum)ModelCode.PEOPLE, true);
        } else {
            this.outJson(response, (BaseEnum)ModelCode.PEOPLE, false);
        }
    }

    @RequestMapping(value={"/info"})
    @ResponseBody
    public void info(HttpServletRequest request, HttpServletResponse response) {
        PeopleEntity people = this.getPeopleBySession(request);
        this.outJson(response, (Object)people, new String[]{"peopleOldPassword", "peoplePassword"});
    }

    @RequestMapping(value={"/quit"}, method={RequestMethod.POST})
    @ResponseBody
    public void quit(HttpServletRequest request, HttpServletResponse response) {
        this.removePeopleBySession(request);
        this.setCookie(request, response, (BaseCookieEnum)CookieConstEnum.PEOPLE_COOKIE, null);
        this.outJson(response, true);
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public void update(@ModelAttribute PeopleEntity people, HttpServletRequest request, HttpServletResponse response) {
        if (people == null) {
            this.outJson(response, (BaseEnum)ModelCode.PEOPLE, false, this.getResString("err.empty", new String[]{this.getResString("people")}));
            return;
        }
        PeopleEntity _people = (PeopleEntity)this.peopleBiz.getEntity(this.getPeopleBySession(request).getPeopleId());
        if (_people.getPeopleMailCheck() == PeopleEnum.MAIL_CHECK.toInt()) {
            people.setPeopleMail(null);
        }
        if (_people.getPeoplePhoneCheck() == PeopleEnum.PHONE_CHECK.toInt()) {
            people.setPeoplePhone(null);
        }
        people.setPeopleName(null);
        people.setPeopleId(this.getPeopleBySession(request).getPeopleId());
        this.peopleBiz.updateEntity((BaseEntity)people);
        this.outJson(response, (BaseEnum)ModelCode.PEOPLE, true, this.getResString("success"));
    }

    @RequestMapping(value={"/{diy}"})
    public void diy(@PathVariable(value="diy") String diy, HttpServletRequest req, HttpServletResponse resp) {
        String content = this.generaterPage("people/" + diy, (IGeneralParser)this.peopleParser, req);
        this.outString(resp, (Object)content);
    }
}

