/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.scheduled;

import java.lang.reflect.Method;
import java.util.Set;
import javax.inject.Inject;
import net.stickycode.reflector.MethodProcessor;
import net.stickycode.reflector.Reflector;
import net.stickycode.reflector.predicate.MethodPredicate;
import net.stickycode.reflector.predicate.PredicateReflector;
import net.stickycode.scheduled.ScheduledMethodInvokerFactory;
import net.stickycode.scheduled.ScheduledMethodProcessor;
import net.stickycode.stereotype.StickyComponent;
import net.stickycode.stereotype.StickyFramework;

@StickyComponent
@StickyFramework
public class ScheduledBeanProcessor {
    @Inject
    private Set<ScheduledMethodInvokerFactory> invokerFactories;
    @Inject
    private ScheduledMethodProcessor scheduledMethodProcessor;

    public boolean isSchedulable(Class<?> type) {
        return new PredicateReflector().given(type).areAnyMethods((MethodPredicate)new Invokable());
    }

    public void process(Object instance) {
        new Reflector().forEachMethod(new MethodProcessor[]{this.scheduledMethodProcessor}).process(instance);
    }

    private class Invokable
    implements MethodPredicate {
        private Invokable() {
        }

        public boolean apply(Method method) {
            for (ScheduledMethodInvokerFactory factory : ScheduledBeanProcessor.this.invokerFactories) {
                if (!factory.canInvoke(method)) continue;
                return true;
            }
            return false;
        }
    }
}

