/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.scheduled;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import net.stickycode.bootstrap.ComponentContainer;
import net.stickycode.coercion.CoercionFinder;
import net.stickycode.coercion.CoercionTarget;
import net.stickycode.configuration.ConfigurationTarget;
import net.stickycode.configuration.ResolvedConfiguration;
import net.stickycode.scheduled.MethodConfigurationTarget;
import net.stickycode.scheduled.Schedule;
import net.stickycode.scheduled.ScheduledRunnable;
import net.stickycode.scheduled.ThisShouldNeverHappenException;
import net.stickycode.stereotype.configured.Configured;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScheduledMethodInvoker
implements ScheduledRunnable {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Method method;
    private final Object target;
    private ConfigurationTarget name;
    @Configured
    private Schedule schedule;
    private ResolvedConfiguration resolution;

    public ScheduledMethodInvoker(Method method, Object target) {
        this.method = method;
        this.target = target;
        this.name = new MethodConfigurationTarget(method);
    }

    public void run() {
        try {
            this.log.debug("invoking {} using {}", (Object)this, (Object)this.schedule);
            this.method.invoke(this.target, new Object[0]);
        }
        catch (IllegalArgumentException e) {
            throw new ThisShouldNeverHappenException(e, "{}. Failed to invoke the scheduled method {} on class {}", e.getMessage(), this.toString(), this.target.getClass().getName());
        }
        catch (IllegalAccessException e) {
            this.log.error("Failed to execute {}, the schedule has stopped", (Object)this, (Object)e);
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            this.log.error("Failed to execute {}", (Object)this, (Object)e);
        }
    }

    public String toString() {
        return this.join(".").get(0);
    }

    public Schedule getSchedule() {
        return this.schedule;
    }

    public void applyCoercion(CoercionFinder coercions) {
    }

    public void update() {
    }

    public void invertControl(ComponentContainer container) {
        container.inject((Object)this);
    }

    public void resolvedWith(ResolvedConfiguration resolved) {
        this.resolution = resolved;
    }

    public ResolvedConfiguration getResolution() {
        return this.resolution;
    }

    public List<String> join(String delimeter) {
        return this.name.join(delimeter);
    }

    public Object getTarget() {
        return this.target;
    }

    public CoercionTarget getCoercionTarget() {
        return null;
    }

    public boolean requiresResolution() {
        return false;
    }
}

