/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.scheduled;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import net.stickycode.configured.ConfigurationAttribute;
import net.stickycode.configured.ConfigurationRepository;
import net.stickycode.reflector.MethodProcessor;
import net.stickycode.scheduled.FactoryNotRegisteredToProcessMethodException;
import net.stickycode.scheduled.ScheduledMethodInvokerFactory;
import net.stickycode.scheduled.ScheduledRunnable;
import net.stickycode.scheduled.ScheduledRunnableRepository;
import net.stickycode.stereotype.StickyComponent;
import net.stickycode.stereotype.StickyFramework;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@StickyComponent
@StickyFramework
public class ScheduledMethodProcessor
implements MethodProcessor {
    private Logger log = LoggerFactory.getLogger(ScheduledMethodProcessor.class);
    @Inject
    private ScheduledRunnableRepository schedulingSystem;
    @Inject
    private ConfigurationRepository repository;
    @Inject
    private Set<ScheduledMethodInvokerFactory> methodInvokerFactories;

    public void processMethod(Object target, Method method) {
        ScheduledRunnable scheduledMethodInvoker = this.createScheduledMethodInvoker(target, method);
        this.repository.register((ConfigurationAttribute)scheduledMethodInvoker);
        this.log.debug("Found {} to register for scheduling", (Object)scheduledMethodInvoker);
        this.schedulingSystem.schedule(scheduledMethodInvoker);
    }

    private ScheduledRunnable createScheduledMethodInvoker(Object target, Method method) {
        for (ScheduledMethodInvokerFactory factory : this.methodInvokerFactories) {
            if (!factory.canInvoke(method)) continue;
            return factory.create(target, method);
        }
        throw new FactoryNotRegisteredToProcessMethodException(target, method, this.methodInvokerFactories);
    }

    public boolean canProcess(Method method) {
        for (ScheduledMethodInvokerFactory factory : this.methodInvokerFactories) {
            if (!factory.canInvoke(method)) continue;
            return true;
        }
        return false;
    }

    public void sort(List<Method> methods) {
    }
}

