/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.scheduled.aligned;

import java.time.LocalTime;
import java.time.temporal.ChronoField;
import java.util.concurrent.TimeUnit;
import net.stickycode.scheduled.PeriodicSchedule;
import net.stickycode.scheduled.aligned.AlignmentCannotBeLessThanPeriodUnitsException;
import net.stickycode.scheduled.aligned.AlignmentMustBeLessThanPeriodException;
import net.stickycode.scheduled.aligned.AlignmentNotSupportedException;
import net.stickycode.scheduled.aligned.AlignmentOfLessThanOneIsMeaninglessException;

public class AlignedPeriodicSchedule
extends PeriodicSchedule {
    private final long alignment;
    private final TimeUnit alignmentUnit;

    public AlignedPeriodicSchedule(long alignment, TimeUnit alignmentUnit, long period, TimeUnit periodUnit) {
        super(period, periodUnit);
        if (alignment < 1L) {
            throw new AlignmentOfLessThanOneIsMeaninglessException(alignment);
        }
        if (alignmentUnit.compareTo(periodUnit) > 0) {
            throw new AlignmentCannotBeLessThanPeriodUnitsException(alignmentUnit, periodUnit);
        }
        if (alignment > alignmentUnit.convert(period, periodUnit)) {
            throw new AlignmentMustBeLessThanPeriodException(alignment, alignmentUnit, period, periodUnit);
        }
        this.alignment = alignment;
        this.alignmentUnit = alignmentUnit;
    }

    @Override
    public long getPeriod() {
        return this.alignmentUnit.convert(super.getPeriod(), super.getUnits());
    }

    @Override
    public TimeUnit getUnits() {
        return this.alignmentUnit;
    }

    @Override
    public long getInitialDelay() {
        if (this.alignment == 0L) {
            return 0L;
        }
        LocalTime time = LocalTime.now();
        switch (this.alignmentUnit) {
            case HOURS: {
                return this.calculateDelay(time.getHour(), this.alignment, 24L);
            }
            case MINUTES: {
                return this.calculateDelay(time.getMinute(), this.alignment, 60L);
            }
            case SECONDS: {
                return this.calculateDelay(time.getSecond(), this.alignment, 60L);
            }
            case MILLISECONDS: {
                return this.calculateDelay(time.getLong(ChronoField.MILLI_OF_SECOND), this.alignment, 1000L);
            }
        }
        throw new AlignmentNotSupportedException(this.alignmentUnit);
    }

    private long calculateDelay(long current, long offset, long max) {
        if (current < offset) {
            return offset - current;
        }
        return max - current + offset;
    }

    @Override
    public String toString() {
        String units = this.getUnits().toString().toLowerCase();
        return String.format("period %d %s starting in %d %s", this.getPeriod(), units, this.getInitialDelay(), this.alignmentUnit.toString().toLowerCase());
    }
}

