/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.scheduled.aligned;

import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.stickycode.scheduled.Schedule;
import net.stickycode.scheduled.aligned.AlignedPeriodicSchedule;
import net.stickycode.scheduled.aligned.AlignmentCannotBeLessThanPeriodUnitsException;
import net.stickycode.scheduled.configuration.AbstractScheduleParser;
import net.stickycode.scheduled.configuration.UnsupportedUnitForSchedulingException;
import net.stickycode.stereotype.StickyPlugin;

@StickyPlugin
public class AlignedPeriodicScheduleParser
extends AbstractScheduleParser {
    private Pattern alignedPeriodic = Pattern.compile("every ([0-9]+)? ?([a-zA-Z]+)(?: starting)? at ([0-9]+) ([a-zA-Z]+) past");

    public boolean matches(String specification) {
        return this.alignedPeriodic.matcher(specification).matches();
    }

    public Schedule parse(String specification) {
        Matcher match = this.alignedPeriodic.matcher(specification);
        if (!match.matches()) {
            throw new IllegalStateException("The schedule specification must match if matches was called");
        }
        long period = this.parseNumber(match.group(1));
        TimeUnit periodUnit = this.parseTimeUnit(match.group(2));
        if (TimeUnit.NANOSECONDS.equals((Object)periodUnit)) {
            throw new UnsupportedUnitForSchedulingException(periodUnit);
        }
        TimeUnit derivedAlignmentUnit = this.deriveAlignment(periodUnit);
        TimeUnit alignmentUnit = this.parseTimeUnit(match.group(4));
        if (alignmentUnit.compareTo(periodUnit) > 0) {
            throw new AlignmentCannotBeLessThanPeriodUnitsException(alignmentUnit, periodUnit);
        }
        long alignment = derivedAlignmentUnit.convert(Long.valueOf(match.group(3)), alignmentUnit);
        return new AlignedPeriodicSchedule(alignment, derivedAlignmentUnit, period, periodUnit);
    }

    TimeUnit deriveAlignment(TimeUnit periodUnit) {
        return TimeUnit.values()[periodUnit.ordinal() - 1];
    }
}

