/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.scheduled.configuration;

import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.stickycode.scheduled.PeriodicSchedule;
import net.stickycode.scheduled.Schedule;
import net.stickycode.scheduled.configuration.AbstractScheduleParser;
import net.stickycode.scheduled.configuration.UnsupportedUnitForSchedulingException;
import net.stickycode.stereotype.StickyPlugin;

@StickyPlugin
public class PeriodicScheduleParser
extends AbstractScheduleParser {
    private Pattern periodic = Pattern.compile("every ([0-9]+)? ?([a-zA-Z]+)$");

    public boolean matches(String specification) {
        return this.periodic.matcher(specification).matches();
    }

    public Schedule parse(String specification) {
        Matcher match = this.periodic.matcher(specification);
        if (!match.matches()) {
            throw new IllegalStateException("The schedule specification must match if matches was called");
        }
        long period = this.parseNumber(match.group(1));
        TimeUnit periodUnit = this.parseTimeUnit(match.group(2));
        if (TimeUnit.NANOSECONDS.equals((Object)periodUnit)) {
            throw new UnsupportedUnitForSchedulingException(periodUnit);
        }
        return new PeriodicSchedule(period, periodUnit);
    }
}

