/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.scheduled.configuration;

import java.util.Set;
import javax.inject.Inject;
import net.stickycode.coercion.AbstractNoDefaultCoercion;
import net.stickycode.coercion.CoercionTarget;
import net.stickycode.scheduled.Schedule;
import net.stickycode.scheduled.ScheduleParser;
import net.stickycode.scheduled.configuration.ScheduleDefintionIsNotValidException;
import net.stickycode.scheduled.configuration.ScheduleMustBeDefinedButTheValueWasBlankException;
import net.stickycode.stereotype.StickyPlugin;

@StickyPlugin
public class ScheduleCoercion
extends AbstractNoDefaultCoercion<Schedule> {
    @Inject
    private Set<ScheduleParser> parsers;

    public Schedule coerce(CoercionTarget type, String value) {
        if (value.length() == 0) {
            throw new ScheduleMustBeDefinedButTheValueWasBlankException(type);
        }
        for (ScheduleParser parser : this.parsers) {
            if (!parser.matches(value)) continue;
            return parser.parse(value);
        }
        throw new ScheduleDefintionIsNotValidException(value);
    }

    public boolean isApplicableTo(CoercionTarget type) {
        return Schedule.class.isAssignableFrom(type.getType());
    }
}

