/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.Iterator;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.AsyncProducerCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Expression;
import org.apache.camel.FailedToCreateProducerException;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.Traceable;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.impl.EmptyProducerCache;
import org.apache.camel.impl.ProducerCache;
import org.apache.camel.processor.DeadLetterChannel;
import org.apache.camel.processor.PipelineHelper;
import org.apache.camel.spi.EndpointUtilizationStatistics;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.AsyncProcessorHelper;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.MessageHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoutingSlip
extends ServiceSupport
implements AsyncProcessor,
Traceable,
IdAware {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected String id;
    protected ProducerCache producerCache;
    protected int cacheSize;
    protected boolean ignoreInvalidEndpoints;
    protected String header;
    protected Expression expression;
    protected String uriDelimiter;
    protected final CamelContext camelContext;

    public RoutingSlip(CamelContext camelContext) {
        ObjectHelper.notNull(camelContext, "camelContext");
        this.camelContext = camelContext;
    }

    public RoutingSlip(CamelContext camelContext, Expression expression, String uriDelimiter) {
        ObjectHelper.notNull(camelContext, "camelContext");
        ObjectHelper.notNull(expression, "expression");
        this.camelContext = camelContext;
        this.expression = expression;
        this.uriDelimiter = uriDelimiter;
        this.header = null;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public String getUriDelimiter() {
        return this.uriDelimiter;
    }

    public void setDelimiter(String delimiter) {
        this.uriDelimiter = delimiter;
    }

    public boolean isIgnoreInvalidEndpoints() {
        return this.ignoreInvalidEndpoints;
    }

    public void setIgnoreInvalidEndpoints(boolean ignoreInvalidEndpoints) {
        this.ignoreInvalidEndpoints = ignoreInvalidEndpoints;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
    }

    public String toString() {
        return "RoutingSlip[expression=" + this.expression + " uriDelimiter=" + this.uriDelimiter + "]";
    }

    @Override
    public String getTraceLabel() {
        return "routingSlip[" + this.expression + "]";
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        AsyncProcessorHelper.process(this, exchange);
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        if (!this.isStarted()) {
            exchange.setException(new IllegalStateException("RoutingSlip has not been started: " + this));
            callback.done(true);
            return true;
        }
        return this.doRoutingSlipWithExpression(exchange, this.expression, callback);
    }

    public boolean doRoutingSlip(Exchange exchange, Object routingSlip, AsyncCallback callback) {
        if (routingSlip instanceof Expression) {
            return this.doRoutingSlipWithExpression(exchange, (Expression)routingSlip, callback);
        }
        return this.doRoutingSlipWithExpression(exchange, ExpressionBuilder.constantExpression(routingSlip), callback);
    }

    protected RoutingSlipIterator createRoutingSlipIterator(Exchange exchange, Expression expression) throws Exception {
        Object slip = expression.evaluate(exchange, Object.class);
        if (exchange.getException() != null) {
            throw exchange.getException();
        }
        final Iterator<Object> delegate = ObjectHelper.createIterator(slip, this.uriDelimiter);
        return new RoutingSlipIterator(){

            @Override
            public boolean hasNext(Exchange exchange) {
                return delegate.hasNext();
            }

            @Override
            public Object next(Exchange exchange) {
                return delegate.next();
            }
        };
    }

    private boolean doRoutingSlipWithExpression(Exchange exchange, Expression expression, AsyncCallback originalCallback) {
        RoutingSlipIterator iter;
        Exchange current = exchange;
        try {
            iter = this.createRoutingSlipIterator(exchange, expression);
        }
        catch (Exception e) {
            exchange.setException(e);
            originalCallback.done(true);
            return true;
        }
        if (current.hasProperties()) {
            current.setProperty("CamelSlipEndpoint", null);
        }
        while (iter.hasNext(current)) {
            FailedToCreateProducerException e;
            Endpoint endpoint;
            try {
                endpoint = this.resolveEndpoint(iter, exchange);
                if (endpoint == null) {
                    continue;
                }
            }
            catch (Exception e2) {
                current.setException(e2);
                break;
            }
            boolean sync = this.processExchange(endpoint, current, exchange, originalCallback, iter);
            current = this.prepareExchangeForRoutingSlip(current, endpoint);
            if (!sync) {
                this.log.trace("Processing exchangeId: {} is continued being processed asynchronously", (Object)exchange.getExchangeId());
                return false;
            }
            this.log.trace("Processing exchangeId: {} is continued being processed synchronously", (Object)exchange.getExchangeId());
            if (this.isIgnoreInvalidEndpoints() && (e = current.getException(FailedToCreateProducerException.class)) != null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Endpoint uri is invalid: " + endpoint + ". This exception will be ignored.", e);
                }
                current.setException(null);
            }
            if (PipelineHelper.continueProcessing(current, "so breaking out of the routing slip", this.log)) continue;
            break;
        }
        this.log.trace("Processing complete for exchangeId: {} >>> {}", (Object)exchange.getExchangeId(), (Object)current);
        ExchangeHelper.copyResults(exchange, current);
        originalCallback.done(true);
        return true;
    }

    protected Endpoint resolveEndpoint(RoutingSlipIterator iter, Exchange exchange) throws Exception {
        Object nextRecipient = iter.next(exchange);
        Endpoint endpoint = null;
        try {
            endpoint = ExchangeHelper.resolveEndpoint(exchange, nextRecipient);
        }
        catch (Exception e) {
            if (this.isIgnoreInvalidEndpoints()) {
                this.log.info("Endpoint uri is invalid: " + nextRecipient + ". This exception will be ignored.", e);
            }
            throw e;
        }
        return endpoint;
    }

    protected Exchange prepareExchangeForRoutingSlip(Exchange current, Endpoint endpoint) {
        DefaultExchange copy = new DefaultExchange(current);
        copy.setExchangeId(current.getExchangeId());
        this.copyOutToIn(copy, current);
        MessageHelper.resetStreamCache(copy.getIn());
        return copy;
    }

    protected AsyncProcessor createErrorHandler(RouteContext routeContext, Exchange exchange, AsyncProcessor processor, Endpoint endpoint) {
        AsyncProcessor answer = processor;
        boolean tryBlock = exchange.getProperty("TryRouteBlock", false, Boolean.TYPE);
        if (!tryBlock && routeContext != null) {
            this.log.trace("Creating error handler for: {}", (Object)processor);
            ErrorHandlerFactory builder = routeContext.getRoute().getErrorHandlerBuilder();
            try {
                answer = (AsyncProcessor)builder.createErrorHandler(routeContext, processor);
                ServiceHelper.startServices(answer);
            }
            catch (Exception e) {
                throw ObjectHelper.wrapRuntimeCamelException(e);
            }
        }
        return answer;
    }

    protected boolean processExchange(final Endpoint endpoint, Exchange exchange, final Exchange original, final AsyncCallback originalCallback, final RoutingSlipIterator iter) {
        this.log.trace("Processing exchangeId: {} >>> {}", (Object)exchange.getExchangeId(), (Object)exchange);
        AsyncCallback callback = new AsyncCallback(){

            @Override
            public void done(boolean doneSync) {
                if (!doneSync) {
                    originalCallback.done(false);
                }
            }
        };
        boolean sync = this.producerCache.doInAsyncProducer(endpoint, exchange, null, callback, new AsyncProducerCallback(){

            @Override
            public boolean doInAsyncProducer(Producer producer, AsyncProcessor asyncProducer, final Exchange exchange, ExchangePattern exchangePattern, final AsyncCallback callback) {
                RouteContext routeContext = exchange.getUnitOfWork() != null ? exchange.getUnitOfWork().getRouteContext() : null;
                final AsyncProcessor target = RoutingSlip.this.createErrorHandler(routeContext, exchange, asyncProducer, endpoint);
                exchange.setProperty("CamelToEndpoint", endpoint.getEndpointUri());
                exchange.setProperty("CamelSlipEndpoint", endpoint.getEndpointUri());
                boolean answer = target.process(exchange, new AsyncCallback(){

                    @Override
                    public void done(boolean doneSync) {
                        if (doneSync) {
                            callback.done(true);
                            return;
                        }
                        try {
                            Exchange current = RoutingSlip.this.prepareExchangeForRoutingSlip(exchange, endpoint);
                            while (iter.hasNext(current)) {
                                Endpoint endpoint;
                                FailedToCreateProducerException e;
                                if (RoutingSlip.this.isIgnoreInvalidEndpoints() && (e = current.getException(FailedToCreateProducerException.class)) != null) {
                                    if (RoutingSlip.this.log.isDebugEnabled()) {
                                        RoutingSlip.this.log.debug("Endpoint uri is invalid: " + endpoint + ". This exception will be ignored.", e);
                                    }
                                    current.setException(null);
                                }
                                if (!PipelineHelper.continueProcessing(current, "so breaking out of the routing slip", RoutingSlip.this.log)) break;
                                try {
                                    endpoint = RoutingSlip.this.resolveEndpoint(iter, exchange);
                                    if (endpoint == null) {
                                        continue;
                                    }
                                }
                                catch (Exception e2) {
                                    exchange.setException(e2);
                                    break;
                                }
                                boolean sync = RoutingSlip.this.processExchange(endpoint, current, original, callback, iter);
                                current = RoutingSlip.this.prepareExchangeForRoutingSlip(current, endpoint);
                                if (sync) continue;
                                RoutingSlip.this.log.trace("Processing exchangeId: {} is continued being processed asynchronously", (Object)original.getExchangeId());
                                return;
                            }
                            RoutingSlip.this.log.trace("Processing complete for exchangeId: {} >>> {}", (Object)original.getExchangeId(), (Object)current);
                            ExchangeHelper.copyResults(original, current);
                            if (target instanceof DeadLetterChannel) {
                                Processor deadLetter = ((DeadLetterChannel)target).getDeadLetter();
                                try {
                                    ServiceHelper.stopService(deadLetter);
                                }
                                catch (Exception e) {
                                    RoutingSlip.this.log.warn("Error stopping DeadLetterChannel error handler on routing slip. This exception is ignored.", e);
                                }
                            }
                        }
                        catch (Throwable e) {
                            exchange.setException(e);
                        }
                        originalCallback.done(false);
                    }
                });
                if (answer && target instanceof DeadLetterChannel) {
                    Processor deadLetter = ((DeadLetterChannel)target).getDeadLetter();
                    try {
                        ServiceHelper.stopService(deadLetter);
                    }
                    catch (Exception e) {
                        RoutingSlip.this.log.warn("Error stopping DeadLetterChannel error handler on routing slip. This exception is ignored.", e);
                    }
                }
                return answer;
            }
        });
        return sync;
    }

    @Override
    protected void doStart() throws Exception {
        if (this.producerCache == null) {
            if (this.cacheSize < 0) {
                this.producerCache = new EmptyProducerCache(this, this.camelContext);
                this.log.debug("RoutingSlip {} is not using ProducerCache", (Object)this);
            } else if (this.cacheSize == 0) {
                this.producerCache = new ProducerCache(this, this.camelContext);
                this.log.debug("RoutingSlip {} using ProducerCache with default cache size", (Object)this);
            } else {
                this.producerCache = new ProducerCache((Object)this, this.camelContext, this.cacheSize);
                this.log.debug("RoutingSlip {} using ProducerCache with cacheSize={}", (Object)this, (Object)this.cacheSize);
            }
        }
        ServiceHelper.startService(this.producerCache);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopServices(this.producerCache);
    }

    @Override
    protected void doShutdown() throws Exception {
        ServiceHelper.stopAndShutdownServices(this.producerCache);
    }

    public EndpointUtilizationStatistics getEndpointUtilizationStatistics() {
        return this.producerCache.getEndpointUtilizationStatistics();
    }

    private Message getResultMessage(Exchange exchange) {
        if (exchange.hasOut()) {
            return exchange.getOut();
        }
        return exchange.getIn();
    }

    private void copyOutToIn(Exchange result, Exchange source) {
        result.setException(source.getException());
        result.setIn(this.getResultMessage(source));
        result.getProperties().clear();
        result.getProperties().putAll(source.getProperties());
    }

    protected static interface RoutingSlipIterator {
        public boolean hasNext(Exchange var1);

        public Object next(Exchange var1);
    }
}

