/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQExceptionType;
import org.apache.activemq.artemis.logs.ActiveMQUtilBundle;
import org.apache.activemq.artemis.utils.DefaultSensitiveStringCodec;
import org.apache.activemq.artemis.utils.HashProcessor;
import org.apache.activemq.artemis.utils.NoHashProcessor;
import org.apache.activemq.artemis.utils.SecureHashProcessor;
import org.apache.activemq.artemis.utils.SensitiveDataCodec;

public class PasswordMaskingUtil {
    private static final String PLAINTEXT_PROCESSOR = "plaintext";
    private static final String SECURE_PROCESSOR = "secure";
    private static final Map<String, HashProcessor> processors = new HashMap<String, HashProcessor>();

    public static HashProcessor getHashProcessor(String storedPassword) throws Exception {
        if (!PasswordMaskingUtil.isEncoded(storedPassword)) {
            return PasswordMaskingUtil.getPlaintextProcessor();
        }
        return PasswordMaskingUtil.getSecureProcessor();
    }

    private static boolean isEncoded(String storedPassword) {
        if (storedPassword == null) {
            return true;
        }
        return storedPassword.startsWith("ENC(") && storedPassword.endsWith(")");
    }

    public static HashProcessor getHashProcessor() {
        HashProcessor processor = null;
        try {
            processor = PasswordMaskingUtil.getSecureProcessor();
        }
        catch (Exception e) {
            processor = PasswordMaskingUtil.getPlaintextProcessor();
        }
        return processor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashProcessor getPlaintextProcessor() {
        Map<String, HashProcessor> map = processors;
        synchronized (map) {
            HashProcessor plain = processors.get(PLAINTEXT_PROCESSOR);
            if (plain == null) {
                plain = new NoHashProcessor();
                processors.put(PLAINTEXT_PROCESSOR, plain);
            }
            return plain;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashProcessor getSecureProcessor() throws Exception {
        Map<String, HashProcessor> map = processors;
        synchronized (map) {
            HashProcessor processor = processors.get(SECURE_PROCESSOR);
            if (processor == null) {
                DefaultSensitiveStringCodec codec = (DefaultSensitiveStringCodec)PasswordMaskingUtil.getCodec("org.apache.activemq.artemis.utils.DefaultSensitiveStringCodec;algorithm=one-way");
                processor = new SecureHashProcessor(codec);
                processors.put(SECURE_PROCESSOR, processor);
            }
            return processor;
        }
    }

    public static SensitiveDataCodec<String> getCodec(String codecDesc) throws ActiveMQException {
        String[] parts = codecDesc.split(";");
        if (parts.length < 1) {
            throw new ActiveMQException(ActiveMQExceptionType.ILLEGAL_STATE, "Invalid PasswordCodec value: " + codecDesc);
        }
        final String codecClassName = parts[0];
        SensitiveDataCodec<String> codecInstance = AccessController.doPrivileged(new PrivilegedAction<SensitiveDataCodec<String>>(){

            @Override
            public SensitiveDataCodec<String> run() {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                try {
                    Class<?> clazz = loader.loadClass(codecClassName);
                    return (SensitiveDataCodec)clazz.newInstance();
                }
                catch (Exception e) {
                    throw ActiveMQUtilBundle.BUNDLE.errorCreatingCodec(e, codecClassName);
                }
            }
        });
        if (parts.length > 1) {
            HashMap<String, String> props = new HashMap<String, String>();
            for (int i = 1; i < parts.length; ++i) {
                String[] keyVal = parts[i].split("=");
                if (keyVal.length != 2) {
                    throw ActiveMQUtilBundle.BUNDLE.invalidProperty(parts[i]);
                }
                props.put(keyVal[0], keyVal[1]);
            }
            try {
                codecInstance.init(props);
            }
            catch (Exception e) {
                throw new ActiveMQException("Fail to init codec", e, ActiveMQExceptionType.SECURITY_EXCEPTION);
            }
        }
        return codecInstance;
    }

    public static DefaultSensitiveStringCodec getDefaultCodec() {
        return new DefaultSensitiveStringCodec();
    }
}

