/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jdbc.store.drivers;

import org.apache.activemq.artemis.jdbc.store.drivers.derby.DerbySQLProvider;
import org.apache.activemq.artemis.jdbc.store.drivers.mysql.MySQLSQLProvider;
import org.apache.activemq.artemis.jdbc.store.drivers.postgres.PostgresSQLProvider;
import org.apache.activemq.artemis.jdbc.store.sql.GenericSQLProvider;
import org.apache.activemq.artemis.jdbc.store.sql.SQLProvider;
import org.jboss.logging.Logger;

public class JDBCUtils {
    private static final Logger logger = Logger.getLogger(JDBCUtils.class);

    public static SQLProvider.Factory getSQLProviderFactory(String url) {
        SQLProvider.Factory factory;
        if (url.contains("derby")) {
            logger.tracef("getSQLProvider Returning Derby SQL provider for url::%s", (Object)url);
            factory = new DerbySQLProvider.Factory();
        } else if (url.contains("postgres")) {
            logger.tracef("getSQLProvider Returning postgres SQL provider for url::%s", (Object)url);
            factory = new PostgresSQLProvider.Factory();
        } else if (url.contains("mysql")) {
            logger.tracef("getSQLProvider Returning mysql SQL provider for url::%s", (Object)url);
            factory = new MySQLSQLProvider.Factory();
        } else {
            logger.tracef("getSQLProvider Returning generic SQL provider for url::%s", (Object)url);
            factory = new GenericSQLProvider.Factory();
        }
        return factory;
    }

    public static SQLProvider getSQLProvider(String driverClass, String tableName) {
        SQLProvider.Factory factory;
        if (driverClass.contains("derby")) {
            logger.tracef("getSQLProvider Returning Derby SQL provider for driver::%s, tableName::%s", (Object)driverClass, (Object)tableName);
            factory = new DerbySQLProvider.Factory();
        } else if (driverClass.contains("postgres")) {
            logger.tracef("getSQLProvider Returning postgres SQL provider for driver::%s, tableName::%s", (Object)driverClass, (Object)tableName);
            factory = new PostgresSQLProvider.Factory();
        } else if (driverClass.contains("mysql")) {
            logger.tracef("getSQLProvider Returning mysql SQL provider for driver::%s, tableName::%s", (Object)driverClass, (Object)tableName);
            factory = new MySQLSQLProvider.Factory();
        } else {
            logger.tracef("getSQLProvider Returning generic SQL provider for driver::%s, tableName::%s", (Object)driverClass, (Object)tableName);
            factory = new GenericSQLProvider.Factory();
        }
        return factory.create(tableName);
    }
}

