/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.filter.Filter;
import org.apache.activemq.artemis.core.paging.cursor.PageSubscription;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.postoffice.PostOffice;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.ServerMessage;
import org.apache.activemq.artemis.core.server.impl.AckReason;
import org.apache.activemq.artemis.core.server.impl.QueueImpl;
import org.apache.activemq.artemis.core.settings.HierarchicalRepository;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.core.transaction.Transaction;

public class LastValueQueue
extends QueueImpl {
    private final Map<SimpleString, HolderReference> map = new ConcurrentHashMap<SimpleString, HolderReference>();

    public LastValueQueue(long persistenceID, SimpleString address, SimpleString name, Filter filter, PageSubscription pageSubscription, SimpleString user, boolean durable, boolean temporary, boolean autoCreated, ScheduledExecutorService scheduledExecutor, PostOffice postOffice, StorageManager storageManager, HierarchicalRepository<AddressSettings> addressSettingsRepository, Executor executor) {
        super(persistenceID, address, name, filter, pageSubscription, user, durable, temporary, autoCreated, scheduledExecutor, postOffice, storageManager, addressSettingsRepository, executor);
        new Exception("LastValueQeue " + this).toString();
    }

    @Override
    public synchronized void addTail(MessageReference ref, boolean direct) {
        if (this.scheduleIfPossible(ref)) {
            return;
        }
        SimpleString prop = ref.getMessage().getSimpleStringProperty(Message.HDR_LAST_VALUE_NAME);
        if (prop != null) {
            HolderReference hr = this.map.get(prop);
            if (hr != null) {
                this.replaceLVQMessage(ref, hr);
            } else {
                hr = new HolderReference(prop, ref);
                this.map.put(prop, hr);
                super.addTail(hr, direct);
            }
        } else {
            super.addTail(ref, direct);
        }
    }

    @Override
    public synchronized void addHead(MessageReference ref, boolean scheduling) {
        SimpleString prop = ref.getMessage().getSimpleStringProperty(Message.HDR_LAST_VALUE_NAME);
        if (prop != null) {
            HolderReference hr = this.map.get(prop);
            if (hr != null) {
                if (scheduling) {
                    this.replaceLVQMessage(ref, hr);
                } else {
                    super.referenceHandled();
                    try {
                        super.acknowledge(ref);
                    }
                    catch (Exception e) {
                        ActiveMQServerLogger.LOGGER.errorAckingOldReference(e);
                    }
                }
            } else {
                hr = new HolderReference(prop, ref);
                this.map.put(prop, hr);
                super.addHead(hr, scheduling);
            }
        } else {
            super.addHead(ref, scheduling);
        }
    }

    private void replaceLVQMessage(MessageReference ref, HolderReference hr) {
        MessageReference oldRef = hr.getReference();
        this.referenceHandled();
        try {
            oldRef.acknowledge();
        }
        catch (Exception e) {
            ActiveMQServerLogger.LOGGER.errorAckingOldReference(e);
        }
        hr.setReference(ref);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void refRemoved(MessageReference ref) {
        LastValueQueue lastValueQueue = this;
        synchronized (lastValueQueue) {
            SimpleString prop = ref.getMessage().getSimpleStringProperty(Message.HDR_LAST_VALUE_NAME);
            if (prop != null) {
                this.map.remove(prop);
            }
        }
        super.refRemoved(ref);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.map == null ? 0 : this.map.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof LastValueQueue)) {
            return false;
        }
        LastValueQueue other = (LastValueQueue)obj;
        return !(this.map == null ? other.map != null : !this.map.equals(other.map));
    }

    private class HolderReference
    implements MessageReference {
        private final SimpleString prop;
        private volatile MessageReference ref;
        private Long consumerId;

        HolderReference(SimpleString prop, MessageReference ref) {
            this.prop = prop;
            this.ref = ref;
        }

        MessageReference getReference() {
            return this.ref;
        }

        @Override
        public void handled() {
            this.ref.handled();
            LastValueQueue.this.map.remove(this.prop);
        }

        @Override
        public Object getProtocolData() {
            return this.ref.getProtocolData();
        }

        @Override
        public void setProtocolData(Object data) {
            this.ref.setProtocolData(data);
        }

        @Override
        public void setAlreadyAcked() {
            this.ref.setAlreadyAcked();
        }

        @Override
        public boolean isAlreadyAcked() {
            return this.ref.isAlreadyAcked();
        }

        void setReference(MessageReference ref) {
            this.ref = ref;
        }

        @Override
        public MessageReference copy(Queue queue) {
            return this.ref.copy(queue);
        }

        @Override
        public void decrementDeliveryCount() {
            this.ref.decrementDeliveryCount();
        }

        @Override
        public int getDeliveryCount() {
            return this.ref.getDeliveryCount();
        }

        @Override
        public ServerMessage getMessage() {
            return this.ref.getMessage();
        }

        @Override
        public Queue getQueue() {
            return this.ref.getQueue();
        }

        @Override
        public long getScheduledDeliveryTime() {
            return this.ref.getScheduledDeliveryTime();
        }

        @Override
        public void incrementDeliveryCount() {
            this.ref.incrementDeliveryCount();
        }

        @Override
        public void setDeliveryCount(int deliveryCount) {
            this.ref.setDeliveryCount(deliveryCount);
        }

        @Override
        public void setScheduledDeliveryTime(long scheduledDeliveryTime) {
            this.ref.setScheduledDeliveryTime(scheduledDeliveryTime);
        }

        @Override
        public void acknowledge(Transaction tx) throws Exception {
            this.ref.acknowledge(tx);
        }

        @Override
        public void acknowledge(Transaction tx, AckReason reason) throws Exception {
            this.ref.acknowledge(tx, reason);
        }

        @Override
        public void setPersistedCount(int count) {
            this.ref.setPersistedCount(count);
        }

        @Override
        public int getPersistedCount() {
            return this.ref.getPersistedCount();
        }

        @Override
        public boolean isPaged() {
            return false;
        }

        @Override
        public void acknowledge() throws Exception {
            this.ref.getQueue().acknowledge(this);
        }

        @Override
        public int getMessageMemoryEstimate() {
            return this.ref.getMessage().getMemoryEstimate();
        }

        @Override
        public void setConsumerId(Long consumerID) {
            this.consumerId = consumerID;
        }

        @Override
        public Long getConsumerId() {
            return this.consumerId;
        }
    }
}

