/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.hadoop.io;

import java.io.IOException;
import java.io.InputStream;
import org.apache.avro.Schema;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.mapred.AvroWrapper;
import org.apache.avro.reflect.ReflectDatumReader;
import org.apache.hadoop.io.serializer.Deserializer;

public abstract class AvroDeserializer<T extends AvroWrapper<D>, D>
implements Deserializer<T> {
    private final Schema mWriterSchema;
    private final Schema mReaderSchema;
    private final DatumReader<D> mAvroDatumReader;
    private BinaryDecoder mAvroDecoder;

    protected AvroDeserializer(Schema writerSchema, Schema readerSchema) {
        this.mWriterSchema = writerSchema;
        this.mReaderSchema = null != readerSchema ? readerSchema : writerSchema;
        this.mAvroDatumReader = new ReflectDatumReader(this.mWriterSchema, this.mReaderSchema);
    }

    public Schema getWriterSchema() {
        return this.mWriterSchema;
    }

    public Schema getReaderSchema() {
        return this.mReaderSchema;
    }

    public void open(InputStream inputStream) throws IOException {
        this.mAvroDecoder = DecoderFactory.get().directBinaryDecoder(inputStream, this.mAvroDecoder);
    }

    public T deserialize(T avroWrapperToReuse) throws IOException {
        if (null == avroWrapperToReuse) {
            avroWrapperToReuse = this.createAvroWrapper();
        }
        ((AvroWrapper)avroWrapperToReuse).datum((Object)this.mAvroDatumReader.read(((AvroWrapper)avroWrapperToReuse).datum(), (Decoder)this.mAvroDecoder));
        return (T)avroWrapperToReuse;
    }

    public void close() throws IOException {
        this.mAvroDecoder.inputStream().close();
    }

    protected abstract T createAvroWrapper();
}

