/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.ipc.trace;

import java.io.IOException;
import java.net.URL;
import java.util.List;
import org.apache.avro.AvroRemoteException;
import org.apache.avro.Protocol;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.ipc.HttpServer;
import org.apache.avro.ipc.HttpTransceiver;
import org.apache.avro.ipc.RPCPlugin;
import org.apache.avro.ipc.Responder;
import org.apache.avro.ipc.generic.GenericRequestor;
import org.apache.avro.ipc.generic.GenericResponder;
import org.apache.avro.ipc.trace.ID;
import org.apache.avro.ipc.trace.Span;
import org.apache.avro.ipc.trace.TracePlugin;
import org.apache.avro.ipc.trace.TracePluginConfiguration;
import org.apache.avro.ipc.trace.Util;
import org.junit.Assert;
import org.junit.Test;

public class TestBasicTracing {
    Protocol protocol = Protocol.parse("{\"protocol\": \"Minimal\", \"messages\": { \"m\": {   \"request\": [{\"name\": \"x\", \"type\": \"int\"}],    \"response\": \"int\"} } }");
    Protocol.Message message = this.protocol.getMessages().get("m");
    static Protocol advancedProtocol = Protocol.parse("{\"protocol\": \"Advanced\", \"messages\": { \"w\": { \"request\": [{\"name\": \"req\", \"type\": \"int\"}],    \"response\": \"int\"},\"x\": { \"request\": [{\"name\": \"req\", \"type\": \"int\"}],    \"response\": \"int\"},\"y\": { \"request\": [{\"name\": \"req\", \"type\": \"int\"}],    \"response\": \"int\"} } }");

    @Test
    public void testBasicTrace() throws Exception {
        TracePluginConfiguration conf = new TracePluginConfiguration();
        conf.storageType = TracePlugin.StorageType.MEMORY;
        conf.port = 51007;
        conf.clientPort = 12344;
        conf.traceProb = 1.0;
        TracePlugin responderPlugin = new TracePlugin(conf);
        conf.port = 51008;
        conf.clientPort = 12345;
        TracePlugin requestorPlugin = new TracePlugin(conf);
        TestResponder res = new TestResponder(this.protocol);
        res.addRPCPlugin(responderPlugin);
        HttpServer server = new HttpServer((Responder)res, 50000);
        server.start();
        HttpTransceiver trans = new HttpTransceiver(new URL("http://localhost:50000"));
        GenericRequestor r = new GenericRequestor(this.protocol, trans);
        r.addRPCPlugin(requestorPlugin);
        GenericData.Record params = new GenericData.Record(this.protocol.getMessages().get("m").getRequest());
        params.put("x", (Object)0);
        r.request("m", params);
        List<Span> responderSpans = responderPlugin.storage.getAllSpans();
        Assert.assertEquals((long)1L, (long)responderSpans.size());
        List<Span> requestorSpans = requestorPlugin.storage.getAllSpans();
        Assert.assertEquals((long)1L, (long)requestorSpans.size());
        if (responderSpans.size() == 1 && requestorSpans.size() == 1) {
            Span responderSpan = responderSpans.get(0);
            Span requestorSpan = requestorSpans.get(0);
            Assert.assertEquals(null, (Object)requestorSpan.getParentSpanID());
            Assert.assertEquals((Object)responderSpan.getParentSpanID(), (Object)requestorSpan.getParentSpanID());
            Assert.assertEquals((Object)responderSpan.getTraceID(), (Object)requestorSpan.getTraceID());
            Assert.assertEquals((long)2L, (long)requestorSpan.getEvents().size());
            Assert.assertEquals((long)2L, (long)responderSpan.getEvents().size());
            Assert.assertTrue((boolean)"m".equals(requestorSpan.getMessageName().toString()));
            Assert.assertTrue((boolean)"m".equals(responderSpan.getMessageName().toString()));
            Assert.assertFalse((boolean)requestorSpan.getComplete());
            Assert.assertFalse((boolean)responderSpan.getComplete());
        }
        server.close();
        requestorPlugin.clientFacingServer.stop();
        requestorPlugin.httpServer.close();
        responderPlugin.clientFacingServer.stop();
        responderPlugin.httpServer.close();
    }

    @Test
    public void testRecursingTrace() throws Exception {
        TracePluginConfiguration conf = new TracePluginConfiguration();
        conf.storageType = TracePlugin.StorageType.MEMORY;
        conf.traceProb = 1.0;
        conf.port = 51010;
        conf.clientPort = 12346;
        TracePlugin aPlugin = new TracePlugin(conf);
        conf.port = 51011;
        conf.clientPort = 12347;
        TracePlugin bPlugin = new TracePlugin(conf);
        conf.port = 51012;
        conf.clientPort = 12348;
        TracePlugin cPlugin = new TracePlugin(conf);
        conf.port = 51013;
        conf.clientPort = 12349;
        TracePlugin dPlugin = new TracePlugin(conf);
        RecursingResponder bRes = new RecursingResponder(advancedProtocol, bPlugin);
        bRes.addRPCPlugin(bPlugin);
        HttpServer server1 = new HttpServer((Responder)bRes, 21005);
        server1.start();
        EndpointResponder cRes = new EndpointResponder(advancedProtocol);
        cRes.addRPCPlugin(cPlugin);
        HttpServer server2 = new HttpServer((Responder)cRes, 21006);
        server2.start();
        EndpointResponder dRes = new EndpointResponder(advancedProtocol);
        dRes.addRPCPlugin(dPlugin);
        HttpServer server3 = new HttpServer((Responder)dRes, 21007);
        server3.start();
        HttpTransceiver trans = new HttpTransceiver(new URL("http://localhost:21005"));
        GenericRequestor r = new GenericRequestor(advancedProtocol, trans);
        r.addRPCPlugin(aPlugin);
        GenericData.Record params = new GenericData.Record(advancedProtocol.getMessages().get("w").getRequest());
        params.put("req", (Object)1);
        r.request("w", params);
        Assert.assertEquals((long)1L, (long)aPlugin.storage.getAllSpans().size());
        Assert.assertEquals((long)3L, (long)bPlugin.storage.getAllSpans().size());
        Assert.assertEquals((long)1L, (long)cPlugin.storage.getAllSpans().size());
        Assert.assertEquals((long)1L, (long)dPlugin.storage.getAllSpans().size());
        ID traceID = aPlugin.storage.getAllSpans().get(0).getTraceID();
        ID rootSpanID = null;
        for (Span s : aPlugin.storage.getAllSpans()) {
            Assert.assertEquals((long)2L, (long)s.getEvents().size());
            Assert.assertTrue((boolean)Util.idsEqual(traceID, s.getTraceID()));
            Assert.assertFalse((boolean)s.getComplete());
            rootSpanID = s.getSpanID();
        }
        for (Span s : bPlugin.storage.getAllSpans()) {
            Assert.assertEquals((long)2L, (long)s.getEvents().size());
            Assert.assertEquals((Object)traceID, (Object)s.getTraceID());
            Assert.assertFalse((boolean)s.getComplete());
        }
        for (Span s : cPlugin.storage.getAllSpans()) {
            Assert.assertEquals((long)2L, (long)s.getEvents().size());
            Assert.assertEquals((Object)traceID, (Object)s.getTraceID());
            Assert.assertFalse((boolean)s.getComplete());
        }
        for (Span s : dPlugin.storage.getAllSpans()) {
            Assert.assertEquals((long)2L, (long)s.getEvents().size());
            Assert.assertEquals((Object)traceID, (Object)s.getTraceID());
            Assert.assertFalse((boolean)s.getComplete());
        }
        ID firstSpanID = aPlugin.storage.getAllSpans().get(0).getSpanID();
        ID secondSpanID = cPlugin.storage.getAllSpans().get(0).getSpanID();
        ID thirdSpanID = dPlugin.storage.getAllSpans().get(0).getSpanID();
        boolean firstFound = false;
        boolean secondFound = false;
        boolean thirdFound = false;
        for (Span s : bPlugin.storage.getAllSpans()) {
            if (Util.idsEqual(s.getSpanID(), firstSpanID)) {
                firstFound = true;
                continue;
            }
            if (Util.idsEqual(s.getSpanID(), secondSpanID)) {
                secondFound = true;
                continue;
            }
            if (!Util.idsEqual(s.getSpanID(), thirdSpanID)) continue;
            thirdFound = true;
        }
        Assert.assertTrue((boolean)firstFound);
        Assert.assertTrue((boolean)secondFound);
        Assert.assertTrue((boolean)thirdFound);
        server1.close();
        server2.close();
        server3.close();
        aPlugin.httpServer.close();
        aPlugin.clientFacingServer.stop();
        bPlugin.httpServer.close();
        bPlugin.clientFacingServer.stop();
        cPlugin.httpServer.close();
        cPlugin.clientFacingServer.stop();
        dPlugin.httpServer.close();
        dPlugin.clientFacingServer.stop();
    }

    public static void main(String[] args) throws Exception {
        TracePluginConfiguration conf = new TracePluginConfiguration();
        conf.storageType = TracePlugin.StorageType.MEMORY;
        conf.traceProb = 1.0;
        conf.port = 51010;
        conf.clientPort = 12346;
        TracePlugin aPlugin = new TracePlugin(conf);
        conf.port = 51011;
        conf.clientPort = 12347;
        TracePlugin bPlugin = new TracePlugin(conf);
        conf.port = 51012;
        conf.clientPort = 12348;
        TracePlugin cPlugin = new TracePlugin(conf);
        conf.port = 51013;
        conf.clientPort = 12349;
        TracePlugin dPlugin = new TracePlugin(conf);
        conf.port = 51014;
        conf.clientPort = 12350;
        TracePlugin ePlugin = new TracePlugin(conf);
        conf.port = 51015;
        conf.clientPort = 12351;
        TracePlugin fPlugin = new TracePlugin(conf);
        RecursingResponder bRes = new RecursingResponder(advancedProtocol, bPlugin);
        bRes.addRPCPlugin(bPlugin);
        HttpServer server1 = new HttpServer((Responder)bRes, 21005);
        server1.start();
        EndpointResponder cRes = new EndpointResponder(advancedProtocol);
        cRes.addRPCPlugin(cPlugin);
        HttpServer server2 = new HttpServer((Responder)cRes, 21006);
        server2.start();
        EndpointResponder dRes = new EndpointResponder(advancedProtocol);
        dRes.addRPCPlugin(dPlugin);
        HttpServer server3 = new HttpServer((Responder)dRes, 21007);
        server3.start();
        HttpTransceiver trans1 = new HttpTransceiver(new URL("http://localhost:21005"));
        HttpTransceiver trans2 = new HttpTransceiver(new URL("http://localhost:21007"));
        GenericRequestor r1 = new GenericRequestor(advancedProtocol, trans1);
        r1.addRPCPlugin(aPlugin);
        GenericRequestor r2 = new GenericRequestor(advancedProtocol, trans2);
        r2.addRPCPlugin(fPlugin);
        GenericData.Record params = new GenericData.Record(advancedProtocol.getMessages().get("w").getRequest());
        params.put("req", (Object)1);
        while (true) {
            r1.request("w", params);
            r2.request("x", params);
            Thread.sleep(100L);
        }
    }

    private static class SleepyResponder
    extends GenericResponder {
        public SleepyResponder(Protocol local) {
            super(local);
        }

        @Override
        public Object respond(Protocol.Message message, Object request) throws AvroRemoteException {
            try {
                Thread.sleep((Long)((GenericRecord)request).get("millis"));
            }
            catch (InterruptedException e) {
                throw new AvroRemoteException(e);
            }
            return null;
        }
    }

    static class EndpointResponder
    extends GenericResponder {
        public EndpointResponder(Protocol local) {
            super(local);
        }

        @Override
        public Object respond(Protocol.Message message, Object request) throws AvroRemoteException {
            GenericRecord inParams = (GenericRecord)request;
            Integer currentCount = (Integer)inParams.get("req");
            return currentCount + 1;
        }
    }

    static class NonRecursingResponder
    extends GenericResponder {
        public NonRecursingResponder(Protocol local) throws Exception {
            super(local);
        }

        @Override
        public Object respond(Protocol.Message message, Object request) throws IOException {
            Assert.assertTrue((boolean)"w".equals(message.getName()));
            return 6;
        }
    }

    static class RecursingResponder
    extends GenericResponder {
        HttpTransceiver transC = new HttpTransceiver(new URL("http://localhost:21006"));
        HttpTransceiver transD = new HttpTransceiver(new URL("http://localhost:21007"));
        GenericRequestor reqC;
        GenericRequestor reqD;
        Protocol protocol;

        public RecursingResponder(Protocol local, RPCPlugin plugin) throws Exception {
            super(local);
            this.reqC = new GenericRequestor(local, this.transC);
            this.reqC.addRPCPlugin(plugin);
            this.reqD = new GenericRequestor(local, this.transD);
            this.reqD.addRPCPlugin(plugin);
            this.protocol = local;
        }

        @Override
        public Object respond(Protocol.Message message, Object request) throws IOException {
            Assert.assertTrue((boolean)"w".equals(message.getName()));
            GenericRecord inParams = (GenericRecord)request;
            Integer currentCount = (Integer)inParams.get("req");
            Assert.assertTrue((boolean)currentCount.equals(1));
            GenericData.Record paramsC = new GenericData.Record(this.protocol.getMessages().get("x").getRequest());
            paramsC.put("req", (Object)(currentCount + 1));
            Integer returnC = (Integer)this.reqC.request("x", paramsC);
            Assert.assertTrue((boolean)returnC.equals(currentCount + 2));
            GenericData.Record paramsD = new GenericData.Record(this.protocol.getMessages().get("x").getRequest());
            paramsD.put("req", (Object)(currentCount + 3));
            Integer returnD = (Integer)this.reqD.request("x", paramsD);
            Assert.assertTrue((boolean)returnD.equals(currentCount + 4));
            return currentCount + 5;
        }
    }

    static class TestResponder
    extends GenericResponder {
        public TestResponder(Protocol local) {
            super(local);
        }

        @Override
        public Object respond(Protocol.Message message, Object request) throws AvroRemoteException {
            Assert.assertEquals((Object)0, (Object)((GenericRecord)request).get("x"));
            return 1;
        }
    }
}

