/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.ipc.trace;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.avro.generic.GenericData;
import org.apache.avro.ipc.HttpServer;
import org.apache.avro.ipc.HttpTransceiver;
import org.apache.avro.ipc.Responder;
import org.apache.avro.ipc.generic.GenericRequestor;
import org.apache.avro.ipc.trace.Span;
import org.apache.avro.ipc.trace.SpanAggregator;
import org.apache.avro.ipc.trace.TestBasicTracing;
import org.apache.avro.ipc.trace.Trace;
import org.apache.avro.ipc.trace.TraceCollection;
import org.apache.avro.ipc.trace.TracePlugin;
import org.apache.avro.ipc.trace.TracePluginConfiguration;
import org.junit.Assert;
import org.junit.Test;

public class TestTraceCollection {
    @Test
    public void testRecursingTrace() throws Exception {
        TracePluginConfiguration conf = new TracePluginConfiguration();
        conf.traceProb = 1.0;
        conf.port = 51010;
        conf.clientPort = 12346;
        TracePlugin aPlugin = new TracePlugin(conf);
        conf.port = 51011;
        conf.clientPort = 12347;
        TracePlugin bPlugin = new TracePlugin(conf);
        conf.port = 51012;
        conf.clientPort = 12348;
        TracePlugin cPlugin = new TracePlugin(conf);
        conf.port = 51013;
        conf.clientPort = 12349;
        TracePlugin dPlugin = new TracePlugin(conf);
        TestBasicTracing.RecursingResponder bRes = new TestBasicTracing.RecursingResponder(TestBasicTracing.advancedProtocol, bPlugin);
        bRes.addRPCPlugin(bPlugin);
        HttpServer server1 = new HttpServer((Responder)bRes, 21005);
        server1.start();
        TestBasicTracing.EndpointResponder cRes = new TestBasicTracing.EndpointResponder(TestBasicTracing.advancedProtocol);
        cRes.addRPCPlugin(cPlugin);
        HttpServer server2 = new HttpServer((Responder)cRes, 21006);
        server2.start();
        TestBasicTracing.EndpointResponder dRes = new TestBasicTracing.EndpointResponder(TestBasicTracing.advancedProtocol);
        dRes.addRPCPlugin(dPlugin);
        HttpServer server3 = new HttpServer((Responder)dRes, 21007);
        server3.start();
        HttpTransceiver trans = new HttpTransceiver(new URL("http://localhost:21005"));
        GenericRequestor r = new GenericRequestor(TestBasicTracing.advancedProtocol, trans);
        r.addRPCPlugin(aPlugin);
        GenericData.Record params = new GenericData.Record(TestBasicTracing.advancedProtocol.getMessages().get("w").getRequest());
        params.put("req", (Object)1);
        for (int i = 0; i < 40; ++i) {
            r.request("w", params);
        }
        server1.close();
        server2.close();
        server3.close();
        aPlugin.httpServer.close();
        aPlugin.clientFacingServer.stop();
        bPlugin.httpServer.close();
        bPlugin.clientFacingServer.stop();
        cPlugin.httpServer.close();
        cPlugin.clientFacingServer.stop();
        dPlugin.httpServer.close();
        dPlugin.clientFacingServer.stop();
        ArrayList<Span> allSpans = new ArrayList<Span>();
        allSpans.addAll(aPlugin.storage.getAllSpans());
        allSpans.addAll(bPlugin.storage.getAllSpans());
        allSpans.addAll(cPlugin.storage.getAllSpans());
        allSpans.addAll(dPlugin.storage.getAllSpans());
        SpanAggregator.SpanAggregationResults results = SpanAggregator.getFullSpans(allSpans);
        Assert.assertEquals((long)0L, (long)results.incompleteSpans.size());
        List<Span> merged = results.completeSpans;
        List<Trace> traces = SpanAggregator.getTraces(merged).traces;
        Assert.assertEquals((long)40L, (long)traces.size());
        TraceCollection collection = new TraceCollection(traces.get(0));
        for (Trace t : traces) {
            collection.addTrace(t);
        }
    }
}

