/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.specific;

import org.apache.avro.AvroRuntimeException;
import org.apache.avro.test.errors.TestError;
import org.junit.Assert;
import org.junit.Test;

public class TestSpecificErrorBuilder {
    @Test
    public void testSpecificErrorBuilder() {
        TestError.Builder testErrorBuilder = TestError.newBuilder().setValue("value").setCause(new NullPointerException()).setMessage$("message$");
        Assert.assertTrue((boolean)testErrorBuilder.hasValue());
        Assert.assertNotNull((Object)testErrorBuilder.getValue());
        Assert.assertTrue((boolean)testErrorBuilder.hasCause());
        Assert.assertNotNull((Object)testErrorBuilder.getCause());
        Assert.assertTrue((boolean)testErrorBuilder.hasMessage$());
        Assert.assertNotNull((Object)testErrorBuilder.getMessage$());
        TestError testError = testErrorBuilder.build();
        Assert.assertEquals((Object)"value", (Object)testError.getValue());
        Assert.assertEquals((Object)"value", (Object)testError.getMessage());
        Assert.assertEquals((Object)"message$", (Object)testError.getMessage$());
        Assert.assertEquals((Object)testErrorBuilder, (Object)TestError.newBuilder(testErrorBuilder));
        Assert.assertEquals((Object)testErrorBuilder, (Object)TestError.newBuilder(testError));
        TestError error = new TestError((Object)"value", (Throwable)new NullPointerException());
        error.setMessage$("message");
        Assert.assertEquals((Object)error, (Object)TestError.newBuilder().setValue("value").setCause(new NullPointerException()).setMessage$("message").build());
        testErrorBuilder.clearValue();
        Assert.assertFalse((boolean)testErrorBuilder.hasValue());
        Assert.assertNull((Object)testErrorBuilder.getValue());
        testErrorBuilder.clearCause();
        Assert.assertFalse((boolean)testErrorBuilder.hasCause());
        Assert.assertNull((Object)testErrorBuilder.getCause());
        testErrorBuilder.clearMessage$();
        Assert.assertFalse((boolean)testErrorBuilder.hasMessage$());
        Assert.assertNull((Object)testErrorBuilder.getMessage$());
    }

    @Test(expected=AvroRuntimeException.class)
    public void attemptToSetNonNullableFieldToNull() {
        TestError.newBuilder().setMessage$(null);
    }
}

