/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.tool;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.List;
import java.util.Map;
import org.apache.avro.tool.Tool;
import org.apache.avro.tool.TrevniUtil;
import org.apache.trevni.ColumnFileReader;
import org.apache.trevni.ColumnMetaData;
import org.apache.trevni.Input;
import org.apache.trevni.MetaData;
import org.codehaus.jackson.JsonEncoding;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.util.MinimalPrettyPrinter;

public class TrevniMetadataTool
implements Tool {
    static final JsonFactory FACTORY = new JsonFactory();
    private JsonGenerator generator;
    private ColumnFileReader reader;

    @Override
    public String getName() {
        return "trevni_meta";
    }

    @Override
    public String getShortDescription() {
        return "Dumps a Trevni file's metadata as JSON.";
    }

    @Override
    public int run(InputStream stdin, PrintStream out, PrintStream err, List<String> args) throws Exception {
        String filename;
        boolean pretty = false;
        if (args.size() == 2 && "-pretty".equals(args.get(0))) {
            pretty = true;
            filename = args.get(1);
        } else if (args.size() == 1) {
            filename = args.get(0);
        } else {
            err.println("Usage: [-pretty] input");
            return 1;
        }
        this.dump(TrevniUtil.input(filename), out, pretty);
        return 0;
    }

    public void dump(Input input, PrintStream out, boolean pretty) throws IOException {
        this.generator = FACTORY.createJsonGenerator(out, JsonEncoding.UTF8);
        if (pretty) {
            this.generator.useDefaultPrettyPrinter();
        } else {
            MinimalPrettyPrinter pp = new MinimalPrettyPrinter();
            pp.setRootValueSeparator(System.getProperty("line.separator"));
            this.generator.setPrettyPrinter(pp);
        }
        this.reader = new ColumnFileReader(input);
        this.generator.writeStartObject();
        this.generator.writeNumberField("rowCount", this.reader.getRowCount());
        this.generator.writeNumberField("columnCount", this.reader.getColumnCount());
        this.generator.writeFieldName("metadata");
        this.dump(this.reader.getMetaData());
        this.generator.writeFieldName("columns");
        this.generator.writeStartArray();
        for (ColumnMetaData c : this.reader.getColumnMetaData()) {
            this.dump(c);
        }
        this.generator.writeEndArray();
        this.generator.writeEndObject();
        this.generator.flush();
        out.println();
        this.reader.close();
    }

    private void dump(MetaData<?> meta) throws IOException {
        this.generator.writeStartObject();
        for (Map.Entry e : meta.entrySet()) {
            this.generator.writeStringField((String)e.getKey(), new String((byte[])e.getValue(), "ISO-8859-1"));
        }
        this.generator.writeEndObject();
    }
}

