/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.schema;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.axis2.schema.SchemaConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanWriterMetaInfoHolder {
    protected boolean ordered = false;
    protected boolean anonymous = false;
    protected boolean choice = false;
    protected boolean simple = false;
    protected boolean extension = false;
    protected boolean restriction = false;
    private String extensionClassName = "";
    private String restrictionClassName = "";
    private QName extensionBaseType = null;
    private QName restrictionBaseType = null;
    protected Map<QName, QName> elementToSchemaQNameMap = new LinkedHashMap<QName, QName>();
    protected Map<QName, String> elementToJavaClassMap = new LinkedHashMap<QName, String>();
    protected Map<QName, Integer> specialTypeFlagMap = new LinkedHashMap<QName, Integer>();
    protected Map<QName, Long> qNameMaxOccursCountMap = new LinkedHashMap<QName, Long>();
    protected Map<QName, Long> qNameMinOccursCountMap = new LinkedHashMap<QName, Long>();
    protected Map<Integer, QName> qNameOrderMap = new LinkedHashMap<Integer, QName>();
    protected QName ownQname = null;
    protected String ownClassName = null;
    protected long lengthFacet = -1L;
    protected long maxLengthFacet = -1L;
    protected long minLengthFacet = -1L;
    protected ArrayList<String> enumFacet = new ArrayList();
    protected String patternFacet = null;
    protected String totalDigitsFacet = null;
    protected String maxExclusiveFacet = null;
    protected String minExclusiveFacet = null;
    protected String maxInclusiveFacet = null;
    protected String minInclusiveFacet = null;
    protected Map<QName, String> memberTypes = new HashMap<QName, String>();
    protected Map<String, String> xmlNameJavaNameMap = new HashMap<String, String>();
    protected List<QName> memberTypesKeys = new ArrayList<QName>();
    protected Map<QName, String> elementQNameToDefulatValueMap = new HashMap<QName, String>();
    protected QName itemTypeQName;
    protected String itemTypeClassName;
    protected boolean isUnion;
    protected boolean isList;
    protected boolean isParticleClass;
    protected boolean hasParticleType;
    protected List<QName> nillableQNameList = new ArrayList<QName>();
    protected List<QName> fixedQNameList = new ArrayList<QName>();
    protected BeanWriterMetaInfoHolder parent = null;

    public boolean isChoice() {
        return this.choice;
    }

    public void setChoice(boolean choice) {
        this.choice = choice;
    }

    public boolean isSimple() {
        return this.simple;
    }

    public void setSimple(boolean simple) {
        this.simple = simple;
    }

    public String getOwnClassName() {
        return this.ownClassName;
    }

    public void setOwnClassName(String ownClassName) {
        this.ownClassName = ownClassName;
    }

    public QName getOwnQname() {
        return this.ownQname;
    }

    public void setOwnQname(QName ownQname) {
        this.ownQname = ownQname;
    }

    public BeanWriterMetaInfoHolder getParent() {
        return this.parent;
    }

    public boolean isAnonymous() {
        return this.anonymous;
    }

    public void setAnonymous(boolean anonymous) {
        this.anonymous = anonymous;
    }

    public String getExtensionClassName() {
        return this.extensionClassName;
    }

    public void setExtensionClassName(String extensionClassName) {
        this.extensionClassName = extensionClassName;
    }

    public boolean isExtension() {
        return this.extension;
    }

    public void setExtension(boolean extension) {
        this.extension = extension;
    }

    public String getRestrictionClassName() {
        return this.restrictionClassName;
    }

    public void setRestrictionClassName(String restrictionClassName) {
        this.restrictionClassName = restrictionClassName;
    }

    public boolean isRestriction() {
        return this.restriction;
    }

    public void setRestriction(boolean restriction) {
        this.restriction = restriction;
    }

    public void setExtensionBaseType(QName extensionBaseType) {
        this.extensionBaseType = extensionBaseType;
    }

    public boolean isExtensionBaseType(QName extensionBaseType) {
        return this.extensionBaseType == extensionBaseType;
    }

    public void setRestrictionBaseType(QName restrictionBaseType) {
        this.restrictionBaseType = restrictionBaseType;
    }

    public boolean isRestrictionBaseType(QName restrictionBaseType) {
        QName baseTypeQName = this.elementToSchemaQNameMap.get(restrictionBaseType);
        if (this.restriction && this.simple && baseTypeQName != null && restrictionBaseType != null) {
            return true;
        }
        return this.restrictionBaseType != null && baseTypeQName != null && this.restrictionBaseType.equals(baseTypeQName);
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    public void setOrdered(boolean ordered) {
        this.ordered = ordered;
    }

    public void registerMapping(QName qName, QName schemaName, String javaClassName) {
        this.registerMapping(qName, schemaName, javaClassName, 2);
    }

    public void registerNillableQName(QName eltQName) {
        this.nillableQNameList.add(eltQName);
    }

    public boolean isNillable(QName eltQName) {
        return this.nillableQNameList.contains(eltQName);
    }

    public void registerFixedQName(QName eltQName) {
        this.fixedQNameList.add(eltQName);
    }

    public boolean isFixed(QName eltQName) {
        return this.fixedQNameList.contains(eltQName);
    }

    public void registerMapping(QName qName, QName schemaName, String javaClassName, int type) {
        this.elementToJavaClassMap.put(qName, javaClassName);
        this.elementToSchemaQNameMap.put(qName, schemaName);
        this.addtStatus(qName, type);
    }

    public void registerDefaultValue(QName qname, String value) {
        this.elementQNameToDefulatValueMap.put(qname, value);
    }

    public boolean isDefaultValueAvailable(QName qname) {
        return this.elementQNameToDefulatValueMap.containsKey(qname);
    }

    public String getDefaultValueForQName(QName qname) {
        return this.elementQNameToDefulatValueMap.get(qname);
    }

    public QName getSchemaQNameForQName(QName eltQName) {
        return this.elementToSchemaQNameMap.get(eltQName);
    }

    public String getClassNameForQName(QName eltQName) {
        return this.elementToJavaClassMap.get(eltQName);
    }

    public boolean getAttributeStatusForQName(QName qName) {
        Integer state = this.specialTypeFlagMap.get(qName);
        return state != null && this.getStatus(state, 1);
    }

    public boolean getDefaultStatusForQName(QName qName) {
        boolean isDefault = false;
        QName schemaTypeQName = this.elementToSchemaQNameMap.get(qName);
        if (schemaTypeQName != null) {
            isDefault = schemaTypeQName.equals(SchemaConstants.XSD_ANYTYPE);
        }
        return isDefault;
    }

    public boolean getAnyStatusForQName(QName qName) {
        Integer state = this.specialTypeFlagMap.get(qName);
        return state != null && this.getStatus(state, 8);
    }

    public boolean getArrayStatusForQName(QName qName) {
        Integer state = this.specialTypeFlagMap.get(qName);
        return state != null && this.getStatus(state, 4);
    }

    public boolean getBinaryStatusForQName(QName qName) {
        Integer state = this.specialTypeFlagMap.get(qName);
        return state != null && this.getStatus(state, 16);
    }

    public boolean getInnerChoiceStatusForQName(QName qName) {
        Integer state = this.specialTypeFlagMap.get(qName);
        return state != null && this.getStatus(state, 128);
    }

    public boolean getSimpleStatusForQName(QName qName) {
        Integer state = this.specialTypeFlagMap.get(qName);
        return state != null && this.getStatus(state, 64);
    }

    public boolean getParticleTypeStatusForQName(QName qName) {
        Integer state = this.specialTypeFlagMap.get(qName);
        return state != null && this.getStatus(state, 256);
    }

    public boolean getAnyAttributeStatusForQName(QName qName) {
        return this.getArrayStatusForQName(qName) && this.getAnyStatusForQName(qName);
    }

    public boolean getOptionalAttributeStatusForQName(QName qName) {
        Integer state = this.specialTypeFlagMap.get(qName);
        return state != null && this.getStatus(state, 32);
    }

    public void clearTables() {
        this.elementToJavaClassMap.clear();
        this.elementToSchemaQNameMap.clear();
        this.elementToSchemaQNameMap.clear();
        this.elementToJavaClassMap.clear();
        this.specialTypeFlagMap.clear();
        this.qNameMaxOccursCountMap.clear();
        this.qNameMinOccursCountMap.clear();
        this.qNameOrderMap.clear();
        this.elementQNameToDefulatValueMap.clear();
    }

    public void addMinOccurs(QName qName, long minOccurs) {
        this.qNameMinOccursCountMap.put(qName, minOccurs);
    }

    public void registerQNameIndex(QName qName, int index) {
        this.qNameOrderMap.put(index, qName);
    }

    public long getMinOccurs(QName qName) {
        Long l = this.qNameMinOccursCountMap.get(qName);
        return l != null ? l : 1L;
    }

    public long getMaxOccurs(QName qName) {
        Long l = this.qNameMaxOccursCountMap.get(qName);
        return l != null ? l : 1L;
    }

    public void addMaxOccurs(QName qName, long maxOccurs) {
        this.qNameMaxOccursCountMap.put(qName, maxOccurs);
    }

    public Iterator<QName> getElementQNameIterator() {
        return this.elementToJavaClassMap.keySet().iterator();
    }

    public QName[] getQNameArray() {
        Set<QName> keySet = this.elementToJavaClassMap.keySet();
        return keySet.toArray(new QName[keySet.size()]);
    }

    public QName[] getOrderedQNameArray() {
        Set<Integer> set = this.qNameOrderMap.keySet();
        int count = set.size();
        Object[] keys = set.toArray(new Integer[count]);
        Arrays.sort(keys);
        ArrayList<QName> returnQNames = new ArrayList<QName>();
        for (int i = 0; i < keys.length; ++i) {
            returnQNames.add(this.qNameOrderMap.get(keys[i]));
        }
        QName[] allNames = this.getQNameArray();
        for (int i = 0; i < allNames.length; ++i) {
            if (!this.getAttributeStatusForQName(allNames[i])) continue;
            returnQNames.add(allNames[i]);
        }
        return returnQNames.toArray(new QName[returnQNames.size()]);
    }

    public int getOrderStartPoint() {
        return this.qNameOrderMap.size();
    }

    public void setAsParent(BeanWriterMetaInfoHolder metaInfo) {
        this.parent = metaInfo;
    }

    public void addtStatus(QName type, int mask) {
        Integer preValue = this.specialTypeFlagMap.get(type);
        if (preValue != null) {
            this.specialTypeFlagMap.put(type, preValue | mask);
        } else {
            this.specialTypeFlagMap.put(type, mask);
        }
    }

    private boolean getStatus(int storedStatus, int mask) {
        return mask == (mask & storedStatus);
    }

    public void setLengthFacet(long lengthFacet) {
        this.lengthFacet = lengthFacet;
    }

    public long getLengthFacet() {
        return this.lengthFacet;
    }

    public void setTotalDigitsFacet(String totalDigitsFacet) {
        this.totalDigitsFacet = totalDigitsFacet;
    }

    public String getTotalDigitsFacet() {
        return this.totalDigitsFacet;
    }

    public void setMaxExclusiveFacet(String maxExclusiveFacet) {
        this.maxExclusiveFacet = maxExclusiveFacet;
    }

    public String getMaxExclusiveFacet() {
        return this.maxExclusiveFacet;
    }

    public void setMinExclusiveFacet(String minExclusiveFacet) {
        this.minExclusiveFacet = minExclusiveFacet;
    }

    public String getMinExclusiveFacet() {
        return this.minExclusiveFacet;
    }

    public void setMaxInclusiveFacet(String maxInclusiveFacet) {
        this.maxInclusiveFacet = maxInclusiveFacet;
    }

    public String getMaxInclusiveFacet() {
        return this.maxInclusiveFacet;
    }

    public void setMinInclusiveFacet(String minInclusiveFacet) {
        this.minInclusiveFacet = minInclusiveFacet;
    }

    public String getMinInclusiveFacet() {
        return this.minInclusiveFacet;
    }

    public void setMaxLengthFacet(long maxLengthFacet) {
        this.maxLengthFacet = maxLengthFacet;
    }

    public long getMaxLengthFacet() {
        return this.maxLengthFacet;
    }

    public void setMinLengthFacet(long minLengthFacet) {
        this.minLengthFacet = minLengthFacet;
    }

    public long getMinLengthFacet() {
        return this.minLengthFacet;
    }

    public void setEnumFacet(ArrayList<String> enumFacet) {
        this.enumFacet = enumFacet;
    }

    public void addEnumFacet(String enumFacet) {
        this.enumFacet.add(enumFacet);
    }

    public List<String> getEnumFacet() {
        return this.enumFacet;
    }

    public void setPatternFacet(String patternFacet) {
        this.patternFacet = patternFacet;
    }

    public String getPatternFacet() {
        return this.patternFacet;
    }

    public boolean isUnion() {
        return this.isUnion;
    }

    public void setUnion(boolean union) {
        this.isUnion = union;
    }

    public Map<QName, String> getMemberTypes() {
        return this.memberTypes;
    }

    public void setMemberTypes(Map<QName, String> memberTypes) {
        this.memberTypes = memberTypes;
    }

    public List<QName> getMemberTypesKeys() {
        return this.memberTypesKeys;
    }

    public void setMemberTypesKeys(List<QName> memberTypesKeys) {
        this.memberTypesKeys = memberTypesKeys;
    }

    public void addMemberType(QName qname, String className) {
        this.memberTypes.put(qname, className);
        this.memberTypesKeys.add(qname);
    }

    public boolean isList() {
        return this.isList;
    }

    public void setList(boolean list) {
        this.isList = list;
    }

    public QName getItemTypeQName() {
        return this.itemTypeQName;
    }

    public void setItemTypeQName(QName itemTypeQName) {
        this.itemTypeQName = itemTypeQName;
    }

    public String getItemTypeClassName() {
        return this.itemTypeClassName;
    }

    public void setItemTypeClassName(String itemTypeClassName) {
        this.itemTypeClassName = itemTypeClassName;
    }

    public boolean isParticleClass() {
        return this.isParticleClass;
    }

    public void setParticleClass(boolean particleClass) {
        this.isParticleClass = particleClass;
    }

    public boolean isHasParticleType() {
        return this.hasParticleType;
    }

    public void setHasParticleType(boolean hasParticleType) {
        this.hasParticleType = hasParticleType;
    }

    public void addXmlNameJavaNameMapping(String xmlName, String javaName) {
        this.xmlNameJavaNameMap.put(xmlName, javaName);
    }

    public boolean isJavaNameMappingAvailable(String xmlName) {
        return this.xmlNameJavaNameMap.containsKey(xmlName);
    }

    public String getJavaName(String xmlName) {
        return this.xmlNameJavaNameMap.get(xmlName);
    }

    public QName getRestrictionBaseType() {
        return this.restrictionBaseType;
    }

    public String toString() {
        return "BeanWriterMetaInfoHolder [anonymous=" + this.anonymous + ", choice=" + this.choice + ", elementQNameToDefulatValueMap=" + this.elementQNameToDefulatValueMap + ", elementToJavaClassMap=" + this.elementToJavaClassMap + ", elementToSchemaQNameMap=" + this.elementToSchemaQNameMap + ", enumFacet=" + this.enumFacet + ", extension=" + this.extension + ", extensionBaseType=" + this.extensionBaseType + ", extensionClassName=" + this.extensionClassName + ", hasParticleType=" + this.hasParticleType + ", isList=" + this.isList + ", isParticleClass=" + this.isParticleClass + ", isUnion=" + this.isUnion + ", itemTypeClassName=" + this.itemTypeClassName + ", itemTypeQName=" + this.itemTypeQName + ", lengthFacet=" + this.lengthFacet + ", maxExclusiveFacet=" + this.maxExclusiveFacet + ", maxInclusiveFacet=" + this.maxInclusiveFacet + ", maxLengthFacet=" + this.maxLengthFacet + ", memberTypes=" + this.memberTypes + ", memberTypesKeys=" + this.memberTypesKeys + ", minExclusiveFacet=" + this.minExclusiveFacet + ", minInclusiveFacet=" + this.minInclusiveFacet + ", minLengthFacet=" + this.minLengthFacet + ", nillableQNameList=" + this.nillableQNameList + ", ordered=" + this.ordered + ", ownClassName=" + this.ownClassName + ", ownQname=" + this.ownQname + ", parent=" + this.parent + ", patternFacet=" + this.patternFacet + ", qNameMaxOccursCountMap=" + this.qNameMaxOccursCountMap + ", qNameMinOccursCountMap=" + this.qNameMinOccursCountMap + ", qNameOrderMap=" + this.qNameOrderMap + ", restriction=" + this.restriction + ", restrictionBaseType=" + this.restrictionBaseType + ", restrictionClassName=" + this.restrictionClassName + ", simple=" + this.simple + ", specialTypeFlagMap=" + this.specialTypeFlagMap + ", totalDigitsFacet=" + this.totalDigitsFacet + ", xmlNameJavaNameMap=" + this.xmlNameJavaNameMap + ", fixedQNameList=" + this.fixedQNameList + "]";
    }
}

