/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql;

import java.nio.ByteBuffer;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.cql.CreateColumnFamilyStatement;
import org.apache.cassandra.db.marshal.TypeParser;
import org.apache.cassandra.db.migration.avro.CfDef;
import org.apache.cassandra.db.migration.avro.ColumnDef;
import org.apache.cassandra.thrift.InvalidRequestException;

public class AlterTableStatement {
    public final OperationType oType;
    public final String columnFamily;
    public final String columnName;
    public final String validator;

    public AlterTableStatement(String columnFamily, OperationType type, String columnName) {
        this(columnFamily, type, columnName, null);
    }

    public AlterTableStatement(String columnFamily, OperationType type, String columnName, String validator) {
        this.columnFamily = columnFamily;
        this.oType = type;
        this.columnName = columnName;
        this.validator = CreateColumnFamilyStatement.comparators.get(validator);
    }

    public CfDef getCfDef(String keyspace) throws ConfigurationException, InvalidRequestException {
        CFMetaData meta = DatabaseDescriptor.getCFMetaData(keyspace, this.columnFamily);
        CfDef cfDef = CFMetaData.convertToAvro(meta);
        ByteBuffer columnName = meta.comparator.fromString(this.columnName);
        switch (this.oType) {
            case ADD: {
                cfDef.column_metadata.add(new ColumnDefinition(columnName, TypeParser.parse(this.validator), null, null).deflate());
                break;
            }
            case ALTER: {
                ColumnDefinition column = meta.getColumnDefinition(columnName);
                if (column == null) {
                    throw new InvalidRequestException(String.format("Column '%s' was not found in CF '%s'", this.columnName, this.columnFamily));
                }
                column.setValidator(TypeParser.parse(this.validator));
                cfDef.column_metadata.add(column.deflate());
                break;
            }
            case DROP: {
                ColumnDef toDelete = null;
                for (ColumnDef columnDef : cfDef.column_metadata) {
                    if (!columnDef.name.equals(columnName)) continue;
                    toDelete = columnDef;
                }
                if (toDelete == null) {
                    throw new InvalidRequestException(String.format("Column '%s' was not found in CF '%s'", this.columnName, this.columnFamily));
                }
                cfDef.column_metadata.remove((Object)toDelete);
            }
        }
        return cfDef;
    }

    public String toString() {
        return String.format("AlterTableStatement(cf=%s, type=%s, column=%s, validator=%s)", new Object[]{this.columnFamily, this.oType, this.columnName, this.validator});
    }

    public static enum OperationType {
        ADD,
        ALTER,
        DROP;

    }
}

