/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import org.apache.cassandra.concurrent.Stage;
import org.apache.cassandra.io.ICompactSerializer;
import org.apache.cassandra.net.Header;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.FBUtilities;

public class Message {
    private static ICompactSerializer<Message> serializer_ = new MessageSerializer();
    final Header header_;
    private final byte[] body_;
    private final transient int version;

    public static ICompactSerializer<Message> serializer() {
        return serializer_;
    }

    private Message(Header header, byte[] body, int version) {
        assert (header != null);
        assert (body != null);
        this.header_ = header;
        this.body_ = body;
        this.version = version;
    }

    public Message(InetAddress from, StorageService.Verb verb, byte[] body, int version) {
        this(new Header(from, verb), body, version);
    }

    public byte[] getHeader(String key) {
        return this.header_.getDetail(key);
    }

    public void setHeader(String key, byte[] value) {
        this.header_.setDetail(key, value);
    }

    public void removeHeader(String key) {
        this.header_.removeDetail(key);
    }

    public byte[] getMessageBody() {
        return this.body_;
    }

    public int getVersion() {
        return this.version;
    }

    public InetAddress getFrom() {
        return this.header_.getFrom();
    }

    public Stage getMessageType() {
        return StorageService.verbStages.get((Object)this.getVerb());
    }

    public StorageService.Verb getVerb() {
        return this.header_.getVerb();
    }

    public Message getReply(InetAddress from, byte[] body, int version) {
        Header header = new Header(from, StorageService.Verb.REQUEST_RESPONSE);
        return new Message(header, body, version);
    }

    public Message getInternalReply(byte[] body, int version) {
        Header header = new Header(FBUtilities.getLocalAddress(), StorageService.Verb.INTERNAL_RESPONSE);
        return new Message(header, body, version);
    }

    public String toString() {
        StringBuilder sbuf = new StringBuilder("");
        String separator = System.getProperty("line.separator");
        sbuf.append("FROM:" + this.getFrom()).append(separator).append("TYPE:" + (Object)((Object)this.getMessageType())).append(separator).append("VERB:" + (Object)((Object)this.getVerb())).append(separator);
        return sbuf.toString();
    }

    private static class MessageSerializer
    implements ICompactSerializer<Message> {
        private MessageSerializer() {
        }

        @Override
        public void serialize(Message t, DataOutputStream dos, int version) throws IOException {
            assert (t.getVersion() == version) : "internode protocol version mismatch";
            Header.serializer().serialize(t.header_, dos, version);
            byte[] bytes = t.getMessageBody();
            dos.writeInt(bytes.length);
            dos.write(bytes);
        }

        @Override
        public Message deserialize(DataInputStream dis, int version) throws IOException {
            Header header = Header.serializer().deserialize(dis, version);
            int size = dis.readInt();
            byte[] bytes = new byte[size];
            dis.readFully(bytes);
            return new Message(header, bytes, version);
        }
    }
}

