/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.cql3.CFName;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.statements.CFPropDefs;
import org.apache.cassandra.cql3.statements.SchemaAlteringStatement;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CollectionType;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.db.marshal.CounterColumnType;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.exceptions.UnauthorizedException;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.MigrationManager;
import org.apache.cassandra.thrift.ThriftValidation;
import org.apache.cassandra.transport.Event;

public class AlterTableStatement
extends SchemaAlteringStatement {
    public final Type oType;
    public final CQL3Type.Raw validator;
    public final ColumnIdentifier.Raw rawColumnName;
    private final CFPropDefs cfProps;
    private final Map<ColumnIdentifier.Raw, ColumnIdentifier.Raw> renames;
    private final boolean isStatic;

    public AlterTableStatement(CFName name, Type type, ColumnIdentifier.Raw columnName, CQL3Type.Raw validator, CFPropDefs cfProps, Map<ColumnIdentifier.Raw, ColumnIdentifier.Raw> renames, boolean isStatic) {
        super(name);
        this.oType = type;
        this.rawColumnName = columnName;
        this.validator = validator;
        this.cfProps = cfProps;
        this.renames = renames;
        this.isStatic = isStatic;
    }

    @Override
    public void checkAccess(ClientState state) throws UnauthorizedException, InvalidRequestException {
        state.hasColumnFamilyAccess(this.keyspace(), this.columnFamily(), Permission.ALTER);
    }

    @Override
    public void validate(ClientState state) {
    }

    @Override
    public boolean announceMigration(boolean isLocalOnly) throws RequestValidationException {
        CFMetaData meta = ThriftValidation.validateColumnFamily(this.keyspace(), this.columnFamily());
        CFMetaData cfm = meta.copy();
        CQL3Type validator = this.validator == null ? null : this.validator.prepare(this.keyspace());
        ColumnIdentifier columnName = null;
        ColumnDefinition def = null;
        if (this.rawColumnName != null) {
            columnName = this.rawColumnName.prepare(cfm);
            def = cfm.getColumnDefinition(columnName);
        }
        if (this.cfProps.getId() != null) {
            throw new ConfigurationException("Cannot alter table id.");
        }
        switch (this.oType) {
            case ADD: {
                assert (columnName != null);
                if (cfm.comparator.isDense()) {
                    throw new InvalidRequestException("Cannot add new column to a COMPACT STORAGE table");
                }
                if (this.isStatic) {
                    if (!cfm.comparator.isCompound()) {
                        throw new InvalidRequestException("Static columns are not allowed in COMPACT STORAGE tables");
                    }
                    if (cfm.clusteringColumns().isEmpty()) {
                        throw new InvalidRequestException("Static columns are only useful (and thus allowed) if the table has at least one clustering column");
                    }
                }
                if (def != null) {
                    switch (def.kind) {
                        case PARTITION_KEY: 
                        case CLUSTERING_COLUMN: {
                            throw new InvalidRequestException(String.format("Invalid column name %s because it conflicts with a PRIMARY KEY part", columnName));
                        }
                    }
                    throw new InvalidRequestException(String.format("Invalid column name %s because it conflicts with an existing column", columnName));
                }
                if (meta.isCounter() && meta.getDroppedColumns().containsKey(columnName)) {
                    throw new InvalidRequestException(String.format("Cannot re-add previously dropped counter column %s", columnName));
                }
                AbstractType<?> type = validator.getType();
                if (type.isCollection() && type.isMultiCell()) {
                    if (!cfm.comparator.supportCollections()) {
                        throw new InvalidRequestException("Cannot use non-frozen collections with a non-composite PRIMARY KEY");
                    }
                    if (cfm.isSuper()) {
                        throw new InvalidRequestException("Cannot use non-frozen collections with super column families");
                    }
                    if (cfm.comparator.hasCollections()) {
                        CollectionType previous;
                        CollectionType collectionType = previous = cfm.comparator.collectionType() == null ? null : cfm.comparator.collectionType().defined.get(columnName.bytes);
                        if (previous != null && !type.isCompatibleWith(previous)) {
                            throw new InvalidRequestException(String.format("Cannot add a collection with the name %s because a collection with the same name and a different type has already been used in the past", columnName));
                        }
                    }
                    cfm.comparator = cfm.comparator.addOrUpdateCollection(columnName, (CollectionType)type);
                }
                Integer componentIndex = cfm.comparator.isCompound() ? Integer.valueOf(cfm.comparator.clusteringPrefixSize()) : null;
                cfm.addColumnDefinition(this.isStatic ? ColumnDefinition.staticDef(cfm, columnName.bytes, type, componentIndex) : ColumnDefinition.regularDef(cfm, columnName.bytes, type, componentIndex));
                break;
            }
            case ALTER: {
                assert (columnName != null);
                if (def == null) {
                    throw new InvalidRequestException(String.format("Column %s was not found in table %s", columnName, this.columnFamily()));
                }
                AbstractType<?> validatorType = validator.getType();
                switch (def.kind) {
                    case PARTITION_KEY: {
                        if (validatorType instanceof CounterColumnType) {
                            throw new InvalidRequestException(String.format("counter type is not supported for PRIMARY KEY part %s", columnName));
                        }
                        if (cfm.getKeyValidator() instanceof CompositeType) {
                            List<AbstractType<?>> oldTypes = ((CompositeType)cfm.getKeyValidator()).types;
                            if (!validatorType.isValueCompatibleWith(oldTypes.get(def.position()))) {
                                throw new ConfigurationException(String.format("Cannot change %s from type %s to type %s: types are incompatible.", columnName, oldTypes.get(def.position()).asCQL3Type(), validator));
                            }
                            ArrayList newTypes = new ArrayList(oldTypes);
                            newTypes.set(def.position(), validatorType);
                            cfm.keyValidator(CompositeType.getInstance(newTypes));
                            break;
                        }
                        if (!validatorType.isValueCompatibleWith(cfm.getKeyValidator())) {
                            throw new ConfigurationException(String.format("Cannot change %s from type %s to type %s: types are incompatible.", columnName, cfm.getKeyValidator().asCQL3Type(), validator));
                        }
                        cfm.keyValidator(validatorType);
                        break;
                    }
                    case CLUSTERING_COLUMN: {
                        if (!cfm.isCQL3Table()) {
                            throw new InvalidRequestException(String.format("Cannot alter clustering column %s in a non-CQL3 table", columnName));
                        }
                        AbstractType<?> oldType = cfm.comparator.subtype(def.position());
                        if (!validatorType.isCompatibleWith(oldType)) {
                            throw new ConfigurationException(String.format("Cannot change %s from type %s to type %s: types are not order-compatible.", columnName, oldType.asCQL3Type(), validator));
                        }
                        cfm.comparator = cfm.comparator.setSubtype(def.position(), validatorType);
                        break;
                    }
                    case COMPACT_VALUE: {
                        if (!validatorType.isValueCompatibleWith(cfm.getDefaultValidator())) {
                            throw new ConfigurationException(String.format("Cannot change %s from type %s to type %s: types are incompatible.", columnName, cfm.getDefaultValidator().asCQL3Type(), validator));
                        }
                        cfm.defaultValidator(validatorType);
                        break;
                    }
                    case REGULAR: 
                    case STATIC: {
                        if (!validatorType.isValueCompatibleWith(def.type)) {
                            throw new ConfigurationException(String.format("Cannot change %s from type %s to type %s: types are incompatible.", columnName, def.type.asCQL3Type(), validator));
                        }
                        if (!validatorType.isCollection() || !validatorType.isMultiCell()) break;
                        cfm.comparator = cfm.comparator.addOrUpdateCollection(def.name, (CollectionType)validatorType);
                    }
                }
                cfm.addOrReplaceColumnDefinition(def.withNewType(validatorType));
                break;
            }
            case DROP: {
                assert (columnName != null);
                if (!cfm.isCQL3Table()) {
                    throw new InvalidRequestException("Cannot drop columns from a non-CQL3 table");
                }
                if (def == null) {
                    throw new InvalidRequestException(String.format("Column %s was not found in table %s", columnName, this.columnFamily()));
                }
                switch (def.kind) {
                    case PARTITION_KEY: 
                    case CLUSTERING_COLUMN: {
                        throw new InvalidRequestException(String.format("Cannot drop PRIMARY KEY part %s", columnName));
                    }
                    case REGULAR: 
                    case STATIC: {
                        ColumnDefinition toDelete = null;
                        for (ColumnDefinition columnDef : cfm.regularAndStaticColumns()) {
                            if (!columnDef.name.equals(columnName)) continue;
                            toDelete = columnDef;
                            break;
                        }
                        assert (toDelete != null);
                        cfm.removeColumnDefinition(toDelete);
                        cfm.recordColumnDrop(toDelete);
                    }
                }
                break;
            }
            case OPTS: {
                if (this.cfProps == null) {
                    throw new InvalidRequestException("ALTER TABLE WITH invoked, but no parameters found");
                }
                this.cfProps.validate();
                if (meta.isCounter() && this.cfProps.getDefaultTimeToLive() > 0) {
                    throw new InvalidRequestException("Cannot set default_time_to_live on a table with counters");
                }
                this.cfProps.applyToCFMetadata(cfm);
                break;
            }
            case RENAME: {
                for (Map.Entry<ColumnIdentifier.Raw, ColumnIdentifier.Raw> entry : this.renames.entrySet()) {
                    ColumnIdentifier from = entry.getKey().prepare(cfm);
                    ColumnIdentifier to = entry.getValue().prepare(cfm);
                    cfm.renameColumn(from, to);
                }
                break;
            }
        }
        MigrationManager.announceColumnFamilyUpdate(cfm, isLocalOnly);
        return true;
    }

    public String toString() {
        return String.format("AlterTableStatement(name=%s, type=%s, column=%s, validator=%s)", new Object[]{this.cfName, this.oType, this.rawColumnName, this.validator});
    }

    @Override
    public Event.SchemaChange changeEvent() {
        return new Event.SchemaChange(Event.SchemaChange.Change.UPDATED, Event.SchemaChange.Target.TABLE, this.keyspace(), this.columnFamily());
    }

    public static enum Type {
        ADD,
        ALTER,
        DROP,
        OPTS,
        RENAME;

    }
}

