/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.client;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.function.ThrowableAction;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.metadata.MappingChangedEvent;
import org.apache.dubbo.metadata.MappingListener;
import org.apache.dubbo.metadata.ServiceNameMapping;
import org.apache.dubbo.metadata.WritableMetadataService;
import org.apache.dubbo.registry.NotifyListener;
import org.apache.dubbo.registry.Registry;
import org.apache.dubbo.registry.client.ServiceDiscovery;
import org.apache.dubbo.registry.client.ServiceDiscoveryFactory;
import org.apache.dubbo.registry.client.ServiceInstance;
import org.apache.dubbo.registry.client.event.ServiceInstancesChangedEvent;
import org.apache.dubbo.registry.client.event.listener.ServiceInstancesChangedListener;
import org.apache.dubbo.registry.client.metadata.SubscribedURLsSynthesizer;
import org.apache.dubbo.registry.support.AbstractRegistryFactory;

public class ServiceDiscoveryRegistry
implements Registry {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ServiceDiscovery serviceDiscovery;
    private final WritableMetadataService writableMetadataService;
    private final Set<String> registeredListeners = new LinkedHashSet<String>();
    private final Map<String, ServiceInstancesChangedListener> serviceListeners = new HashMap<String, ServiceInstancesChangedListener>();
    private URL registryURL;

    public ServiceDiscoveryRegistry(URL registryURL) {
        this.registryURL = registryURL;
        this.serviceDiscovery = this.createServiceDiscovery(registryURL);
        this.writableMetadataService = WritableMetadataService.getDefaultExtension();
    }

    public ServiceDiscovery getServiceDiscovery() {
        return this.serviceDiscovery;
    }

    protected ServiceDiscovery createServiceDiscovery(URL registryURL) {
        ServiceDiscovery serviceDiscovery = this.getServiceDiscovery(registryURL);
        ThrowableAction.execute(() -> serviceDiscovery.initialize(registryURL.addParameter("interface", ServiceDiscovery.class.getName()).removeParameter("registry-type")));
        return serviceDiscovery;
    }

    private List<SubscribedURLsSynthesizer> initSubscribedURLsSynthesizers() {
        ExtensionLoader loader = ExtensionLoader.getExtensionLoader(SubscribedURLsSynthesizer.class);
        return Collections.unmodifiableList(new ArrayList(loader.getSupportedExtensionInstances()));
    }

    private ServiceDiscovery getServiceDiscovery(URL registryURL) {
        ServiceDiscoveryFactory factory = ServiceDiscoveryFactory.getExtension(registryURL);
        return factory.getServiceDiscovery(registryURL);
    }

    protected boolean shouldRegister(URL providerURL) {
        String side = providerURL.getSide();
        boolean should = "provider".equals(side);
        if (!should && this.logger.isDebugEnabled()) {
            this.logger.debug(String.format("The URL[%s] should not be registered.", providerURL.toString()));
        }
        return should;
    }

    protected boolean shouldSubscribe(URL subscribedURL) {
        return !this.shouldRegister(subscribedURL);
    }

    @Override
    public final void register(URL url) {
        if (!this.shouldRegister(url)) {
            return;
        }
        this.doRegister(url);
    }

    public void doRegister(URL url) {
        if (this.writableMetadataService.exportURL(url = this.addRegistryClusterKey(url))) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info(String.format("The URL[%s] registered successfully.", url.toString()));
            }
        } else if (this.logger.isWarnEnabled()) {
            this.logger.warn(String.format("The URL[%s] has been registered.", url.toString()));
        }
    }

    @Override
    public final void unregister(URL url) {
        if (!this.shouldRegister(url)) {
            return;
        }
        this.doUnregister(url);
    }

    public void doUnregister(URL url) {
        if (this.writableMetadataService.unexportURL(url = this.addRegistryClusterKey(url))) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info(String.format("The URL[%s] deregistered successfully.", url.toString()));
            }
        } else if (this.logger.isWarnEnabled()) {
            this.logger.info(String.format("The URL[%s] has been deregistered.", url.toString()));
        }
    }

    @Override
    public final void subscribe(URL url, NotifyListener listener) {
        if (!this.shouldSubscribe(url)) {
            return;
        }
        url = this.addRegistryClusterKey(url);
        this.doSubscribe(url, listener);
    }

    public void doSubscribe(URL url, NotifyListener listener) {
        this.writableMetadataService.subscribeURL(url);
        boolean check = url.getParameter("check", false);
        Set<String> subscribedServices = Collections.emptySet();
        try {
            subscribedServices = this.getServices(this.registryURL, url, listener);
            WritableMetadataService.getDefaultExtension().putCachedMapping(ServiceNameMapping.buildMappingKey((URL)url), subscribedServices);
        }
        catch (Exception e) {
            this.logger.warn("Cannot find app mapping for service " + url.getServiceInterface() + ", will not migrate.", (Throwable)e);
        }
        if (CollectionUtils.isEmpty(subscribedServices)) {
            if (check) {
                throw new IllegalStateException("Should has at least one way to know which services this interface belongs to, subscription url: " + url);
            }
            return;
        }
        this.subscribeURLs(url, listener, subscribedServices);
    }

    @Override
    public final void unsubscribe(URL url, NotifyListener listener) {
        if (!this.shouldSubscribe(url)) {
            return;
        }
        url = this.addRegistryClusterKey(url);
        this.doUnsubscribe(url, listener);
    }

    private URL addRegistryClusterKey(URL url) {
        String registryCluster = this.serviceDiscovery.getUrl().getParameter("REGISTRY_CLUSTER");
        if (registryCluster != null && url.getParameter("REGISTRY_CLUSTER") == null) {
            url = url.addParameter("REGISTRY_CLUSTER", registryCluster);
        }
        return url;
    }

    public void doUnsubscribe(URL url, NotifyListener listener) {
        String serviceNamesKey;
        ServiceInstancesChangedListener instancesChangedListener;
        this.writableMetadataService.unsubscribeURL(url);
        String protocolServiceKey = url.getServiceKey() + ":" + url.getParameter("protocol", "dubbo");
        Set serviceNames = this.writableMetadataService.getCachedMapping(url);
        if (CollectionUtils.isNotEmpty((Collection)serviceNames) && (instancesChangedListener = this.serviceListeners.get(serviceNamesKey = ServiceNameMapping.toStringKeys((Set)serviceNames))) != null) {
            instancesChangedListener.removeListener(protocolServiceKey);
            if (!instancesChangedListener.hasListeners()) {
                this.serviceListeners.remove(serviceNamesKey);
            }
        }
    }

    @Override
    public List<URL> lookup(URL url) {
        throw new UnsupportedOperationException("");
    }

    public URL getUrl() {
        return this.registryURL;
    }

    public boolean isAvailable() {
        return !this.serviceDiscovery.isDestroy() && !this.serviceDiscovery.getServices().isEmpty();
    }

    public void destroy() {
        AbstractRegistryFactory.removeDestroyedRegistry(this);
        ThrowableAction.execute(() -> this.serviceDiscovery.destroy());
    }

    protected void subscribeURLs(URL url, NotifyListener listener, Set<String> serviceNames) {
        String serviceNamesKey = ServiceNameMapping.toStringKeys(serviceNames);
        String protocolServiceKey = url.getServiceKey() + ":" + url.getParameter("protocol", "dubbo");
        ServiceInstancesChangedListener serviceListener = this.serviceListeners.computeIfAbsent(serviceNamesKey, k -> {
            ServiceInstancesChangedListener serviceInstancesChangedListener = this.serviceDiscovery.createListener(serviceNames);
            serviceInstancesChangedListener.setUrl(url);
            serviceNames.forEach(serviceName -> {
                List<ServiceInstance> serviceInstances = this.serviceDiscovery.getInstances((String)serviceName);
                if (CollectionUtils.isNotEmpty(serviceInstances)) {
                    serviceInstancesChangedListener.onEvent(new ServiceInstancesChangedEvent((String)serviceName, serviceInstances));
                }
            });
            return serviceInstancesChangedListener;
        });
        serviceListener.setUrl(url);
        listener.addServiceListener(serviceListener);
        serviceListener.addListenerAndNotify(protocolServiceKey, listener);
        this.registerServiceInstancesChangedListener(url, serviceListener);
    }

    private void registerServiceInstancesChangedListener(URL url, ServiceInstancesChangedListener listener) {
        String listenerId = this.createListenerId(url, listener);
        if (this.registeredListeners.add(listenerId)) {
            this.serviceDiscovery.addServiceInstancesChangedListener(listener);
        }
    }

    private String createListenerId(URL url, ServiceInstancesChangedListener listener) {
        return listener.getServiceNames() + ":" + url.toString(new String[]{"version", "group", "protocol"});
    }

    public static ServiceDiscoveryRegistry create(URL registryURL) {
        return ServiceDiscoveryRegistry.supports(registryURL) ? new ServiceDiscoveryRegistry(registryURL) : null;
    }

    public static boolean supports(URL registryURL) {
        return "service".equalsIgnoreCase(registryURL.getParameter("registry-type"));
    }

    private static List<URL> filterSubscribedURLs(URL subscribedURL, List<URL> exportedURLs) {
        return exportedURLs.stream().filter(url -> ServiceDiscoveryRegistry.isSameServiceInterface(subscribedURL, url)).filter(url -> ServiceDiscoveryRegistry.isSameParameter(subscribedURL, url, "version")).filter(url -> ServiceDiscoveryRegistry.isSameParameter(subscribedURL, url, "group")).filter(url -> ServiceDiscoveryRegistry.isCompatibleProtocol(subscribedURL, url)).collect(Collectors.toList());
    }

    private static boolean isSameServiceInterface(URL one, URL another) {
        return Objects.equals(one.getServiceInterface(), another.getServiceInterface());
    }

    private static boolean isSameParameter(URL one, URL another, String key) {
        return Objects.equals(one.getParameter(key), another.getParameter(key));
    }

    private static boolean isCompatibleProtocol(URL one, URL another) {
        String protocol = one.getParameter("protocol");
        return ServiceDiscoveryRegistry.isCompatibleProtocol(protocol, another);
    }

    private static boolean isCompatibleProtocol(String protocol, URL targetURL) {
        return protocol == null || Objects.equals(protocol, targetURL.getParameter("protocol")) || Objects.equals(protocol, targetURL.getProtocol());
    }

    public Set<String> getRegisteredListeners() {
        return this.registeredListeners;
    }

    public Map<String, ServiceInstancesChangedListener> getServiceListeners() {
        return this.serviceListeners;
    }

    protected Set<String> getServices(URL registryURL, URL subscribedURL, NotifyListener listener) {
        TreeSet<String> subscribedServices = new TreeSet<String>();
        Set<String> globalConfiguredSubscribingServices = ServiceDiscoveryRegistry.parseServices(registryURL.getParameter("subscribed-services"));
        String serviceNames = subscribedURL.getParameter("provided-by");
        if (StringUtils.isNotEmpty((String)serviceNames)) {
            this.logger.info(subscribedURL.getServiceInterface() + " mapping to " + serviceNames + " instructed by provided-by set by user.");
            subscribedServices.addAll(ServiceDiscoveryRegistry.parseServices(serviceNames));
        }
        if (CollectionUtils.isEmpty(subscribedServices)) {
            Set<String> mappedServices = this.findMappedServices(registryURL, subscribedURL, new DefaultMappingListener(subscribedURL, subscribedServices, listener));
            this.logger.info(subscribedURL.getServiceInterface() + " mapping to " + mappedServices + " instructed by remote metadata center.");
            subscribedServices.addAll(mappedServices);
            if (CollectionUtils.isEmpty(subscribedServices)) {
                this.logger.info(subscribedURL.getServiceInterface() + " mapping to " + globalConfiguredSubscribingServices + " by default.");
                subscribedServices.addAll(globalConfiguredSubscribingServices);
            }
        }
        return subscribedServices;
    }

    protected Set<String> findMappedServices(URL registryURL, URL subscribedURL, MappingListener listener) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        ServiceNameMapping serviceNameMapping = ServiceNameMapping.getDefaultExtension();
        result.addAll(serviceNameMapping.getAndListen(subscribedURL, listener));
        return result;
    }

    public static Set<String> parseServices(String literalServices) {
        return StringUtils.isBlank((CharSequence)literalServices) ? Collections.emptySet() : Collections.unmodifiableSet(Stream.of(literalServices.split(",")).map(String::trim).filter(StringUtils::isNotEmpty).collect(Collectors.toSet()));
    }

    private class DefaultMappingListener
    implements MappingListener {
        private final Logger logger = LoggerFactory.getLogger(DefaultMappingListener.class);
        private URL url;
        private Set<String> oldApps;
        private NotifyListener listener;

        public DefaultMappingListener(URL subscribedURL, Set<String> serviceNames, NotifyListener listener) {
            this.url = subscribedURL;
            this.oldApps = serviceNames;
            this.listener = listener;
        }

        public void onEvent(MappingChangedEvent event) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Received mapping notification from meta server, " + event);
            }
            Set newApps = event.getApps();
            Set<String> tempOldApps = this.oldApps;
            this.oldApps = newApps;
            if (CollectionUtils.isEmpty((Collection)newApps)) {
                return;
            }
            if (CollectionUtils.isEmpty(tempOldApps) && newApps.size() > 0) {
                WritableMetadataService.getDefaultExtension().putCachedMapping(ServiceNameMapping.buildMappingKey((URL)this.url), newApps);
                ServiceDiscoveryRegistry.this.subscribeURLs(this.url, this.listener, newApps);
                return;
            }
            for (String newAppName : newApps) {
                if (tempOldApps.contains(newAppName)) continue;
                WritableMetadataService.getDefaultExtension().putCachedMapping(ServiceNameMapping.buildMappingKey((URL)this.url), newApps);
                ServiceDiscoveryRegistry.this.subscribeURLs(this.url, this.listener, newApps);
                return;
            }
        }
    }
}

