/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.client.metadata;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.metadata.MetadataService;
import org.apache.dubbo.metadata.WritableMetadataService;
import org.apache.dubbo.registry.client.ServiceDiscovery;
import org.apache.dubbo.registry.client.ServiceInstance;
import org.apache.dubbo.registry.client.metadata.MetadataServiceURLBuilder;
import org.apache.dubbo.registry.client.metadata.ServiceInstanceMetadataUtils;
import org.apache.dubbo.registry.client.metadata.store.RemoteMetadataServiceImpl;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Protocol;
import org.apache.dubbo.rpc.ProxyFactory;

public class MetadataUtils {
    private static final Object REMOTE_LOCK = new Object();
    public static ConcurrentMap<String, MetadataService> metadataServiceProxies = new ConcurrentHashMap<String, MetadataService>();
    public static ConcurrentMap<String, Invoker<?>> metadataServiceInvokers = new ConcurrentHashMap();
    public static ConcurrentMap<String, Lock> metadataServiceLocks = new ConcurrentHashMap<String, Lock>();
    private static final ProxyFactory proxyFactory = (ProxyFactory)ExtensionLoader.getExtensionLoader(ProxyFactory.class).getAdaptiveExtension();
    private static final Protocol protocol = (Protocol)ExtensionLoader.getExtensionLoader(Protocol.class).getAdaptiveExtension();
    public static RemoteMetadataServiceImpl remoteMetadataService;
    public static WritableMetadataService localMetadataService;

    public static WritableMetadataService getLocalMetadataService() {
        if (localMetadataService == null) {
            localMetadataService = WritableMetadataService.getDefaultExtension();
        }
        return localMetadataService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RemoteMetadataServiceImpl getRemoteMetadataService() {
        if (remoteMetadataService == null) {
            Object object = REMOTE_LOCK;
            synchronized (object) {
                if (remoteMetadataService == null) {
                    remoteMetadataService = new RemoteMetadataServiceImpl(MetadataUtils.getLocalMetadataService());
                }
            }
        }
        return remoteMetadataService;
    }

    public static void publishServiceDefinition(URL url) {
        WritableMetadataService.getDefaultExtension().publishServiceDefinition(url);
        if ("remote".equalsIgnoreCase(url.getParameter("metadata-type"))) {
            MetadataUtils.getRemoteMetadataService().publishServiceDefinition(url);
        }
    }

    public static String computeKey(ServiceInstance serviceInstance) {
        return serviceInstance.getServiceName() + "##" + serviceInstance.getAddress() + "##" + ServiceInstanceMetadataUtils.getExportedServicesRevision(serviceInstance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MetadataService getMetadataServiceProxy(ServiceInstance instance, ServiceDiscovery serviceDiscovery) {
        String key = MetadataUtils.computeKey(instance);
        Lock lock = metadataServiceLocks.computeIfAbsent(key, k -> new ReentrantLock());
        lock.lock();
        try {
            MetadataService metadataService = metadataServiceProxies.computeIfAbsent(key, k -> MetadataUtils.referProxy(k, instance));
            return metadataService;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destroyMetadataServiceProxy(ServiceInstance instance, ServiceDiscovery serviceDiscovery) {
        String key = MetadataUtils.computeKey(instance);
        Lock lock = metadataServiceLocks.computeIfAbsent(key, k -> new ReentrantLock());
        lock.lock();
        try {
            if (metadataServiceProxies.containsKey(key)) {
                metadataServiceProxies.remove(key);
                Invoker invoker = (Invoker)metadataServiceInvokers.remove(key);
                invoker.destroy();
            }
        }
        finally {
            lock.unlock();
        }
    }

    private static MetadataService referProxy(String key, ServiceInstance instance) {
        MetadataServiceURLBuilder builder = null;
        ExtensionLoader loader = ExtensionLoader.getExtensionLoader(MetadataServiceURLBuilder.class);
        Map<String, String> metadata = instance.getMetadata();
        String dubboURLsJSON = metadata.get("dubbo.metadata-service.urls");
        builder = metadata.isEmpty() || StringUtils.isEmpty((String)dubboURLsJSON) ? (MetadataServiceURLBuilder)loader.getExtension("standard") : (MetadataServiceURLBuilder)loader.getExtension("spring-cloud");
        List<URL> urls = builder.build(instance);
        if (CollectionUtils.isEmpty(urls)) {
            throw new IllegalStateException("You have enabled introspection service discovery mode for instance " + instance + ", but no metadata service can build from it.");
        }
        Invoker invoker = protocol.refer(MetadataService.class, urls.get(0));
        metadataServiceInvokers.put(key, invoker);
        return (MetadataService)proxyFactory.getProxy(invoker);
    }

    public static void saveMetadataURL(URL url) {
        MetadataUtils.getLocalMetadataService().setMetadataServiceURL(url);
    }
}

