/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.client;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.config.configcenter.DynamicConfiguration;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.Assert;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.registry.AddressListener;
import org.apache.dubbo.registry.ProviderFirstParams;
import org.apache.dubbo.registry.client.InstanceAddressURL;
import org.apache.dubbo.registry.client.OverrideInstanceAddressURL;
import org.apache.dubbo.registry.integration.AbstractConfiguratorListener;
import org.apache.dubbo.registry.integration.DynamicDirectory;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Protocol;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcServiceContext;
import org.apache.dubbo.rpc.cluster.Configurator;
import org.apache.dubbo.rpc.cluster.Directory;
import org.apache.dubbo.rpc.cluster.RouterChain;
import org.apache.dubbo.rpc.cluster.router.state.BitList;
import org.apache.dubbo.rpc.model.ModuleModel;
import org.apache.dubbo.rpc.model.ScopeModel;
import org.apache.dubbo.rpc.model.ScopeModelUtil;

public class ServiceDiscoveryRegistryDirectory<T>
extends DynamicDirectory<T> {
    private static final Logger logger = LoggerFactory.getLogger(ServiceDiscoveryRegistryDirectory.class);
    private volatile Map<String, Invoker<T>> urlInvokerMap;
    private volatile ReferenceConfigurationListener referenceConfigurationListener;
    private volatile boolean enableConfigurationListen = true;
    private volatile List<URL> originalUrls = null;
    private volatile Map<String, String> overrideQueryMap;
    private final Set<String> providerFirstParams;
    private final ModuleModel moduleModel;

    public ServiceDiscoveryRegistryDirectory(Class<T> serviceType, URL url) {
        super(serviceType, url);
        this.moduleModel = ScopeModelUtil.getModuleModel((ScopeModel)url.getScopeModel());
        Set providerFirstParams = url.getOrDefaultApplicationModel().getExtensionLoader(ProviderFirstParams.class).getSupportedExtensionInstances();
        if (CollectionUtils.isEmpty((Collection)providerFirstParams)) {
            this.providerFirstParams = null;
        } else if (providerFirstParams.size() == 1) {
            this.providerFirstParams = Collections.unmodifiableSet(((ProviderFirstParams)providerFirstParams.iterator().next()).params());
        } else {
            ProviderFirstParams paramsFilter;
            HashSet<String> params = new HashSet<String>();
            Iterator iterator = providerFirstParams.iterator();
            while (iterator.hasNext() && (paramsFilter = (ProviderFirstParams)iterator.next()).params() != null) {
                params.addAll(paramsFilter.params());
            }
            this.providerFirstParams = Collections.unmodifiableSet(params);
        }
    }

    @Override
    public void subscribe(URL url) {
        if (((Boolean)this.moduleModel.getModelEnvironment().getConfiguration().convert(Boolean.class, "enable-configuration-listen", (Object)true)).booleanValue()) {
            this.enableConfigurationListen = true;
            this.getConsumerConfigurationListener(this.moduleModel).addNotifyListener(this);
            this.referenceConfigurationListener = new ReferenceConfigurationListener(this.moduleModel, this, url);
        } else {
            this.enableConfigurationListen = false;
        }
        super.subscribe(url);
    }

    private ConsumerConfigurationListener getConsumerConfigurationListener(ModuleModel moduleModel) {
        return (ConsumerConfigurationListener)moduleModel.getBeanFactory().getOrRegisterBean(ConsumerConfigurationListener.class, type -> new ConsumerConfigurationListener(moduleModel));
    }

    @Override
    public void unSubscribe(URL url) {
        super.unSubscribe(url);
        this.originalUrls = null;
        if (((Boolean)this.moduleModel.getModelEnvironment().getConfiguration().convert(Boolean.class, "enable-configuration-listen", (Object)true)).booleanValue()) {
            this.getConsumerConfigurationListener(this.moduleModel).removeNotifyListener(this);
            this.referenceConfigurationListener.stop();
        }
    }

    @Override
    public void buildRouterChain(URL url) {
        this.setRouterChain(RouterChain.buildChain(this.getInterface(), (URL)url.addParameter("registry-type", "service")));
    }

    @Override
    public synchronized void notify(List<URL> instanceUrls) {
        if (this.isDestroyed()) {
            return;
        }
        RpcServiceContext.setRpcContext((URL)this.getConsumerUrl());
        ExtensionLoader addressListenerExtensionLoader = this.getUrl().getOrDefaultModuleModel().getExtensionLoader(AddressListener.class);
        List supportedListeners = addressListenerExtensionLoader.getActivateExtension(this.getUrl(), (String[])null);
        if (supportedListeners != null && !supportedListeners.isEmpty()) {
            for (AddressListener addressListener : supportedListeners) {
                instanceUrls = addressListener.notify(instanceUrls, this.getConsumerUrl(), (Directory)this);
            }
        }
        this.refreshOverrideAndInvoker(instanceUrls);
    }

    private synchronized void refreshOverrideAndInvoker(List<URL> instanceUrls) {
        this.refreshInvoker(instanceUrls);
    }

    private InstanceAddressURL overrideWithConfigurator(InstanceAddressURL providerUrl) {
        providerUrl = this.overrideWithConfigurators(this.getConsumerConfigurationListener(this.moduleModel).getConfigurators(), providerUrl);
        if (this.referenceConfigurationListener != null) {
            providerUrl = this.overrideWithConfigurators(this.referenceConfigurationListener.getConfigurators(), providerUrl);
        }
        return providerUrl;
    }

    private InstanceAddressURL overrideWithConfigurators(List<Configurator> configurators, InstanceAddressURL url) {
        if (CollectionUtils.isNotEmpty(configurators)) {
            OverrideInstanceAddressURL overrideInstanceAddressURL = new OverrideInstanceAddressURL(url);
            if (this.overrideQueryMap != null) {
                overrideInstanceAddressURL = (OverrideInstanceAddressURL)overrideInstanceAddressURL.addParameters(this.overrideQueryMap);
            }
            for (Configurator configurator : configurators) {
                overrideInstanceAddressURL = (OverrideInstanceAddressURL)configurator.configure((URL)overrideInstanceAddressURL);
            }
            return overrideInstanceAddressURL;
        }
        return url;
    }

    public boolean isServiceDiscovery() {
        return true;
    }

    @Override
    public boolean isNotificationReceived() {
        return this.serviceListener == null || this.serviceListener.isDestroyed() || this.serviceListener.getAllInstances().size() == this.serviceListener.getServiceNames().size();
    }

    private void refreshInvoker(List<URL> invokerUrls) {
        Assert.notNull(invokerUrls, (String)"invokerUrls should not be null, use EMPTY url to clear current addresses.");
        this.originalUrls = invokerUrls;
        if (invokerUrls.size() == 1 && "empty".equals(invokerUrls.get(0).getProtocol())) {
            logger.warn("Received url with EMPTY protocol, will clear all available addresses.");
            this.forbidden = true;
            this.routerChain.setInvokers(BitList.emptyList());
            this.destroyAllInvokers();
        } else {
            this.forbidden = false;
            if (CollectionUtils.isEmpty(invokerUrls)) {
                logger.warn("Received empty url list, will ignore for protection purpose.");
                return;
            }
            Map<String, Invoker<T>> localUrlInvokerMap = this.urlInvokerMap;
            LinkedHashMap<String, Invoker<T>> oldUrlInvokerMap = null;
            if (localUrlInvokerMap != null) {
                oldUrlInvokerMap = new LinkedHashMap<String, Invoker<T>>(Math.round(1.0f + (float)localUrlInvokerMap.size() / 0.75f));
                localUrlInvokerMap.forEach(oldUrlInvokerMap::put);
            }
            Map<String, Invoker<T>> newUrlInvokerMap = this.toInvokers(oldUrlInvokerMap, invokerUrls);
            logger.info("Refreshed invoker size " + newUrlInvokerMap.size());
            if (CollectionUtils.isEmptyMap(newUrlInvokerMap)) {
                logger.error((Throwable)new IllegalStateException("Cannot create invokers from url address list (total " + invokerUrls.size() + ")"));
                return;
            }
            List<Invoker<T>> newInvokers = Collections.unmodifiableList(new ArrayList<Invoker<T>>(newUrlInvokerMap.values()));
            this.setInvokers(this.multiGroup ? new BitList(this.toMergeInvokerList(newInvokers)) : new BitList(newInvokers));
            this.routerChain.setInvokers(this.getInvokers());
            this.urlInvokerMap = newUrlInvokerMap;
            if (oldUrlInvokerMap != null) {
                try {
                    this.destroyUnusedInvokers(oldUrlInvokerMap, newUrlInvokerMap);
                }
                catch (Exception e) {
                    logger.warn("destroyUnusedInvokers error. ", (Throwable)e);
                }
            }
        }
        this.invokersChanged();
    }

    private Map<String, Invoker<T>> toInvokers(Map<String, Invoker<T>> oldUrlInvokerMap, List<URL> urls) {
        ConcurrentHashMap<String, Invoker<T>> newUrlInvokerMap = new ConcurrentHashMap<String, Invoker<T>>(urls == null ? 1 : (int)((float)urls.size() / 0.75f + 1.0f));
        if (urls == null || urls.isEmpty()) {
            return newUrlInvokerMap;
        }
        for (URL url : urls) {
            Invoker invoker;
            InstanceAddressURL instanceAddressURL = (InstanceAddressURL)url;
            if ("empty".equals(instanceAddressURL.getProtocol())) continue;
            if (!this.getUrl().getOrDefaultFrameworkModel().getExtensionLoader(Protocol.class).hasExtension(instanceAddressURL.getProtocol())) {
                logger.error((Throwable)new IllegalStateException("Unsupported protocol " + instanceAddressURL.getProtocol() + " in notified url: " + (Object)((Object)instanceAddressURL) + " from registry " + this.getUrl().getAddress() + " to consumer " + NetUtils.getLocalHost() + ", supported protocol: " + this.getUrl().getOrDefaultFrameworkModel().getExtensionLoader(Protocol.class).getSupportedExtensions()));
                continue;
            }
            instanceAddressURL.setProviderFirstParams(this.providerFirstParams);
            if (this.enableConfigurationListen) {
                instanceAddressURL = this.overrideWithConfigurator(instanceAddressURL);
            }
            Invoker invoker2 = invoker = oldUrlInvokerMap == null ? null : oldUrlInvokerMap.get(instanceAddressURL.getAddress());
            if (invoker == null || this.urlChanged(invoker, instanceAddressURL)) {
                try {
                    boolean enabled = true;
                    enabled = instanceAddressURL.hasParameter("disabled") ? !instanceAddressURL.getParameter("disabled", false) : instanceAddressURL.getParameter("enabled", true);
                    if (enabled) {
                        invoker = this.protocol.refer(this.serviceType, (URL)instanceAddressURL);
                    }
                }
                catch (Throwable t) {
                    logger.error("Failed to refer invoker for interface:" + this.serviceType + ",url:(" + (Object)((Object)instanceAddressURL) + ")" + t.getMessage(), t);
                }
                if (invoker == null) continue;
                newUrlInvokerMap.put(instanceAddressURL.getAddress(), invoker);
                continue;
            }
            newUrlInvokerMap.put(instanceAddressURL.getAddress(), invoker);
            oldUrlInvokerMap.remove(instanceAddressURL.getAddress(), invoker);
        }
        return newUrlInvokerMap;
    }

    private boolean urlChanged(Invoker<T> invoker, InstanceAddressURL newURL) {
        InstanceAddressURL oldURL = (InstanceAddressURL)invoker.getUrl();
        if (!newURL.getInstance().equals(oldURL.getInstance())) {
            return true;
        }
        if (oldURL instanceof OverrideInstanceAddressURL || newURL instanceof OverrideInstanceAddressURL) {
            if (!(oldURL instanceof OverrideInstanceAddressURL) || !(newURL instanceof OverrideInstanceAddressURL)) {
                return true;
            }
            if (!((OverrideInstanceAddressURL)oldURL).getOverrideParams().equals((Object)((OverrideInstanceAddressURL)newURL).getOverrideParams())) {
                return true;
            }
        }
        return !oldURL.getMetadataInfo().getServiceInfo(this.getConsumerUrl().getProtocolServiceKey()).equals((Object)newURL.getMetadataInfo().getServiceInfo(this.getConsumerUrl().getProtocolServiceKey()));
    }

    private List<Invoker<T>> toMergeInvokerList(List<Invoker<T>> invokers) {
        return invokers;
    }

    @Override
    protected void destroyAllInvokers() {
        Map<String, Invoker<T>> localUrlInvokerMap = this.urlInvokerMap;
        if (localUrlInvokerMap != null) {
            for (Invoker<T> invoker : new ArrayList<Invoker<T>>(localUrlInvokerMap.values())) {
                try {
                    invoker.destroyAll();
                }
                catch (Throwable t) {
                    logger.warn("Failed to destroy service " + this.serviceKey + " to provider " + invoker.getUrl(), t);
                }
            }
            localUrlInvokerMap.clear();
        }
        this.urlInvokerMap = null;
        this.destroyInvokers();
    }

    private void destroyUnusedInvokers(Map<String, Invoker<T>> oldUrlInvokerMap, Map<String, Invoker<T>> newUrlInvokerMap) {
        if (newUrlInvokerMap == null || newUrlInvokerMap.size() == 0) {
            this.destroyAllInvokers();
            return;
        }
        if (oldUrlInvokerMap == null || oldUrlInvokerMap.size() == 0) {
            return;
        }
        for (Map.Entry<String, Invoker<T>> entry : oldUrlInvokerMap.entrySet()) {
            Invoker<T> invoker = entry.getValue();
            if (invoker == null) continue;
            try {
                invoker.destroyAll();
                if (!logger.isDebugEnabled()) continue;
                logger.debug("destroy invoker[" + invoker.getUrl() + "] success. ");
            }
            catch (Exception e) {
                logger.warn("destroy invoker[" + invoker.getUrl() + "] failed. " + e.getMessage(), (Throwable)e);
            }
        }
        logger.info(oldUrlInvokerMap.size() + " deprecated invokers deleted.");
    }

    private static class ConsumerConfigurationListener
    extends AbstractConfiguratorListener {
        private final List<ServiceDiscoveryRegistryDirectory<?>> listeners = new ArrayList();

        ConsumerConfigurationListener(ModuleModel moduleModel) {
            super(moduleModel);
        }

        void addNotifyListener(ServiceDiscoveryRegistryDirectory<?> listener) {
            if (this.listeners.size() == 0) {
                this.initWith(this.moduleModel.getApplicationModel().getApplicationName() + ".configurators");
            }
            this.listeners.add(listener);
        }

        void removeNotifyListener(ServiceDiscoveryRegistryDirectory<?> listener) {
            this.listeners.remove(listener);
            if (this.listeners.size() == 0) {
                this.stopListen(this.moduleModel.getApplicationModel().getApplicationName() + ".configurators");
            }
        }

        @Override
        protected void notifyOverrides() {
            this.listeners.forEach(listener -> {
                if (((ServiceDiscoveryRegistryDirectory)listener).originalUrls != null) {
                    URL backup = RpcContext.getServiceContext().getConsumerUrl();
                    RpcContext.getServiceContext().setConsumerUrl(listener.getConsumerUrl());
                    ((ServiceDiscoveryRegistryDirectory)listener).refreshOverrideAndInvoker(((ServiceDiscoveryRegistryDirectory)listener).originalUrls);
                    RpcContext.getServiceContext().setConsumerUrl(backup);
                }
            });
        }
    }

    private class ReferenceConfigurationListener
    extends AbstractConfiguratorListener {
        private final ServiceDiscoveryRegistryDirectory<?> directory;
        private final URL url;

        ReferenceConfigurationListener(ModuleModel moduleModel, ServiceDiscoveryRegistryDirectory<?> directory, URL url) {
            super(moduleModel);
            this.directory = directory;
            this.url = url;
            this.initWith(DynamicConfiguration.getRuleKey((URL)url) + ".configurators");
        }

        void stop() {
            this.stopListen(DynamicConfiguration.getRuleKey((URL)this.url) + ".configurators");
        }

        @Override
        protected void notifyOverrides() {
            if (((ServiceDiscoveryRegistryDirectory)this.directory).originalUrls != null) {
                URL backup = RpcContext.getServiceContext().getConsumerUrl();
                RpcContext.getServiceContext().setConsumerUrl(this.directory.getConsumerUrl());
                ((ServiceDiscoveryRegistryDirectory)this.directory).refreshOverrideAndInvoker(((ServiceDiscoveryRegistryDirectory)this.directory).originalUrls);
                RpcContext.getServiceContext().setConsumerUrl(backup);
            }
        }
    }
}

