/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.config.ConfigurationUtils;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.model.ScopeModel;

public class ReferenceCountInvokerWrapper<T>
implements Invoker<T> {
    private final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(ReferenceCountInvokerWrapper.class);
    private final Invoker<T> invoker;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final AtomicBoolean destroyed = new AtomicBoolean(false);

    public ReferenceCountInvokerWrapper(Invoker<T> invoker) {
        this.invoker = invoker;
    }

    public URL getUrl() {
        return this.invoker.getUrl();
    }

    public boolean isAvailable() {
        return !this.destroyed.get() && this.invoker.isAvailable();
    }

    public void destroy() {
        try {
            int timeout = ConfigurationUtils.getServerShutdownTimeout((ScopeModel)this.invoker.getUrl().getScopeModel());
            boolean locked = this.lock.writeLock().tryLock(timeout, TimeUnit.MILLISECONDS);
            if (!locked) {
                this.logger.warn("4-16", "", "", "Failed to wait for invocation end in " + timeout + "ms.");
            }
            this.destroyed.set(true);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            this.lock.writeLock().unlock();
        }
        this.invoker.destroy();
    }

    @Override
    public Class<T> getInterface() {
        return this.invoker.getInterface();
    }

    @Override
    public Result invoke(Invocation invocation) throws RpcException {
        try {
            this.lock.readLock().lock();
            if (this.destroyed.get()) {
                this.logger.warn("4-16", "", "", "Remote invoker has been destroyed, and unable to invoke anymore.");
                throw new RpcException("This invoker has been destroyed!");
            }
            Result result = this.invoker.invoke(invocation);
            return result;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Invoker<T> getInvoker() {
        return this.invoker;
    }
}

