/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.csv;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.formats.csv.CsvFormatOptions;
import org.apache.flink.table.api.ValidationException;

class CsvCommons {
    public static final String IDENTIFIER = "csv";

    CsvCommons() {
    }

    static void validateFormatOptions(ReadableConfig tableOptions) {
        boolean hasQuoteCharacter = tableOptions.getOptional(CsvFormatOptions.QUOTE_CHARACTER).isPresent();
        boolean isDisabledQuoteCharacter = (Boolean)tableOptions.get(CsvFormatOptions.DISABLE_QUOTE_CHARACTER);
        if (isDisabledQuoteCharacter && hasQuoteCharacter) {
            throw new ValidationException("Format cannot define a quote character and disabled quote character at the same time.");
        }
        CsvCommons.validateCharacterVal(tableOptions, CsvFormatOptions.FIELD_DELIMITER, true);
        CsvCommons.validateCharacterVal(tableOptions, CsvFormatOptions.ARRAY_ELEMENT_DELIMITER);
        CsvCommons.validateCharacterVal(tableOptions, CsvFormatOptions.QUOTE_CHARACTER);
        CsvCommons.validateCharacterVal(tableOptions, CsvFormatOptions.ESCAPE_CHARACTER);
    }

    private static void validateCharacterVal(ReadableConfig tableOptions, ConfigOption<String> option) {
        CsvCommons.validateCharacterVal(tableOptions, option, false);
    }

    private static void validateCharacterVal(ReadableConfig tableOptions, ConfigOption<String> option, boolean unescape) {
        String value;
        if (!tableOptions.getOptional(option).isPresent()) {
            return;
        }
        String string = value = unescape ? StringEscapeUtils.unescapeJava((String)((String)tableOptions.get(option))) : (String)tableOptions.get(option);
        if (value.length() != 1) {
            throw new ValidationException(String.format("Option '%s.%s' must be a string with single character, but was: %s", IDENTIFIER, option.key(), tableOptions.get(option)));
        }
    }

    public static Set<ConfigOption<?>> optionalOptions() {
        HashSet options = new HashSet();
        options.add(CsvFormatOptions.FIELD_DELIMITER);
        options.add(CsvFormatOptions.DISABLE_QUOTE_CHARACTER);
        options.add(CsvFormatOptions.QUOTE_CHARACTER);
        options.add(CsvFormatOptions.ALLOW_COMMENTS);
        options.add(CsvFormatOptions.IGNORE_PARSE_ERRORS);
        options.add(CsvFormatOptions.ARRAY_ELEMENT_DELIMITER);
        options.add(CsvFormatOptions.ESCAPE_CHARACTER);
        options.add(CsvFormatOptions.NULL_LITERAL);
        return options;
    }

    public static Set<ConfigOption<?>> forwardOptions() {
        HashSet options = new HashSet();
        options.add(CsvFormatOptions.FIELD_DELIMITER);
        options.add(CsvFormatOptions.DISABLE_QUOTE_CHARACTER);
        options.add(CsvFormatOptions.QUOTE_CHARACTER);
        options.add(CsvFormatOptions.ALLOW_COMMENTS);
        options.add(CsvFormatOptions.ARRAY_ELEMENT_DELIMITER);
        options.add(CsvFormatOptions.ESCAPE_CHARACTER);
        options.add(CsvFormatOptions.NULL_LITERAL);
        return options;
    }
}

