/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.csv;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import org.apache.flink.annotation.Internal;
import org.apache.flink.formats.common.Converter;
import org.apache.flink.formats.common.TimeFormats;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.ArrayNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.ContainerNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.dataformat.csv.CsvMapper;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LocalZonedTimestampType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.TimestampType;

@Internal
public class RowDataToCsvConverters
implements Serializable {
    private static final long serialVersionUID = 1L;

    public static RowDataToCsvConverter createRowConverter(RowType type) {
        LogicalType[] fieldTypes = (LogicalType[])type.getFields().stream().map(RowType.RowField::getType).toArray(LogicalType[]::new);
        String[] fieldNames = type.getFieldNames().toArray(new String[0]);
        RowFieldConverter[] fieldConverters = (RowFieldConverter[])Arrays.stream(fieldTypes).map(RowDataToCsvConverters::createNullableRowFieldConverter).toArray(RowFieldConverter[]::new);
        int rowArity = type.getFieldCount();
        return (row, context) -> {
            ObjectNode objectNode = (ObjectNode)context.container;
            for (int i = 0; i < rowArity; ++i) {
                try {
                    objectNode.set(fieldNames[i], fieldConverters[i].convert(context.csvMapper, context.container, (RowData)row, i));
                    continue;
                }
                catch (Throwable t) {
                    throw new RuntimeException(String.format("Fail to serialize at field: %s.", fieldNames[i]), t);
                }
            }
            return objectNode;
        };
    }

    private static RowFieldConverter createNullableRowFieldConverter(LogicalType fieldType) {
        RowFieldConverter fieldConverter = RowDataToCsvConverters.createRowFieldConverter(fieldType);
        return (csvMapper, container, row, pos) -> {
            if (row.isNullAt(pos)) {
                return container.nullNode();
            }
            return fieldConverter.convert(csvMapper, container, row, pos);
        };
    }

    private static RowFieldConverter createRowFieldConverter(LogicalType fieldType) {
        switch (fieldType.getTypeRoot()) {
            case NULL: {
                return (csvMapper, container, row, pos) -> container.nullNode();
            }
            case BOOLEAN: {
                return (csvMapper, container, row, pos) -> container.booleanNode(row.getBoolean(pos));
            }
            case TINYINT: {
                return (csvMapper, container, row, pos) -> container.numberNode(row.getByte(pos));
            }
            case SMALLINT: {
                return (csvMapper, container, row, pos) -> container.numberNode(row.getShort(pos));
            }
            case INTEGER: 
            case INTERVAL_YEAR_MONTH: {
                return (csvMapper, container, row, pos) -> container.numberNode(row.getInt(pos));
            }
            case BIGINT: 
            case INTERVAL_DAY_TIME: {
                return (csvMapper, container, row, pos) -> container.numberNode(row.getLong(pos));
            }
            case FLOAT: {
                return (csvMapper, container, row, pos) -> container.numberNode(row.getFloat(pos));
            }
            case DOUBLE: {
                return (csvMapper, container, row, pos) -> container.numberNode(row.getDouble(pos));
            }
            case CHAR: 
            case VARCHAR: {
                return (csvMapper, container, row, pos) -> container.textNode(row.getString(pos).toString());
            }
            case BINARY: 
            case VARBINARY: {
                return (csvMapper, container, row, pos) -> container.binaryNode(row.getBinary(pos));
            }
            case DATE: {
                return (csvMapper, container, row, pos) -> RowDataToCsvConverters.convertDate(row.getInt(pos), container);
            }
            case TIME_WITHOUT_TIME_ZONE: {
                return (csvMapper, container, row, pos) -> RowDataToCsvConverters.convertTime(row.getInt(pos), container);
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                int timestampPrecision = ((TimestampType)fieldType).getPrecision();
                return (csvMapper, container, row, pos) -> RowDataToCsvConverters.convertTimestamp(row.getTimestamp(pos, timestampPrecision), container, TimeFormats.SQL_TIMESTAMP_FORMAT);
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                int zonedTimestampPrecision = ((LocalZonedTimestampType)fieldType).getPrecision();
                return (csvMapper, container, row, pos) -> RowDataToCsvConverters.convertTimestamp(row.getTimestamp(pos, zonedTimestampPrecision), container, TimeFormats.SQL_TIMESTAMP_WITH_LOCAL_TIMEZONE_FORMAT);
            }
            case DECIMAL: {
                return RowDataToCsvConverters.createDecimalRowFieldConverter((DecimalType)fieldType);
            }
            case ARRAY: {
                return RowDataToCsvConverters.createArrayRowFieldConverter((ArrayType)fieldType);
            }
            case ROW: {
                return RowDataToCsvConverters.createRowRowFieldConverter((RowType)fieldType);
            }
        }
        throw new UnsupportedOperationException("Unsupported type: " + fieldType);
    }

    private static ArrayElementConverter createNullableArrayElementConverter(LogicalType fieldType) {
        ArrayElementConverter elementConverter = RowDataToCsvConverters.createArrayElementConverter(fieldType);
        return (csvMapper, container, array, pos) -> {
            if (array.isNullAt(pos)) {
                return container.nullNode();
            }
            return elementConverter.convert(csvMapper, container, array, pos);
        };
    }

    private static ArrayElementConverter createArrayElementConverter(LogicalType fieldType) {
        switch (fieldType.getTypeRoot()) {
            case NULL: {
                return (csvMapper, container, array, pos) -> container.nullNode();
            }
            case BOOLEAN: {
                return (csvMapper, container, array, pos) -> container.booleanNode(array.getBoolean(pos));
            }
            case TINYINT: {
                return (csvMapper, container, array, pos) -> container.numberNode(array.getByte(pos));
            }
            case SMALLINT: {
                return (csvMapper, container, array, pos) -> container.numberNode(array.getShort(pos));
            }
            case INTEGER: 
            case INTERVAL_YEAR_MONTH: {
                return (csvMapper, container, array, pos) -> container.numberNode(array.getInt(pos));
            }
            case BIGINT: 
            case INTERVAL_DAY_TIME: {
                return (csvMapper, container, array, pos) -> container.numberNode(array.getLong(pos));
            }
            case FLOAT: {
                return (csvMapper, container, array, pos) -> container.numberNode(array.getFloat(pos));
            }
            case DOUBLE: {
                return (csvMapper, container, array, pos) -> container.numberNode(array.getDouble(pos));
            }
            case CHAR: 
            case VARCHAR: {
                return (csvMapper, container, array, pos) -> container.textNode(array.getString(pos).toString());
            }
            case BINARY: 
            case VARBINARY: {
                return (csvMapper, container, array, pos) -> container.binaryNode(array.getBinary(pos));
            }
            case DATE: {
                return (csvMapper, container, array, pos) -> RowDataToCsvConverters.convertDate(array.getInt(pos), container);
            }
            case TIME_WITHOUT_TIME_ZONE: {
                return (csvMapper, container, array, pos) -> RowDataToCsvConverters.convertTime(array.getInt(pos), container);
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                int timestampPrecision = ((TimestampType)fieldType).getPrecision();
                return (csvMapper, container, array, pos) -> RowDataToCsvConverters.convertTimestamp(array.getTimestamp(pos, timestampPrecision), container, TimeFormats.SQL_TIMESTAMP_FORMAT);
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                int localZonedTimestampPrecision = ((LocalZonedTimestampType)fieldType).getPrecision();
                return (csvMapper, container, array, pos) -> RowDataToCsvConverters.convertTimestamp(array.getTimestamp(pos, localZonedTimestampPrecision), container, TimeFormats.SQL_TIMESTAMP_WITH_LOCAL_TIMEZONE_FORMAT);
            }
            case DECIMAL: {
                return RowDataToCsvConverters.createDecimalArrayElementConverter((DecimalType)fieldType);
            }
        }
        throw new UnsupportedOperationException("Unsupported type: " + fieldType);
    }

    private static RowFieldConverter createDecimalRowFieldConverter(DecimalType decimalType) {
        int precision = decimalType.getPrecision();
        int scale = decimalType.getScale();
        return (csvMapper, container, row, pos) -> {
            DecimalData decimal = row.getDecimal(pos, precision, scale);
            return RowDataToCsvConverters.convertDecimal(decimal, container);
        };
    }

    private static ArrayElementConverter createDecimalArrayElementConverter(DecimalType decimalType) {
        int precision = decimalType.getPrecision();
        int scale = decimalType.getScale();
        return (csvMapper, container, array, pos) -> {
            DecimalData decimal = array.getDecimal(pos, precision, scale);
            return RowDataToCsvConverters.convertDecimal(decimal, container);
        };
    }

    private static JsonNode convertDecimal(DecimalData decimal, ContainerNode<?> container) {
        return container.numberNode(decimal.toBigDecimal());
    }

    private static JsonNode convertDate(int days, ContainerNode<?> container) {
        LocalDate date = LocalDate.ofEpochDay(days);
        return container.textNode(DateTimeFormatter.ISO_LOCAL_DATE.format(date));
    }

    private static JsonNode convertTime(int millisecond, ContainerNode<?> container) {
        LocalTime time = LocalTime.ofNanoOfDay((long)millisecond * 1000000L);
        return container.textNode(DateTimeFormatter.ISO_LOCAL_TIME.format(time));
    }

    private static JsonNode convertTimestamp(TimestampData timestamp, ContainerNode<?> container, DateTimeFormatter formatter) {
        return container.textNode(formatter.format(timestamp.toLocalDateTime()));
    }

    private static RowFieldConverter createArrayRowFieldConverter(ArrayType type) {
        LogicalType elementType = type.getElementType();
        ArrayElementConverter elementConverter = RowDataToCsvConverters.createNullableArrayElementConverter(elementType);
        return (csvMapper, container, row, pos) -> {
            ArrayNode arrayNode = csvMapper.createArrayNode();
            ArrayData arrayData = row.getArray(pos);
            int numElements = arrayData.size();
            for (int i = 0; i < numElements; ++i) {
                arrayNode.add(elementConverter.convert(csvMapper, (ContainerNode<?>)arrayNode, arrayData, i));
            }
            return arrayNode;
        };
    }

    private static RowFieldConverter createRowRowFieldConverter(RowType type) {
        LogicalType[] fieldTypes = (LogicalType[])type.getFields().stream().map(RowType.RowField::getType).toArray(LogicalType[]::new);
        RowFieldConverter[] fieldConverters = (RowFieldConverter[])Arrays.stream(fieldTypes).map(RowDataToCsvConverters::createNullableRowFieldConverter).toArray(RowFieldConverter[]::new);
        int rowArity = type.getFieldCount();
        return (csvMapper, container, row, pos) -> {
            RowData value = row.getRow(pos, rowArity);
            ArrayNode arrayNode = csvMapper.createArrayNode();
            for (int i = 0; i < rowArity; ++i) {
                arrayNode.add(fieldConverters[i].convert(csvMapper, (ContainerNode<?>)arrayNode, value, i));
            }
            return arrayNode;
        };
    }

    private static interface ArrayElementConverter
    extends Serializable {
        public JsonNode convert(CsvMapper var1, ContainerNode<?> var2, ArrayData var3, int var4);
    }

    private static interface RowFieldConverter
    extends Serializable {
        public JsonNode convert(CsvMapper var1, ContainerNode<?> var2, RowData var3, int var4);
    }

    static interface RowDataToCsvConverter
    extends Converter<RowData, JsonNode, RowDataToCsvFormatConverterContext> {

        public static class RowDataToCsvFormatConverterContext
        implements Serializable {
            CsvMapper csvMapper;
            ContainerNode<?> container;

            public RowDataToCsvFormatConverterContext(CsvMapper csvMapper, ContainerNode<?> container) {
                this.csvMapper = csvMapper;
                this.container = container;
            }
        }
    }
}

