/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.contrib.streaming.state.snapshot;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.contrib.streaming.state.RocksDBKeyedStateBackend;
import org.apache.flink.contrib.streaming.state.RocksDBStateUploader;
import org.apache.flink.contrib.streaming.state.snapshot.RocksDBSnapshotStrategyBase;
import org.apache.flink.core.fs.CloseableRegistry;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.runtime.checkpoint.CheckpointOptions;
import org.apache.flink.runtime.checkpoint.SnapshotType;
import org.apache.flink.runtime.state.CheckpointStreamFactory;
import org.apache.flink.runtime.state.CheckpointStreamWithResultProvider;
import org.apache.flink.runtime.state.CheckpointedStateScope;
import org.apache.flink.runtime.state.DirectoryStateHandle;
import org.apache.flink.runtime.state.IncrementalLocalKeyedStateHandle;
import org.apache.flink.runtime.state.IncrementalRemoteKeyedStateHandle;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.KeyedBackendSerializationProxy;
import org.apache.flink.runtime.state.KeyedStateHandle;
import org.apache.flink.runtime.state.LocalRecoveryConfig;
import org.apache.flink.runtime.state.LocalRecoveryDirectoryProvider;
import org.apache.flink.runtime.state.PlaceholderStreamStateHandle;
import org.apache.flink.runtime.state.SnapshotDirectory;
import org.apache.flink.runtime.state.SnapshotResources;
import org.apache.flink.runtime.state.SnapshotResult;
import org.apache.flink.runtime.state.SnapshotStrategy;
import org.apache.flink.runtime.state.StateHandleID;
import org.apache.flink.runtime.state.StateObject;
import org.apache.flink.runtime.state.StateUtil;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.runtime.state.metainfo.StateMetaInfoSnapshot;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.FileUtils;
import org.apache.flink.util.IOUtils;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.ResourceGuard;
import org.rocksdb.Checkpoint;
import org.rocksdb.RocksDB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocksIncrementalSnapshotStrategy<K>
extends RocksDBSnapshotStrategyBase<K, IncrementalRocksDBSnapshotResources> {
    private static final Logger LOG = LoggerFactory.getLogger(RocksIncrementalSnapshotStrategy.class);
    private static final String DESCRIPTION = "Asynchronous incremental RocksDB snapshot";
    @Nonnull
    private final File instanceBasePath;
    @Nonnull
    private final UUID backendUID;
    @Nonnull
    private final SortedMap<Long, Map<StateHandleID, Long>> uploadedStateIDs;
    private long lastCompletedCheckpointId;
    private final RocksDBStateUploader stateUploader;
    private final String localDirectoryName;
    private static final PreviousSnapshot EMPTY_PREVIOUS_SNAPSHOT = new PreviousSnapshot(Collections.emptyMap());

    public RocksIncrementalSnapshotStrategy(@Nonnull RocksDB db, @Nonnull ResourceGuard rocksDBResourceGuard, @Nonnull TypeSerializer<K> keySerializer, @Nonnull LinkedHashMap<String, RocksDBKeyedStateBackend.RocksDbKvStateInfo> kvStateInformation, @Nonnull KeyGroupRange keyGroupRange, @Nonnegative int keyGroupPrefixBytes, @Nonnull LocalRecoveryConfig localRecoveryConfig, @Nonnull CloseableRegistry cancelStreamRegistry, @Nonnull File instanceBasePath, @Nonnull UUID backendUID, @Nonnull SortedMap<Long, Map<StateHandleID, StreamStateHandle>> uploadedStateHandles, @Nonnull RocksDBStateUploader rocksDBStateUploader, long lastCompletedCheckpointId) {
        super(DESCRIPTION, db, rocksDBResourceGuard, keySerializer, kvStateInformation, keyGroupRange, keyGroupPrefixBytes, localRecoveryConfig);
        this.instanceBasePath = instanceBasePath;
        this.backendUID = backendUID;
        this.uploadedStateIDs = new TreeMap<Long, Map<StateHandleID, Long>>();
        for (Map.Entry<Long, Map<StateHandleID, StreamStateHandle>> entry : uploadedStateHandles.entrySet()) {
            HashMap<StateHandleID, Long> map = new HashMap<StateHandleID, Long>();
            for (Map.Entry<StateHandleID, StreamStateHandle> stateHandleEntry : entry.getValue().entrySet()) {
                map.put(stateHandleEntry.getKey(), stateHandleEntry.getValue().getStateSize());
            }
            this.uploadedStateIDs.put(entry.getKey(), map);
        }
        this.stateUploader = rocksDBStateUploader;
        this.lastCompletedCheckpointId = lastCompletedCheckpointId;
        this.localDirectoryName = backendUID.toString().replaceAll("[\\-]", "");
    }

    public IncrementalRocksDBSnapshotResources syncPrepareResources(long checkpointId) throws Exception {
        SnapshotDirectory snapshotDirectory = this.prepareLocalSnapshotDirectory(checkpointId);
        LOG.trace("Local RocksDB checkpoint goes to backup path {}.", (Object)snapshotDirectory);
        ArrayList<StateMetaInfoSnapshot> stateMetaInfoSnapshots = new ArrayList<StateMetaInfoSnapshot>(this.kvStateInformation.size());
        PreviousSnapshot previousSnapshot = this.snapshotMetaData(checkpointId, stateMetaInfoSnapshots);
        this.takeDBNativeCheckpoint(snapshotDirectory);
        return new IncrementalRocksDBSnapshotResources(snapshotDirectory, previousSnapshot, stateMetaInfoSnapshots);
    }

    public SnapshotStrategy.SnapshotResultSupplier<KeyedStateHandle> asyncSnapshot(IncrementalRocksDBSnapshotResources snapshotResources, long checkpointId, long timestamp, @Nonnull CheckpointStreamFactory checkpointStreamFactory, @Nonnull CheckpointOptions checkpointOptions) {
        PreviousSnapshot previousSnapshot;
        if (snapshotResources.stateMetaInfoSnapshots.isEmpty()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Asynchronous RocksDB snapshot performed on empty keyed state at {}. Returning null.", (Object)timestamp);
            }
            return registry -> SnapshotResult.empty();
        }
        SnapshotType.SharingFilesStrategy sharingFilesStrategy = checkpointOptions.getCheckpointType().getSharingFilesStrategy();
        switch (sharingFilesStrategy) {
            case FORWARD_BACKWARD: {
                previousSnapshot = snapshotResources.previousSnapshot;
                break;
            }
            case FORWARD: 
            case NO_SHARING: {
                previousSnapshot = EMPTY_PREVIOUS_SNAPSHOT;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported sharing files strategy: " + sharingFilesStrategy);
            }
        }
        return new RocksDBIncrementalSnapshotOperation(checkpointId, checkpointStreamFactory, snapshotResources.snapshotDirectory, previousSnapshot, sharingFilesStrategy, snapshotResources.stateMetaInfoSnapshots);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyCheckpointComplete(long completedCheckpointId) {
        SortedMap<Long, Map<StateHandleID, Long>> sortedMap = this.uploadedStateIDs;
        synchronized (sortedMap) {
            if (completedCheckpointId > this.lastCompletedCheckpointId && this.uploadedStateIDs.containsKey(completedCheckpointId)) {
                this.uploadedStateIDs.keySet().removeIf(checkpointId -> checkpointId < completedCheckpointId);
                this.lastCompletedCheckpointId = completedCheckpointId;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyCheckpointAborted(long abortedCheckpointId) {
        SortedMap<Long, Map<StateHandleID, Long>> sortedMap = this.uploadedStateIDs;
        synchronized (sortedMap) {
            this.uploadedStateIDs.keySet().remove(abortedCheckpointId);
        }
    }

    @Override
    public void close() {
        this.stateUploader.close();
    }

    @Nonnull
    private SnapshotDirectory prepareLocalSnapshotDirectory(long checkpointId) throws IOException {
        if (this.localRecoveryConfig.isLocalRecoveryEnabled()) {
            LocalRecoveryDirectoryProvider directoryProvider = (LocalRecoveryDirectoryProvider)this.localRecoveryConfig.getLocalStateDirectoryProvider().orElseThrow(LocalRecoveryConfig.localRecoveryNotEnabled());
            File directory = directoryProvider.subtaskSpecificCheckpointDirectory(checkpointId);
            if (!directory.exists() && !directory.mkdirs()) {
                throw new IOException("Local state base directory for checkpoint " + checkpointId + " does not exist and could not be created: " + directory);
            }
            File rdbSnapshotDir = new File(directory, this.localDirectoryName);
            if (rdbSnapshotDir.exists()) {
                FileUtils.deleteDirectory((File)rdbSnapshotDir);
            }
            Path path = rdbSnapshotDir.toPath();
            try {
                return SnapshotDirectory.permanent((Path)path);
            }
            catch (IOException ex) {
                try {
                    FileUtils.deleteDirectory((File)directory);
                }
                catch (IOException delEx) {
                    ex = (IOException)ExceptionUtils.firstOrSuppressed((Throwable)delEx, (Throwable)ex);
                }
                throw ex;
            }
        }
        File snapshotDir = new File(this.instanceBasePath, "chk-" + checkpointId);
        return SnapshotDirectory.temporary((File)snapshotDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PreviousSnapshot snapshotMetaData(long checkpointId, @Nonnull List<StateMetaInfoSnapshot> stateMetaInfoSnapshots) {
        Map confirmedSstFiles;
        long lastCompletedCheckpoint;
        SortedMap<Long, Map<StateHandleID, Long>> sortedMap = this.uploadedStateIDs;
        synchronized (sortedMap) {
            lastCompletedCheckpoint = this.lastCompletedCheckpointId;
            confirmedSstFiles = (Map)this.uploadedStateIDs.get(lastCompletedCheckpoint);
            LOG.trace("Use confirmed SST files for checkpoint {}: {}", (Object)checkpointId, (Object)confirmedSstFiles);
        }
        LOG.trace("Taking incremental snapshot for checkpoint {}. Snapshot is based on last completed checkpoint {} assuming the following (shared) confirmed files as base: {}.", new Object[]{checkpointId, lastCompletedCheckpoint, confirmedSstFiles});
        for (Map.Entry entry : this.kvStateInformation.entrySet()) {
            stateMetaInfoSnapshots.add(((RocksDBKeyedStateBackend.RocksDbKvStateInfo)entry.getValue()).metaInfo.snapshot());
        }
        return new PreviousSnapshot(confirmedSstFiles);
    }

    private void takeDBNativeCheckpoint(@Nonnull SnapshotDirectory outputDirectory) throws Exception {
        try (ResourceGuard.Lease ignored = this.rocksDBResourceGuard.acquireResource();
             Checkpoint checkpoint = Checkpoint.create((RocksDB)this.db);){
            checkpoint.createCheckpoint(outputDirectory.getDirectory().toString());
        }
        catch (Exception ex) {
            try {
                outputDirectory.cleanup();
            }
            catch (IOException cleanupEx) {
                ex = (Exception)ExceptionUtils.firstOrSuppressed((Throwable)cleanupEx, (Throwable)ex);
            }
            throw ex;
        }
    }

    private static class PreviousSnapshot {
        @Nullable
        private final Map<StateHandleID, Long> confirmedSstFiles;

        private PreviousSnapshot(@Nullable Map<StateHandleID, Long> confirmedSstFiles) {
            this.confirmedSstFiles = confirmedSstFiles;
        }

        private Optional<StreamStateHandle> getUploaded(StateHandleID stateHandleID) {
            if (this.confirmedSstFiles != null && this.confirmedSstFiles.containsKey(stateHandleID)) {
                return Optional.of(new PlaceholderStreamStateHandle(this.confirmedSstFiles.get(stateHandleID).longValue()));
            }
            return Optional.empty();
        }
    }

    static class IncrementalRocksDBSnapshotResources
    implements SnapshotResources {
        @Nonnull
        private final SnapshotDirectory snapshotDirectory;
        @Nonnull
        private final PreviousSnapshot previousSnapshot;
        @Nonnull
        private final List<StateMetaInfoSnapshot> stateMetaInfoSnapshots;

        public IncrementalRocksDBSnapshotResources(SnapshotDirectory snapshotDirectory, PreviousSnapshot previousSnapshot, List<StateMetaInfoSnapshot> stateMetaInfoSnapshots) {
            this.snapshotDirectory = snapshotDirectory;
            this.previousSnapshot = previousSnapshot;
            this.stateMetaInfoSnapshots = stateMetaInfoSnapshots;
        }

        public void release() {
            try {
                if (this.snapshotDirectory.exists()) {
                    LOG.trace("Running cleanup for local RocksDB backup directory {}.", (Object)this.snapshotDirectory);
                    boolean cleanupOk = this.snapshotDirectory.cleanup();
                    if (!cleanupOk) {
                        LOG.debug("Could not properly cleanup local RocksDB backup directory.");
                    }
                }
            }
            catch (IOException e) {
                LOG.warn("Could not properly cleanup local RocksDB backup directory.", (Throwable)e);
            }
        }
    }

    private final class RocksDBIncrementalSnapshotOperation
    implements SnapshotStrategy.SnapshotResultSupplier<KeyedStateHandle> {
        private final long checkpointId;
        @Nonnull
        private final CheckpointStreamFactory checkpointStreamFactory;
        @Nonnull
        private final List<StateMetaInfoSnapshot> stateMetaInfoSnapshots;
        @Nonnull
        private final SnapshotDirectory localBackupDirectory;
        @Nonnull
        private final CloseableRegistry tmpResourcesRegistry;
        @Nonnull
        private final PreviousSnapshot previousSnapshot;
        @Nonnull
        private final SnapshotType.SharingFilesStrategy sharingFilesStrategy;

        private RocksDBIncrementalSnapshotOperation(@Nonnull long checkpointId, @Nonnull CheckpointStreamFactory checkpointStreamFactory, @Nonnull SnapshotDirectory localBackupDirectory, @Nonnull PreviousSnapshot previousSnapshot, @Nonnull SnapshotType.SharingFilesStrategy sharingFilesStrategy, List<StateMetaInfoSnapshot> stateMetaInfoSnapshots) {
            this.checkpointStreamFactory = checkpointStreamFactory;
            this.previousSnapshot = previousSnapshot;
            this.checkpointId = checkpointId;
            this.localBackupDirectory = localBackupDirectory;
            this.tmpResourcesRegistry = new CloseableRegistry();
            this.stateMetaInfoSnapshots = stateMetaInfoSnapshots;
            this.sharingFilesStrategy = sharingFilesStrategy;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SnapshotResult<KeyedStateHandle> get(CloseableRegistry snapshotCloseableRegistry) throws Exception {
            boolean completed = false;
            SnapshotResult<StreamStateHandle> metaStateHandle = null;
            HashMap<StateHandleID, StreamStateHandle> sstFiles = new HashMap<StateHandleID, StreamStateHandle>();
            HashMap<StateHandleID, StreamStateHandle> miscFiles = new HashMap<StateHandleID, StreamStateHandle>();
            try {
                SnapshotResult snapshotResult;
                metaStateHandle = this.materializeMetaData(snapshotCloseableRegistry);
                Preconditions.checkNotNull(metaStateHandle, (String)"Metadata was not properly created.");
                Preconditions.checkNotNull((Object)metaStateHandle.getJobManagerOwnedSnapshot(), (String)"Metadata for job manager was not properly created.");
                this.uploadSstFiles(sstFiles, miscFiles, snapshotCloseableRegistry, this.tmpResourcesRegistry);
                long checkpointedSize = metaStateHandle.getStateSize();
                checkpointedSize += this.getUploadedStateSize(sstFiles.values());
                IncrementalRemoteKeyedStateHandle jmIncrementalKeyedStateHandle = new IncrementalRemoteKeyedStateHandle(RocksIncrementalSnapshotStrategy.this.backendUID, RocksIncrementalSnapshotStrategy.this.keyGroupRange, this.checkpointId, sstFiles, miscFiles, (StreamStateHandle)metaStateHandle.getJobManagerOwnedSnapshot(), checkpointedSize += this.getUploadedStateSize(miscFiles.values()));
                DirectoryStateHandle directoryStateHandle = this.localBackupDirectory.completeSnapshotAndGetHandle();
                if (directoryStateHandle != null && metaStateHandle.getTaskLocalSnapshot() != null) {
                    IncrementalLocalKeyedStateHandle localDirKeyedStateHandle = new IncrementalLocalKeyedStateHandle(RocksIncrementalSnapshotStrategy.this.backendUID, this.checkpointId, directoryStateHandle, RocksIncrementalSnapshotStrategy.this.keyGroupRange, (StreamStateHandle)metaStateHandle.getTaskLocalSnapshot(), sstFiles);
                    snapshotResult = SnapshotResult.withLocalState((StateObject)jmIncrementalKeyedStateHandle, (StateObject)localDirKeyedStateHandle);
                } else {
                    snapshotResult = SnapshotResult.of((StateObject)jmIncrementalKeyedStateHandle);
                }
                completed = true;
                SnapshotResult snapshotResult2 = snapshotResult;
                return snapshotResult2;
            }
            finally {
                if (!completed) {
                    this.cleanupIncompleteSnapshot();
                }
            }
        }

        private long getUploadedStateSize(Collection<StreamStateHandle> streamStateHandles) {
            return streamStateHandles.stream().filter(s -> !(s instanceof PlaceholderStreamStateHandle)).mapToLong(StateObject::getStateSize).sum();
        }

        private void cleanupIncompleteSnapshot() {
            try {
                this.tmpResourcesRegistry.close();
            }
            catch (Exception e) {
                LOG.warn("Could not properly clean tmp resources.", (Throwable)e);
            }
            if (this.localBackupDirectory.isSnapshotCompleted()) {
                try {
                    DirectoryStateHandle directoryStateHandle = this.localBackupDirectory.completeSnapshotAndGetHandle();
                    if (directoryStateHandle != null) {
                        directoryStateHandle.discardState();
                    }
                }
                catch (Exception e) {
                    LOG.warn("Could not properly discard local state.", (Throwable)e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void uploadSstFiles(@Nonnull Map<StateHandleID, StreamStateHandle> sstFiles, @Nonnull Map<StateHandleID, StreamStateHandle> miscFiles, @Nonnull CloseableRegistry snapshotCloseableRegistry, @Nonnull CloseableRegistry tmpResourcesRegistry) throws Exception {
            Preconditions.checkState((boolean)this.localBackupDirectory.exists());
            HashMap<StateHandleID, Path> sstFilePaths = new HashMap<StateHandleID, Path>();
            HashMap<StateHandleID, Path> miscFilePaths = new HashMap<StateHandleID, Path>();
            Path[] files = this.localBackupDirectory.listDirectory();
            if (files != null) {
                this.createUploadFilePaths(files, sstFiles, sstFilePaths, miscFilePaths);
                CheckpointedStateScope stateScope = this.sharingFilesStrategy == SnapshotType.SharingFilesStrategy.NO_SHARING ? CheckpointedStateScope.EXCLUSIVE : CheckpointedStateScope.SHARED;
                sstFiles.putAll(RocksIncrementalSnapshotStrategy.this.stateUploader.uploadFilesToCheckpointFs(sstFilePaths, this.checkpointStreamFactory, stateScope, snapshotCloseableRegistry, tmpResourcesRegistry));
                miscFiles.putAll(RocksIncrementalSnapshotStrategy.this.stateUploader.uploadFilesToCheckpointFs(miscFilePaths, this.checkpointStreamFactory, stateScope, snapshotCloseableRegistry, tmpResourcesRegistry));
                SortedMap sortedMap = RocksIncrementalSnapshotStrategy.this.uploadedStateIDs;
                synchronized (sortedMap) {
                    switch (this.sharingFilesStrategy) {
                        case FORWARD_BACKWARD: 
                        case FORWARD: {
                            RocksIncrementalSnapshotStrategy.this.uploadedStateIDs.put(this.checkpointId, sstFiles.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, t -> ((StreamStateHandle)t.getValue()).getStateSize())));
                            break;
                        }
                        case NO_SHARING: {
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unsupported sharing files strategy: " + this.sharingFilesStrategy);
                        }
                    }
                }
            }
        }

        private void createUploadFilePaths(Path[] files, Map<StateHandleID, StreamStateHandle> sstFiles, Map<StateHandleID, Path> sstFilePaths, Map<StateHandleID, Path> miscFilePaths) {
            for (Path filePath : files) {
                String fileName = filePath.getFileName().toString();
                StateHandleID stateHandleID = new StateHandleID(fileName);
                if (fileName.endsWith(".sst")) {
                    Optional uploaded = this.previousSnapshot.getUploaded(stateHandleID);
                    if (uploaded.isPresent()) {
                        sstFiles.put(stateHandleID, (StreamStateHandle)uploaded.get());
                        continue;
                    }
                    sstFilePaths.put(stateHandleID, filePath);
                    continue;
                }
                miscFilePaths.put(stateHandleID, filePath);
            }
        }

        @Nonnull
        private SnapshotResult<StreamStateHandle> materializeMetaData(@Nonnull CloseableRegistry snapshotCloseableRegistry) throws Exception {
            CheckpointStreamWithResultProvider streamWithResultProvider = RocksIncrementalSnapshotStrategy.this.localRecoveryConfig.isLocalRecoveryEnabled() ? CheckpointStreamWithResultProvider.createDuplicatingStream((long)this.checkpointId, (CheckpointedStateScope)CheckpointedStateScope.EXCLUSIVE, (CheckpointStreamFactory)this.checkpointStreamFactory, (LocalRecoveryDirectoryProvider)((LocalRecoveryDirectoryProvider)RocksIncrementalSnapshotStrategy.this.localRecoveryConfig.getLocalStateDirectoryProvider().orElseThrow(LocalRecoveryConfig.localRecoveryNotEnabled()))) : CheckpointStreamWithResultProvider.createSimpleStream((CheckpointedStateScope)CheckpointedStateScope.EXCLUSIVE, (CheckpointStreamFactory)this.checkpointStreamFactory);
            snapshotCloseableRegistry.registerCloseable((AutoCloseable)streamWithResultProvider);
            try {
                KeyedBackendSerializationProxy serializationProxy = new KeyedBackendSerializationProxy(RocksIncrementalSnapshotStrategy.this.keySerializer, this.stateMetaInfoSnapshots, false);
                DataOutputViewStreamWrapper out = new DataOutputViewStreamWrapper((OutputStream)streamWithResultProvider.getCheckpointOutputStream());
                serializationProxy.write((DataOutputView)out);
                if (snapshotCloseableRegistry.unregisterCloseable((AutoCloseable)streamWithResultProvider)) {
                    SnapshotResult result = streamWithResultProvider.closeAndFinalizeCheckpointStreamResult();
                    streamWithResultProvider = null;
                    this.tmpResourcesRegistry.registerCloseable(() -> StateUtil.discardStateObjectQuietly((StateObject)result));
                    SnapshotResult snapshotResult = result;
                    return snapshotResult;
                }
                throw new IOException("Stream already closed and cannot return a handle.");
            }
            finally {
                if (streamWithResultProvider != null && snapshotCloseableRegistry.unregisterCloseable((AutoCloseable)streamWithResultProvider)) {
                    IOUtils.closeQuietly((AutoCloseable)streamWithResultProvider);
                }
            }
        }
    }
}

