/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.security.SaslRpcServer;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.PolicyProvider;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.ApplicationMasterProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateRequest;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateResponse;
import org.apache.hadoop.yarn.api.protocolrecords.FinishApplicationMasterRequest;
import org.apache.hadoop.yarn.api.protocolrecords.FinishApplicationMasterResponse;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterRequest;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterResponse;
import org.apache.hadoop.yarn.api.records.AMCommand;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NMToken;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeReport;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.api.records.PreemptionContainer;
import org.apache.hadoop.yarn.api.records.PreemptionContract;
import org.apache.hadoop.yarn.api.records.PreemptionMessage;
import org.apache.hadoop.yarn.api.records.PreemptionResourceRequest;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceBlacklistRequest;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.api.records.StrictPreemptionContract;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.exceptions.InvalidApplicationMasterRequestException;
import org.apache.hadoop.yarn.exceptions.InvalidContainerReleaseException;
import org.apache.hadoop.yarn.exceptions.InvalidResourceBlacklistRequestException;
import org.apache.hadoop.yarn.exceptions.InvalidResourceRequestException;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.ipc.RPCUtil;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.security.AMRMTokenIdentifier;
import org.apache.hadoop.yarn.server.resourcemanager.RMAuditLogger;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.RMServerUtils;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.AMLivelinessMonitor;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.event.RMAppAttemptRegistrationEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.event.RMAppAttemptStatusupdateEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.event.RMAppAttemptUnregistrationEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.AbstractYarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Allocation;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNodeReport;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.YarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.security.authorize.RMPolicyProvider;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;

@InterfaceAudience.Private
public class ApplicationMasterService
extends AbstractService
implements ApplicationMasterProtocol {
    private static final Log LOG = LogFactory.getLog(ApplicationMasterService.class);
    private final AMLivelinessMonitor amLivelinessMonitor;
    private YarnScheduler rScheduler;
    private InetSocketAddress bindAddress;
    private Server server;
    private final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    private final ConcurrentMap<ApplicationAttemptId, AllocateResponseLock> responseMap = new ConcurrentHashMap<ApplicationAttemptId, AllocateResponseLock>();
    private final AllocateResponse resync = (AllocateResponse)this.recordFactory.newRecordInstance(AllocateResponse.class);
    private final RMContext rmContext;

    public ApplicationMasterService(RMContext rmContext, YarnScheduler scheduler) {
        super(ApplicationMasterService.class.getName());
        this.amLivelinessMonitor = rmContext.getAMLivelinessMonitor();
        this.rScheduler = scheduler;
        this.resync.setAMCommand(AMCommand.AM_RESYNC);
        this.rmContext = rmContext;
    }

    protected void serviceStart() throws Exception {
        Configuration conf = this.getConfig();
        YarnRPC rpc = YarnRPC.create((Configuration)conf);
        InetSocketAddress masterServiceAddress = conf.getSocketAddr("yarn.resourcemanager.scheduler.address", "0.0.0.0:8030", 8030);
        Configuration serverConf = conf;
        serverConf = new Configuration(conf);
        serverConf.set("hadoop.security.authentication", SaslRpcServer.AuthMethod.TOKEN.toString());
        this.server = rpc.getServer(ApplicationMasterProtocol.class, (Object)this, masterServiceAddress, serverConf, (SecretManager)this.rmContext.getAMRMTokenSecretManager(), serverConf.getInt("yarn.resourcemanager.scheduler.client.thread-count", 50));
        if (conf.getBoolean("hadoop.security.authorization", false)) {
            InputStream inputStream = this.rmContext.getConfigurationProvider().getConfigurationInputStream(conf, "hadoop-policy.xml");
            if (inputStream != null) {
                conf.addResource(inputStream);
            }
            this.refreshServiceAcls(conf, RMPolicyProvider.getInstance());
        }
        this.server.start();
        this.bindAddress = conf.updateConnectAddr("yarn.resourcemanager.scheduler.address", this.server.getListenerAddress());
        super.serviceStart();
    }

    @InterfaceAudience.Private
    public InetSocketAddress getBindAddress() {
        return this.bindAddress;
    }

    private AMRMTokenIdentifier selectAMRMTokenIdentifier(UserGroupInformation remoteUgi) throws IOException {
        AMRMTokenIdentifier result = null;
        Set tokenIds = remoteUgi.getTokenIdentifiers();
        for (TokenIdentifier tokenId : tokenIds) {
            if (!(tokenId instanceof AMRMTokenIdentifier)) continue;
            result = (AMRMTokenIdentifier)tokenId;
            break;
        }
        return result;
    }

    private ApplicationAttemptId authorizeRequest() throws YarnException {
        UserGroupInformation remoteUgi;
        try {
            remoteUgi = UserGroupInformation.getCurrentUser();
        }
        catch (IOException e) {
            String msg = "Cannot obtain the user-name for authorizing ApplicationMaster. Got exception: " + StringUtils.stringifyException((Throwable)e);
            LOG.warn((Object)msg);
            throw RPCUtil.getRemoteException((String)msg);
        }
        boolean tokenFound = false;
        String message = "";
        AMRMTokenIdentifier appTokenIdentifier = null;
        try {
            appTokenIdentifier = this.selectAMRMTokenIdentifier(remoteUgi);
            if (appTokenIdentifier == null) {
                tokenFound = false;
                message = "No AMRMToken found for user " + remoteUgi.getUserName();
            } else {
                tokenFound = true;
            }
        }
        catch (IOException e) {
            tokenFound = false;
            message = "Got exception while looking for AMRMToken for user " + remoteUgi.getUserName();
        }
        if (!tokenFound) {
            LOG.warn((Object)message);
            throw RPCUtil.getRemoteException((String)message);
        }
        return appTokenIdentifier.getApplicationAttemptId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RegisterApplicationMasterResponse registerApplicationMaster(RegisterApplicationMasterRequest request) throws YarnException, IOException {
        ApplicationAttemptId applicationAttemptId = this.authorizeRequest();
        ApplicationId appID = applicationAttemptId.getApplicationId();
        AllocateResponseLock lock = (AllocateResponseLock)this.responseMap.get(applicationAttemptId);
        if (lock == null) {
            RMAuditLogger.logFailure(((RMApp)this.rmContext.getRMApps().get(appID)).getUser(), "Register App Master", "Application doesn't exist in cache " + applicationAttemptId, "ApplicationMasterService", "Error in registering application master", appID, applicationAttemptId);
            this.throwApplicationDoesNotExistInCacheException(applicationAttemptId);
        }
        AllocateResponseLock allocateResponseLock = lock;
        synchronized (allocateResponseLock) {
            List<Container> transferredContainers;
            AllocateResponse lastResponse = lock.getAllocateResponse();
            if (this.hasApplicationMasterRegistered(applicationAttemptId)) {
                String message = "Application Master is already registered : " + applicationAttemptId.getApplicationId();
                LOG.warn((Object)message);
                RMAuditLogger.logFailure(((RMApp)this.rmContext.getRMApps().get(applicationAttemptId.getApplicationId())).getUser(), "Register App Master", "", "ApplicationMasterService", message, applicationAttemptId.getApplicationId(), applicationAttemptId);
                throw new InvalidApplicationMasterRequestException(message);
            }
            this.amLivelinessMonitor.receivedPing(applicationAttemptId);
            RMApp app = (RMApp)this.rmContext.getRMApps().get(appID);
            lastResponse.setResponseId(0);
            lock.setAllocateResponse(lastResponse);
            LOG.info((Object)("AM registration " + applicationAttemptId));
            this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMAppAttemptRegistrationEvent(applicationAttemptId, request.getHost(), request.getRpcPort(), request.getTrackingUrl()));
            RMAuditLogger.logSuccess(app.getUser(), "Register App Master", "ApplicationMasterService", appID, applicationAttemptId);
            RegisterApplicationMasterResponse response = (RegisterApplicationMasterResponse)this.recordFactory.newRecordInstance(RegisterApplicationMasterResponse.class);
            response.setMaximumResourceCapability(this.rScheduler.getMaximumResourceCapability());
            response.setApplicationACLs(app.getRMAppAttempt(applicationAttemptId).getSubmissionContext().getAMContainerSpec().getApplicationACLs());
            response.setQueue(app.getQueue());
            if (UserGroupInformation.isSecurityEnabled()) {
                LOG.info((Object)"Setting client token master key");
                response.setClientToAMTokenMasterKey(ByteBuffer.wrap(this.rmContext.getClientToAMTokenSecretManager().getMasterKey(applicationAttemptId).getEncoded()));
            }
            if (!(transferredContainers = ((AbstractYarnScheduler)this.rScheduler).getTransferredContainers(applicationAttemptId)).isEmpty()) {
                response.setContainersFromPreviousAttempts(transferredContainers);
                ArrayList<NMToken> nmTokens = new ArrayList<NMToken>();
                for (Container container : transferredContainers) {
                    try {
                        nmTokens.add(this.rmContext.getNMTokenSecretManager().createAndGetNMToken(app.getUser(), applicationAttemptId, container));
                    }
                    catch (IllegalArgumentException e) {
                        if (!(e.getCause() instanceof UnknownHostException)) continue;
                        throw (UnknownHostException)e.getCause();
                    }
                }
                response.setNMTokensFromPreviousAttempts(nmTokens);
                LOG.info((Object)("Application " + appID + " retrieved " + transferredContainers.size() + " containers from previous" + " attempts and " + nmTokens.size() + " NM tokens."));
            }
            return response;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FinishApplicationMasterResponse finishApplicationMaster(FinishApplicationMasterRequest request) throws YarnException, IOException {
        ApplicationAttemptId applicationAttemptId = this.authorizeRequest();
        AllocateResponseLock lock = (AllocateResponseLock)this.responseMap.get(applicationAttemptId);
        if (lock == null) {
            this.throwApplicationDoesNotExistInCacheException(applicationAttemptId);
        }
        AllocateResponseLock allocateResponseLock = lock;
        synchronized (allocateResponseLock) {
            if (!this.hasApplicationMasterRegistered(applicationAttemptId)) {
                String message = "Application Master is trying to unregister before registering for: " + applicationAttemptId.getApplicationId();
                LOG.error((Object)message);
                RMAuditLogger.logFailure(((RMApp)this.rmContext.getRMApps().get(applicationAttemptId.getApplicationId())).getUser(), "Unregister App Master", "", "ApplicationMasterService", message, applicationAttemptId.getApplicationId(), applicationAttemptId);
                throw new InvalidApplicationMasterRequestException(message);
            }
            this.amLivelinessMonitor.receivedPing(applicationAttemptId);
            RMApp rmApp = (RMApp)this.rmContext.getRMApps().get(applicationAttemptId.getApplicationId());
            if (rmApp.isAppFinalStateStored()) {
                return FinishApplicationMasterResponse.newInstance((boolean)true);
            }
            this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMAppAttemptUnregistrationEvent(applicationAttemptId, request.getTrackingUrl(), request.getFinalApplicationStatus(), request.getDiagnostics()));
            return FinishApplicationMasterResponse.newInstance((boolean)rmApp.getApplicationSubmissionContext().getUnmanagedAM());
        }
    }

    private void throwApplicationDoesNotExistInCacheException(ApplicationAttemptId appAttemptId) throws InvalidApplicationMasterRequestException {
        String message = "Application doesn't exist in cache " + appAttemptId;
        LOG.error((Object)message);
        throw new InvalidApplicationMasterRequestException(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasApplicationMasterRegistered(ApplicationAttemptId appAttemptId) {
        boolean hasApplicationMasterRegistered = false;
        AllocateResponseLock lastResponse = (AllocateResponseLock)this.responseMap.get(appAttemptId);
        if (lastResponse != null) {
            AllocateResponseLock allocateResponseLock = lastResponse;
            synchronized (allocateResponseLock) {
                if (lastResponse.getAllocateResponse() != null && lastResponse.getAllocateResponse().getResponseId() >= 0) {
                    hasApplicationMasterRegistered = true;
                }
            }
        }
        return hasApplicationMasterRegistered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AllocateResponse allocate(AllocateRequest request) throws YarnException, IOException {
        ApplicationAttemptId appAttemptId = this.authorizeRequest();
        this.amLivelinessMonitor.receivedPing(appAttemptId);
        AllocateResponseLock lock = (AllocateResponseLock)this.responseMap.get(appAttemptId);
        if (lock == null) {
            LOG.error((Object)("AppAttemptId doesnt exist in cache " + appAttemptId));
            return this.resync;
        }
        AllocateResponseLock allocateResponseLock = lock;
        synchronized (allocateResponseLock) {
            ArrayList<RMNode> updatedNodes;
            AllocateResponse lastResponse = lock.getAllocateResponse();
            if (!this.hasApplicationMasterRegistered(appAttemptId)) {
                String message = "Application Master is trying to allocate before registering for: " + appAttemptId.getApplicationId();
                LOG.error((Object)message);
                RMAuditLogger.logFailure(((RMApp)this.rmContext.getRMApps().get(appAttemptId.getApplicationId())).getUser(), "Register App Master", "", "ApplicationMasterService", message, appAttemptId.getApplicationId(), appAttemptId);
                throw new InvalidApplicationMasterRequestException(message);
            }
            if (request.getResponseId() + 1 == lastResponse.getResponseId()) {
                return lastResponse;
            }
            if (request.getResponseId() + 1 < lastResponse.getResponseId()) {
                LOG.error((Object)("Invalid responseid from appAttemptId " + appAttemptId));
                return this.resync;
            }
            this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMAppAttemptStatusupdateEvent(appAttemptId, request.getProgress()));
            List ask = request.getAskList();
            List release = request.getReleaseList();
            ResourceBlacklistRequest blacklistRequest = request.getResourceBlacklistRequest();
            List blacklistAdditions = blacklistRequest != null ? blacklistRequest.getBlacklistAdditions() : Collections.EMPTY_LIST;
            List blacklistRemovals = blacklistRequest != null ? blacklistRequest.getBlacklistRemovals() : Collections.EMPTY_LIST;
            try {
                RMServerUtils.validateResourceRequests(ask, this.rScheduler.getMaximumResourceCapability());
            }
            catch (InvalidResourceRequestException e) {
                LOG.warn((Object)("Invalid resource ask by application " + appAttemptId), (Throwable)e);
                throw e;
            }
            try {
                RMServerUtils.validateBlacklistRequest(blacklistRequest);
            }
            catch (InvalidResourceBlacklistRequestException e) {
                LOG.warn((Object)("Invalid blacklist request by application " + appAttemptId), (Throwable)e);
                throw e;
            }
            RMApp app = (RMApp)this.rmContext.getRMApps().get(appAttemptId.getApplicationId());
            if (!app.getApplicationSubmissionContext().getKeepContainersAcrossApplicationAttempts()) {
                try {
                    RMServerUtils.validateContainerReleaseRequest(release, appAttemptId);
                }
                catch (InvalidContainerReleaseException e) {
                    LOG.warn((Object)("Invalid container release by application " + appAttemptId), (Throwable)e);
                    throw e;
                }
            }
            Allocation allocation = this.rScheduler.allocate(appAttemptId, ask, release, blacklistAdditions, blacklistRemovals);
            if (!blacklistAdditions.isEmpty() || !blacklistRemovals.isEmpty()) {
                LOG.info((Object)("blacklist are updated in Scheduler.blacklistAdditions: " + blacklistAdditions + ", " + "blacklistRemovals: " + blacklistRemovals));
            }
            RMAppAttempt appAttempt = app.getRMAppAttempt(appAttemptId);
            AllocateResponse allocateResponse = (AllocateResponse)this.recordFactory.newRecordInstance(AllocateResponse.class);
            if (!allocation.getContainers().isEmpty()) {
                allocateResponse.setNMTokens(allocation.getNMTokens());
            }
            if (app.pullRMNodeUpdates(updatedNodes = new ArrayList<RMNode>()) > 0) {
                ArrayList<NodeReport> updatedNodeReports = new ArrayList<NodeReport>();
                for (RMNode rmNode : updatedNodes) {
                    SchedulerNodeReport schedulerNodeReport = this.rScheduler.getNodeReport(rmNode.getNodeID());
                    Resource used = BuilderUtils.newResource((int)0, (int)0);
                    int numContainers = 0;
                    if (schedulerNodeReport != null) {
                        used = schedulerNodeReport.getUsedResource();
                        numContainers = schedulerNodeReport.getNumContainers();
                    }
                    NodeReport report = BuilderUtils.newNodeReport((NodeId)rmNode.getNodeID(), (NodeState)rmNode.getState(), (String)rmNode.getHttpAddress(), (String)rmNode.getRackName(), (Resource)used, (Resource)rmNode.getTotalCapability(), (int)numContainers, (String)rmNode.getHealthReport(), (long)rmNode.getLastHealthReportTime());
                    updatedNodeReports.add(report);
                }
                allocateResponse.setUpdatedNodes(updatedNodeReports);
            }
            allocateResponse.setAllocatedContainers(allocation.getContainers());
            allocateResponse.setCompletedContainersStatuses(appAttempt.pullJustFinishedContainers());
            allocateResponse.setResponseId(lastResponse.getResponseId() + 1);
            allocateResponse.setAvailableResources(allocation.getResourceLimit());
            allocateResponse.setNumClusterNodes(this.rScheduler.getNumClusterNodes());
            allocateResponse.setPreemptionMessage(this.generatePreemptionMessage(allocation));
            lock.setAllocateResponse(allocateResponse);
            return allocateResponse;
        }
    }

    private PreemptionMessage generatePreemptionMessage(Allocation allocation) {
        PreemptionContainer pc;
        HashSet<PreemptionContainer> pCont;
        PreemptionMessage pMsg = null;
        if (allocation.getStrictContainerPreemptions() != null) {
            pMsg = (PreemptionMessage)this.recordFactory.newRecordInstance(PreemptionMessage.class);
            StrictPreemptionContract pStrict = (StrictPreemptionContract)this.recordFactory.newRecordInstance(StrictPreemptionContract.class);
            pCont = new HashSet<PreemptionContainer>();
            for (ContainerId cId : allocation.getStrictContainerPreemptions()) {
                pc = (PreemptionContainer)this.recordFactory.newRecordInstance(PreemptionContainer.class);
                pc.setId(cId);
                pCont.add(pc);
            }
            pStrict.setContainers(pCont);
            pMsg.setStrictContract(pStrict);
        }
        if (allocation.getResourcePreemptions() != null && allocation.getResourcePreemptions().size() > 0 && allocation.getContainerPreemptions() != null && allocation.getContainerPreemptions().size() > 0) {
            if (pMsg == null) {
                pMsg = (PreemptionMessage)this.recordFactory.newRecordInstance(PreemptionMessage.class);
            }
            PreemptionContract contract = (PreemptionContract)this.recordFactory.newRecordInstance(PreemptionContract.class);
            pCont = new HashSet();
            for (ContainerId cId : allocation.getContainerPreemptions()) {
                pc = (PreemptionContainer)this.recordFactory.newRecordInstance(PreemptionContainer.class);
                pc.setId(cId);
                pCont.add(pc);
            }
            ArrayList<PreemptionResourceRequest> pRes = new ArrayList<PreemptionResourceRequest>();
            for (ResourceRequest crr : allocation.getResourcePreemptions()) {
                PreemptionResourceRequest prr = (PreemptionResourceRequest)this.recordFactory.newRecordInstance(PreemptionResourceRequest.class);
                prr.setResourceRequest(crr);
                pRes.add(prr);
            }
            contract.setContainers(pCont);
            contract.setResourceRequest(pRes);
            pMsg.setContract(contract);
        }
        return pMsg;
    }

    public void registerAppAttempt(ApplicationAttemptId attemptId) {
        AllocateResponse response = (AllocateResponse)this.recordFactory.newRecordInstance(AllocateResponse.class);
        response.setResponseId(-1);
        LOG.info((Object)("Registering app attempt : " + attemptId));
        this.responseMap.put(attemptId, new AllocateResponseLock(response));
        this.rmContext.getNMTokenSecretManager().registerApplicationAttempt(attemptId);
    }

    public void unregisterAttempt(ApplicationAttemptId attemptId) {
        LOG.info((Object)("Unregistering app attempt : " + attemptId));
        this.responseMap.remove(attemptId);
        this.rmContext.getNMTokenSecretManager().unregisterApplicationAttempt(attemptId);
    }

    public void refreshServiceAcls(Configuration configuration, PolicyProvider policyProvider) {
        this.server.refreshServiceAclWithLoadedConfiguration(configuration, policyProvider);
    }

    protected void serviceStop() throws Exception {
        if (this.server != null) {
            this.server.stop();
        }
        super.serviceStop();
    }

    @VisibleForTesting
    public Server getServer() {
        return this.server;
    }

    public static class AllocateResponseLock {
        private AllocateResponse response;

        public AllocateResponseLock(AllocateResponse response) {
            this.response = response;
        }

        public synchronized AllocateResponse getAllocateResponse() {
            return this.response;
        }

        public synchronized void setAllocateResponse(AllocateResponse response) {
            this.response = response;
        }
    }
}

