/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.reservation;

import java.util.Date;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.Plan;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationAllocation;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.SharingPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.exceptions.MismatchedUserException;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.exceptions.PlanningException;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.exceptions.PlanningQuotaException;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.exceptions.ResourceOverCommitException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;

@InterfaceAudience.LimitedPrivate(value={"yarn"})
@InterfaceStability.Unstable
public class CapacityOverTimePolicy
implements SharingPolicy {
    private CapacitySchedulerConfiguration conf;
    private long validWindow;
    private float maxInst;
    private float maxAvg;

    @Override
    public void init(String reservationQueuePath, Configuration conf) {
        if (!(conf instanceof CapacitySchedulerConfiguration)) {
            throw new IllegalArgumentException("Unexpected conf type: " + conf.getClass().getSimpleName() + " only supported conf is: " + CapacitySchedulerConfiguration.class.getSimpleName());
        }
        this.conf = (CapacitySchedulerConfiguration)conf;
        this.validWindow = this.conf.getReservationWindow(reservationQueuePath);
        this.maxInst = this.conf.getInstantaneousMaxCapacity(reservationQueuePath) / 100.0f;
        this.maxAvg = this.conf.getAverageCapacity(reservationQueuePath) / 100.0f;
    }

    @Override
    public void validate(Plan plan, ReservationAllocation reservation) throws PlanningException {
        ReservationAllocation oldReservation = plan.getReservationById(reservation.getReservationId());
        if (oldReservation != null && !oldReservation.getUser().equals(reservation.getUser())) {
            throw new MismatchedUserException("Updating an existing reservation with mismatched user:" + oldReservation.getUser() + " != " + reservation.getUser());
        }
        long startTime = reservation.getStartTime();
        long endTime = reservation.getEndTime();
        long step = plan.getStep();
        Resource planTotalCapacity = plan.getTotalCapacity();
        Resource maxAvgRes = Resources.multiply((Resource)planTotalCapacity, (double)this.maxAvg);
        Resource maxInsRes = Resources.multiply((Resource)planTotalCapacity, (double)this.maxInst);
        IntegralResource runningTot = new IntegralResource(0L, 0L);
        IntegralResource maxAllowed = new IntegralResource(maxAvgRes);
        maxAllowed.multiplyBy(this.validWindow / step);
        for (long t = startTime - this.validWindow; t < endTime + this.validWindow; t += step) {
            Resource currExistingAllocTot = plan.getTotalCommittedResources(t);
            Resource currExistingAllocForUser = plan.getConsumptionForUser(reservation.getUser(), t);
            Resource currNewAlloc = reservation.getResourcesAtTime(t);
            Resource currOldAlloc = Resources.none();
            if (oldReservation != null) {
                currOldAlloc = oldReservation.getResourcesAtTime(t);
            }
            Resource inst = Resources.subtract((Resource)Resources.add((Resource)currExistingAllocTot, (Resource)currNewAlloc), (Resource)currOldAlloc);
            if (Resources.greaterThan((ResourceCalculator)plan.getResourceCalculator(), (Resource)planTotalCapacity, (Resource)inst, (Resource)planTotalCapacity)) {
                throw new ResourceOverCommitException(" Resources at time " + t + " would be overcommitted (" + inst + " over " + plan.getTotalCapacity() + ") by accepting reservation: " + reservation.getReservationId());
            }
            if (Resources.greaterThan((ResourceCalculator)plan.getResourceCalculator(), (Resource)planTotalCapacity, (Resource)Resources.subtract((Resource)Resources.add((Resource)currExistingAllocForUser, (Resource)currNewAlloc), (Resource)currOldAlloc), (Resource)maxInsRes)) {
                throw new PlanningQuotaException("Instantaneous quota capacity " + this.maxInst + " would be passed at time " + t + " by accepting reservation: " + reservation.getReservationId());
            }
            runningTot.add(currExistingAllocForUser);
            runningTot.add(currNewAlloc);
            runningTot.subtract(currOldAlloc);
            if (t > startTime) {
                Resource pastOldAlloc = plan.getConsumptionForUser(reservation.getUser(), t - this.validWindow);
                Resource pastNewAlloc = reservation.getResourcesAtTime(t - this.validWindow);
                runningTot.subtract(pastOldAlloc);
                runningTot.subtract(pastNewAlloc);
            }
            if (maxAllowed.compareTo(runningTot) >= 0L) continue;
            throw new PlanningQuotaException("Integral (avg over time) quota capacity " + this.maxAvg + " over a window of " + this.validWindow / 1000L + " seconds, " + " would be passed at time " + t + "(" + new Date(t) + ") by accepting reservation: " + reservation.getReservationId());
        }
    }

    @Override
    public long getValidWindow() {
        return this.validWindow;
    }

    private static class IntegralResource {
        long memory;
        long vcores;

        public IntegralResource(Resource resource) {
            this.memory = resource.getMemory();
            this.vcores = resource.getVirtualCores();
        }

        public IntegralResource(long mem, long vcores) {
            this.memory = mem;
            this.vcores = vcores;
        }

        public void add(Resource r) {
            this.memory += (long)r.getMemory();
            this.vcores += (long)r.getVirtualCores();
        }

        public void subtract(Resource r) {
            this.memory -= (long)r.getMemory();
            this.vcores -= (long)r.getVirtualCores();
        }

        public void multiplyBy(long window) {
            this.memory *= window;
            this.vcores *= window;
        }

        public long compareTo(IntegralResource other) {
            long diff = this.memory - other.memory;
            if (diff == 0L) {
                diff = this.vcores - other.vcores;
            }
            return diff;
        }

        public String toString() {
            return "<memory:" + this.memory + ", vCores:" + this.vcores + ">";
        }
    }
}

