/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.reservation;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.AbstractReservationSystem;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.InMemoryPlan;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.Plan;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.Planner;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationAgent;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.SharingPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"yarn"})
@InterfaceStability.Unstable
public class CapacityReservationSystem
extends AbstractReservationSystem {
    private static final Logger LOG = LoggerFactory.getLogger(CapacityReservationSystem.class);
    private CapacityScheduler capScheduler;

    public CapacityReservationSystem() {
        super(CapacityReservationSystem.class.getName());
    }

    @Override
    public void reinitialize(Configuration conf, RMContext rmContext) throws YarnException {
        ResourceScheduler scheduler = rmContext.getScheduler();
        if (!(scheduler instanceof CapacityScheduler)) {
            throw new YarnRuntimeException("Class " + scheduler.getClass().getCanonicalName() + " not instance of " + CapacityScheduler.class.getCanonicalName());
        }
        this.capScheduler = (CapacityScheduler)scheduler;
        this.conf = conf;
        super.reinitialize(conf, rmContext);
    }

    @Override
    protected Plan initializePlan(String planQueueName) throws YarnException {
        SharingPolicy adPolicy = this.getAdmissionPolicy(planQueueName);
        String planQueuePath = this.capScheduler.getQueue(planQueueName).getQueuePath();
        adPolicy.init(planQueuePath, this.capScheduler.getConfiguration());
        CSQueue planQueue = this.capScheduler.getQueue(planQueueName);
        Resource minAllocation = this.capScheduler.getMinimumResourceCapability();
        ResourceCalculator rescCalc = this.capScheduler.getResourceCalculator();
        Resource totCap = rescCalc.multiplyAndNormalizeDown(this.capScheduler.getClusterResource(), (double)planQueue.getAbsoluteCapacity(), minAllocation);
        InMemoryPlan plan = new InMemoryPlan(this.capScheduler.getRootQueueMetrics(), adPolicy, this.getAgent(planQueuePath), totCap, this.planStepSize, rescCalc, minAllocation, this.capScheduler.getMaximumResourceCapability(), planQueueName, this.getReplanner(planQueuePath), this.capScheduler.getConfiguration().getMoveOnExpiry(planQueuePath));
        LOG.info("Intialized plan {0} based on reservable queue {1}", (Object)((Object)plan).toString(), (Object)planQueueName);
        return plan;
    }

    @Override
    protected Planner getReplanner(String planQueueName) {
        CapacitySchedulerConfiguration capSchedulerConfig = this.capScheduler.getConfiguration();
        String plannerClassName = capSchedulerConfig.getReplanner(planQueueName);
        LOG.info("Using Replanner: " + plannerClassName + " for queue: " + planQueueName);
        try {
            Class plannerClazz = capSchedulerConfig.getClassByName(plannerClassName);
            if (Planner.class.isAssignableFrom(plannerClazz)) {
                Planner planner = (Planner)ReflectionUtils.newInstance((Class)plannerClazz, (Configuration)this.conf);
                planner.init(planQueueName, capSchedulerConfig);
                return planner;
            }
            throw new YarnRuntimeException("Class: " + plannerClazz + " not instance of " + Planner.class.getCanonicalName());
        }
        catch (ClassNotFoundException e) {
            throw new YarnRuntimeException("Could not instantiate Planner: " + plannerClassName + " for queue: " + planQueueName, (Throwable)e);
        }
    }

    @Override
    protected ReservationAgent getAgent(String queueName) {
        CapacitySchedulerConfiguration capSchedulerConfig = this.capScheduler.getConfiguration();
        String agentClassName = capSchedulerConfig.getReservationAgent(queueName);
        LOG.info("Using Agent: " + agentClassName + " for queue: " + queueName);
        try {
            Class agentClazz = capSchedulerConfig.getClassByName(agentClassName);
            if (ReservationAgent.class.isAssignableFrom(agentClazz)) {
                return (ReservationAgent)ReflectionUtils.newInstance((Class)agentClazz, (Configuration)this.conf);
            }
            throw new YarnRuntimeException("Class: " + agentClassName + " not instance of " + ReservationAgent.class.getCanonicalName());
        }
        catch (ClassNotFoundException e) {
            throw new YarnRuntimeException("Could not instantiate Agent: " + agentClassName + " for queue: " + queueName, (Throwable)e);
        }
    }

    @Override
    protected SharingPolicy getAdmissionPolicy(String queueName) {
        CapacitySchedulerConfiguration capSchedulerConfig = this.capScheduler.getConfiguration();
        String admissionPolicyClassName = capSchedulerConfig.getReservationAdmissionPolicy(queueName);
        LOG.info("Using AdmissionPolicy: " + admissionPolicyClassName + " for queue: " + queueName);
        try {
            Class admissionPolicyClazz = capSchedulerConfig.getClassByName(admissionPolicyClassName);
            if (SharingPolicy.class.isAssignableFrom(admissionPolicyClazz)) {
                return (SharingPolicy)ReflectionUtils.newInstance((Class)admissionPolicyClazz, (Configuration)this.conf);
            }
            throw new YarnRuntimeException("Class: " + admissionPolicyClassName + " not instance of " + SharingPolicy.class.getCanonicalName());
        }
        catch (ClassNotFoundException e) {
            throw new YarnRuntimeException("Could not instantiate AdmissionPolicy: " + admissionPolicyClassName + " for queue: " + queueName, (Throwable)e);
        }
    }
}

