/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ReplicationProtos;
import org.apache.hadoop.hbase.zookeeper.ZKConfig;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hadoop.hbase.zookeeper.ZNodePaths;
import org.apache.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hbase.thirdparty.com.google.protobuf.CodedOutputStream;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Private
public abstract class ReplicationStateZKBase {
    protected final String peerStateNodeName;
    protected final String replicationZNode;
    protected final String peersZNode;
    protected final String queuesZNode;
    protected final String hfileRefsZNode;
    protected final String ourClusterKey;
    protected final String tableCFsNodeName;
    protected final ZKWatcher zookeeper;
    protected final Configuration conf;
    protected final Abortable abortable;
    public static final byte[] ENABLED_ZNODE_BYTES = ReplicationStateZKBase.toByteArray(ReplicationProtos.ReplicationState.State.ENABLED);
    public static final byte[] DISABLED_ZNODE_BYTES = ReplicationStateZKBase.toByteArray(ReplicationProtos.ReplicationState.State.DISABLED);
    public static final String ZOOKEEPER_ZNODE_REPLICATION_HFILE_REFS_KEY = "zookeeper.znode.replication.hfile.refs";
    public static final String ZOOKEEPER_ZNODE_REPLICATION_HFILE_REFS_DEFAULT = "hfile-refs";

    public ReplicationStateZKBase(ZKWatcher zookeeper, Configuration conf, Abortable abortable) {
        this.zookeeper = zookeeper;
        this.conf = conf;
        this.abortable = abortable;
        String replicationZNodeName = conf.get("zookeeper.znode.replication", "replication");
        String peersZNodeName = conf.get("zookeeper.znode.replication.peers", "peers");
        String queuesZNodeName = conf.get("zookeeper.znode.replication.rs", "rs");
        String hfileRefsZNodeName = conf.get(ZOOKEEPER_ZNODE_REPLICATION_HFILE_REFS_KEY, ZOOKEEPER_ZNODE_REPLICATION_HFILE_REFS_DEFAULT);
        this.peerStateNodeName = conf.get("zookeeper.znode.replication.peers.state", "peer-state");
        this.tableCFsNodeName = conf.get("zookeeper.znode.replication.peers.tableCFs", "tableCFs");
        this.ourClusterKey = ZKConfig.getZooKeeperClusterKey((Configuration)this.conf);
        this.replicationZNode = ZNodePaths.joinZNode((String)this.zookeeper.znodePaths.baseZNode, (String)replicationZNodeName);
        this.peersZNode = ZNodePaths.joinZNode((String)this.replicationZNode, (String)peersZNodeName);
        this.queuesZNode = ZNodePaths.joinZNode((String)this.replicationZNode, (String)queuesZNodeName);
        this.hfileRefsZNode = ZNodePaths.joinZNode((String)this.replicationZNode, (String)hfileRefsZNodeName);
    }

    protected List<String> getListOfReplicatorsZK() throws KeeperException {
        List result = null;
        try {
            result = ZKUtil.listChildrenNoWatch((ZKWatcher)this.zookeeper, (String)this.queuesZNode);
        }
        catch (KeeperException e) {
            this.abortable.abort("Failed to get list of replicators", (Throwable)e);
            throw e;
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static byte[] toByteArray(ReplicationProtos.ReplicationState.State state) {
        ReplicationProtos.ReplicationState msg = ReplicationProtos.ReplicationState.newBuilder().setState(state).build();
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            CodedOutputStream cos = CodedOutputStream.newInstance((OutputStream)baos, (int)16);
            msg.writeTo(cos);
            cos.flush();
            baos.flush();
            byte[] byArray = ProtobufUtil.prependPBMagic((byte[])baos.toByteArray());
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected boolean peerExists(String id) throws KeeperException {
        return ZKUtil.checkExists((ZKWatcher)this.zookeeper, (String)ZNodePaths.joinZNode((String)this.peersZNode, (String)id)) >= 0;
    }

    protected boolean isPeerPath(String path) {
        return path.split("/").length == this.peersZNode.split("/").length + 1;
    }

    @VisibleForTesting
    protected String getTableCFsNode(String id) {
        return ZNodePaths.joinZNode((String)this.peersZNode, (String)ZNodePaths.joinZNode((String)id, (String)this.tableCFsNodeName));
    }

    @VisibleForTesting
    protected String getPeerStateNode(String id) {
        return ZNodePaths.joinZNode((String)this.peersZNode, (String)ZNodePaths.joinZNode((String)id, (String)this.peerStateNodeName));
    }

    @VisibleForTesting
    protected String getPeerNode(String id) {
        return ZNodePaths.joinZNode((String)this.peersZNode, (String)id);
    }
}

