/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.ipc.RpcCallContext;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.protobuf.generated.RPCProtos;

@InterfaceAudience.Private
public final class VersionInfoUtil {
    private VersionInfoUtil() {
    }

    public static boolean currentClientHasMinimumVersion(int major, int minor) {
        RpcCallContext call = RpcServer.getCurrentCall();
        RPCProtos.VersionInfo versionInfo = call != null ? call.getClientVersionInfo() : null;
        return VersionInfoUtil.hasMinimumVersion(versionInfo, major, minor);
    }

    public static boolean hasMinimumVersion(RPCProtos.VersionInfo versionInfo, int major, int minor) {
        if (versionInfo != null) {
            try {
                int clientMajor;
                String[] components = versionInfo.getVersion().split("\\.");
                int n = clientMajor = components.length > 0 ? Integer.parseInt(components[0]) : 0;
                if (clientMajor != major) {
                    return clientMajor > major;
                }
                int clientMinor = components.length > 1 ? Integer.parseInt(components[1]) : 0;
                return clientMinor >= minor;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return false;
    }
}

