/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.ipc.CallRunner;

@InterfaceAudience.LimitedPrivate(value={"Coprocesssor", "Phoenix"})
@InterfaceStability.Evolving
public abstract class RpcScheduler {
    public static final String IPC_SERVER_MAX_CALLQUEUE_LENGTH = "hbase.ipc.server.max.callqueue.length";
    public static final String IPC_SERVER_PRIORITY_MAX_CALLQUEUE_LENGTH = "hbase.ipc.server.priority.max.callqueue.length";

    public abstract void init(Context var1);

    public abstract void start();

    public abstract void stop();

    public abstract boolean dispatch(CallRunner var1) throws IOException, InterruptedException;

    public abstract int getGeneralQueueLength();

    public abstract int getPriorityQueueLength();

    public abstract int getReplicationQueueLength();

    public abstract int getActiveRpcHandlerCount();

    public abstract long getNumGeneralCallsDropped();

    public abstract long getNumLifoModeSwitches();

    public static abstract class Context {
        public abstract InetSocketAddress getListenerAddress();
    }
}

