/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotDisabledException;
import org.apache.hadoop.hbase.TableNotEnabledException;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.UnknownRegionException;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.DoNotRetryRegionException;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionOfflineException;
import org.apache.hadoop.hbase.client.TableState;
import org.apache.hadoop.hbase.master.MasterFileSystem;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.TableStateManager;
import org.apache.hadoop.hbase.master.assignment.RegionStates;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.ProcedurePrepareLatch;
import org.apache.hadoop.hbase.master.procedure.TableProcedureInterface;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.StateMachineProcedure;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.ServerRegionReplicaUtil;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public abstract class AbstractStateMachineTableProcedure<TState>
extends StateMachineProcedure<MasterProcedureEnv, TState>
implements TableProcedureInterface {
    private final ProcedurePrepareLatch syncLatch;
    private User user;

    protected AbstractStateMachineTableProcedure() {
        this.syncLatch = null;
    }

    protected AbstractStateMachineTableProcedure(MasterProcedureEnv env) {
        this(env, null);
    }

    protected AbstractStateMachineTableProcedure(MasterProcedureEnv env, ProcedurePrepareLatch latch) {
        if (env != null) {
            this.user = env.getRequestUser();
            this.setOwner(this.user);
        }
        this.syncLatch = latch;
    }

    @Override
    public abstract TableName getTableName();

    @Override
    public abstract TableProcedureInterface.TableOperationType getTableOperationType();

    public void toStringClassDetails(StringBuilder sb) {
        sb.append(this.getClass().getSimpleName());
        sb.append(" table=");
        sb.append(this.getTableName());
    }

    protected boolean waitInitialized(MasterProcedureEnv env) {
        return env.waitInitialized((Procedure)this);
    }

    protected Procedure.LockState acquireLock(MasterProcedureEnv env) {
        if (env.getProcedureScheduler().waitTableExclusiveLock((Procedure<?>)this, this.getTableName())) {
            return Procedure.LockState.LOCK_EVENT_WAIT;
        }
        return Procedure.LockState.LOCK_ACQUIRED;
    }

    protected void releaseLock(MasterProcedureEnv env) {
        env.getProcedureScheduler().wakeTableExclusiveLock((Procedure<?>)this, this.getTableName());
    }

    protected User getUser() {
        return this.user;
    }

    protected void setUser(User user) {
        this.user = user;
    }

    protected void releaseSyncLatch() {
        ProcedurePrepareLatch.releaseLatch(this.syncLatch, (Procedure)this);
    }

    protected void checkTableModifiable(MasterProcedureEnv env) throws IOException {
        if (!MetaTableAccessor.tableExists((Connection)env.getMasterServices().getConnection(), (TableName)this.getTableName())) {
            throw new TableNotFoundException(this.getTableName());
        }
    }

    protected final Path getRegionDir(MasterProcedureEnv env, RegionInfo region) throws IOException {
        MasterFileSystem mfs = env.getMasterServices().getMasterFileSystem();
        Path tableDir = FSUtils.getTableDir((Path)mfs.getRootDir(), (TableName)this.getTableName());
        return new Path(tableDir, ServerRegionReplicaUtil.getRegionInfoForFs(region).getEncodedName());
    }

    protected void preflightChecks(MasterProcedureEnv env, Boolean enabled) throws HBaseIOException {
        MasterServices master = env.getMasterServices();
        if (!master.isClusterUp()) {
            throw new HBaseIOException("Cluster not up!");
        }
        if (master.isStopping() || master.isStopped()) {
            throw new HBaseIOException("Master stopping=" + master.isStopping() + ", stopped=" + master.isStopped());
        }
        if (enabled == null) {
            return;
        }
        try {
            this.checkTableModifiable(env);
            TableName tn = this.getTableName();
            TableStateManager tsm = master.getTableStateManager();
            TableState ts = tsm.getTableState(tn);
            if (enabled.booleanValue()) {
                if (!ts.isEnabledOrEnabling()) {
                    throw new TableNotEnabledException(tn);
                }
            } else if (!ts.isDisabledOrDisabling()) {
                throw new TableNotDisabledException(tn);
            }
        }
        catch (IOException ioe) {
            if (ioe instanceof HBaseIOException) {
                throw (HBaseIOException)((Object)ioe);
            }
            throw new HBaseIOException((Throwable)ioe);
        }
    }

    protected static void checkOnline(MasterProcedureEnv env, RegionInfo ri) throws DoNotRetryRegionException {
        RegionStates regionStates = env.getAssignmentManager().getRegionStates();
        RegionState rs = regionStates.getRegionState(ri);
        if (rs == null) {
            throw new UnknownRegionException("No RegionState found for " + ri.getEncodedName());
        }
        if (!rs.isOpened()) {
            throw new DoNotRetryRegionException(ri.getEncodedName() + " is not OPEN; regionState=" + rs);
        }
        if (ri.isSplitParent()) {
            throw new DoNotRetryRegionException(ri.getEncodedName() + " is not online (splitParent=true)");
        }
        if (ri.isSplit()) {
            throw new DoNotRetryRegionException(ri.getEncodedName() + " has split=true");
        }
        if (ri.isOffline()) {
            throw new DoNotRetryRegionException((Throwable)new RegionOfflineException(ri.getEncodedName()));
        }
    }
}

